/*
 * Decompiled with CFR 0.152.
 */
package com.gigamole.library;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BlurMaskFilter;
import android.graphics.Canvas;
import android.graphics.MaskFilter;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.support.annotation.FloatRange;
import android.util.AttributeSet;
import android.view.View;
import android.widget.FrameLayout;
import com.gigamole.library.R;

public class ShadowLayout
extends FrameLayout {
    private static final float DEFAULT_SHADOW_RADIUS = 30.0f;
    private static final float DEFAULT_SHADOW_DISTANCE = 15.0f;
    private static final float DEFAULT_SHADOW_ANGLE = 45.0f;
    private static final int DEFAULT_SHADOW_COLOR = -12303292;
    private static final float MAX_ANGLE = 360.0f;
    private static final float MIN_RADIUS = 0.1f;
    private static final float MIN_ANGLE = 0.0f;
    private final Paint mPaint = new Paint(1){
        {
            this.setDither(true);
            this.setFilterBitmap(true);
        }
    };
    private Bitmap mBitmap;
    private Canvas mCanvas = new Canvas();
    private Rect mBounds = new Rect();
    private boolean mInvalidateShadow = true;
    private boolean mIsShadowed;
    private int mShadowColor;
    private float mShadowRadius;
    private float mShadowDistance;
    private float mShadowAngle;
    private float mShadowDx;
    private float mShadowDy;

    public ShadowLayout(Context context) {
        this(context, null);
    }

    public ShadowLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShadowLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setWillNotDraw(false);
        this.setLayerType(2, this.mPaint);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.ShadowLayout);
        try {
            this.setIsShadowed(typedArray.getBoolean(R.styleable.ShadowLayout_sl_shadowed, true));
            this.setShadowRadius(typedArray.getDimension(R.styleable.ShadowLayout_sl_shadow_radius, 30.0f));
            this.setShadowDistance(typedArray.getDimension(R.styleable.ShadowLayout_sl_shadow_distance, 15.0f));
            this.setShadowAngle(typedArray.getInteger(R.styleable.ShadowLayout_sl_shadow_angle, 45));
            this.setShadowColor(typedArray.getColor(R.styleable.ShadowLayout_sl_shadow_color, -12303292));
        }
        finally {
            typedArray.recycle();
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mBitmap != null) {
            this.mBitmap.recycle();
            this.mBitmap = null;
        }
    }

    public boolean isShadowed() {
        return this.mIsShadowed;
    }

    public void setIsShadowed(boolean isShadowed) {
        this.mIsShadowed = isShadowed;
        this.postInvalidate();
    }

    public float getShadowDistance() {
        return this.mShadowDistance;
    }

    public void setShadowDistance(float shadowDistance) {
        this.mShadowDistance = shadowDistance;
        this.resetShadow();
    }

    public float getShadowAngle() {
        return this.mShadowAngle;
    }

    @FloatRange
    public void setShadowAngle(@FloatRange(from=0.0, to=360.0) float shadowAngle) {
        this.mShadowAngle = Math.max(0.0f, Math.min(shadowAngle, 360.0f));
        this.resetShadow();
    }

    public float getShadowRadius() {
        return this.mShadowRadius;
    }

    public void setShadowRadius(float shadowRadius) {
        this.mShadowRadius = Math.max(0.1f, shadowRadius);
        if (this.isInEditMode()) {
            return;
        }
        this.mPaint.setMaskFilter((MaskFilter)new BlurMaskFilter(this.mShadowRadius, BlurMaskFilter.Blur.NORMAL));
        this.resetShadow();
    }

    public int getShadowColor() {
        return this.mShadowColor;
    }

    public void setShadowColor(int shadowColor) {
        this.mShadowColor = shadowColor;
        this.mPaint.setColor(shadowColor);
        this.resetShadow();
    }

    public float getShadowDx() {
        return this.mShadowDx;
    }

    public float getShadowDy() {
        return this.mShadowDy;
    }

    private void resetShadow() {
        this.mShadowDx = (float)((double)this.mShadowDistance * Math.cos((double)(this.mShadowAngle / 180.0f) * Math.PI));
        this.mShadowDy = (float)((double)this.mShadowDistance * Math.sin((double)(this.mShadowAngle / 180.0f) * Math.PI));
        int padding = (int)(this.mShadowDistance + this.mShadowRadius);
        this.setPadding(padding, padding, padding, padding);
        this.requestLayout();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.mBounds.set(0, 0, View.MeasureSpec.getSize((int)widthMeasureSpec), View.MeasureSpec.getSize((int)heightMeasureSpec));
    }

    public void requestLayout() {
        this.mInvalidateShadow = true;
        super.requestLayout();
    }

    protected void dispatchDraw(Canvas canvas) {
        if (this.mIsShadowed) {
            if (this.mInvalidateShadow) {
                if (this.mBounds.width() != 0 && this.mBounds.height() != 0) {
                    this.mBitmap = Bitmap.createBitmap((int)this.mBounds.width(), (int)this.mBounds.height(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                    this.mCanvas.setBitmap(this.mBitmap);
                    this.mInvalidateShadow = false;
                    super.dispatchDraw(this.mCanvas);
                    Bitmap extractedAlpha = this.mBitmap.extractAlpha();
                    this.mCanvas.drawColor(0, PorterDuff.Mode.CLEAR);
                    this.mCanvas.drawBitmap(extractedAlpha, this.mShadowDx, this.mShadowDy, this.mPaint);
                    extractedAlpha.recycle();
                } else {
                    this.mBitmap = Bitmap.createBitmap((int)1, (int)1, (Bitmap.Config)Bitmap.Config.RGB_565);
                }
            }
            if (this.mCanvas != null && this.mBitmap != null && !this.mBitmap.isRecycled()) {
                canvas.drawBitmap(this.mBitmap, 0.0f, 0.0f, null);
            }
        }
        super.dispatchDraw(canvas);
    }
}

