/*
 * Decompiled with CFR 0.152.
 */
package com.gigamole.library.navigationtabstrip;

import android.animation.Animator;
import android.animation.ArgbEvaluator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.Configuration;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.v4.view.ViewPager;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.widget.Scroller;
import com.gigamole.library.R;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Random;

public class NavigationTabStrip
extends View
implements ViewPager.OnPageChangeListener {
    private static final String PREVIEW_TITLE = "Title";
    private static final int INVALID_INDEX = -1;
    private static final int DEFAULT_ANIMATION_DURATION = 350;
    private static final float DEFAULT_STRIP_FACTOR = 2.5f;
    private static final float DEFAULT_STRIP_WEIGHT = 10.0f;
    private static final float DEFAULT_CORNER_RADIUS = 5.0f;
    private static final int DEFAULT_INACTIVE_COLOR = -7829368;
    private static final int DEFAULT_ACTIVE_COLOR = -1;
    private static final int DEFAULT_STRIP_COLOR = -65536;
    private static final int DEFAULT_TITLE_SIZE = 0;
    private static final float TITLE_SIZE_FRACTION = 0.35f;
    private static final float MIN_FRACTION = 0.0f;
    private static final float MAX_FRACTION = 1.0f;
    private final RectF mBounds = new RectF();
    private final RectF mStripBounds = new RectF();
    private final Rect mTitleBounds = new Rect();
    private final Paint mStripPaint = new Paint(5){
        {
            this.setStyle(Paint.Style.FILL);
        }
    };
    private final Paint mTitlePaint = new TextPaint(5){
        {
            this.setTextAlign(Paint.Align.CENTER);
        }
    };
    private final ValueAnimator mAnimator = new ValueAnimator();
    private final ArgbEvaluator mColorEvaluator = new ArgbEvaluator();
    private final ResizeInterpolator mResizeInterpolator = new ResizeInterpolator();
    private int mAnimationDuration;
    private String[] mTitles;
    private ViewPager mViewPager;
    private ViewPager.OnPageChangeListener mOnPageChangeListener;
    private int mScrollState;
    private OnTabStripSelectedIndexListener mOnTabStripSelectedIndexListener;
    private Animator.AnimatorListener mAnimatorListener;
    private float mTabSize;
    private float mTitleSize;
    private StripType mStripType;
    private StripGravity mStripGravity;
    private float mStripWeight;
    private float mCornersRadius;
    private int mLastIndex = -1;
    private int mIndex = -1;
    private float mFraction;
    private float mStartStripX;
    private float mEndStripX;
    private float mStripLeft;
    private float mStripRight;
    private boolean mIsViewPagerMode;
    private boolean mIsResizeIn;
    private boolean mIsActionDown;
    private boolean mIsTabActionDown;
    private boolean mIsSetIndexFromTabBar;
    private int mInactiveColor;
    private int mActiveColor;
    private Typeface mTypeface;

    public NavigationTabStrip(Context context) {
        this(context, null);
    }

    public NavigationTabStrip(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NavigationTabStrip(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setWillNotDraw(false);
        this.setLayerType(2, null);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.NavigationTabStrip);
        try {
            Object[] titles;
            block14: {
                this.setStripColor(typedArray.getColor(R.styleable.NavigationTabStrip_nts_color, -65536));
                this.setTitleSize(typedArray.getDimension(R.styleable.NavigationTabStrip_nts_size, 0.0f));
                this.setStripWeight(typedArray.getDimension(R.styleable.NavigationTabStrip_nts_weight, 10.0f));
                this.setStripFactor(typedArray.getFloat(R.styleable.NavigationTabStrip_nts_factor, 2.5f));
                this.setStripType(typedArray.getInt(R.styleable.NavigationTabStrip_nts_type, 0));
                this.setStripGravity(typedArray.getInt(R.styleable.NavigationTabStrip_nts_gravity, 0));
                this.setTypeface(typedArray.getString(R.styleable.NavigationTabStrip_nts_typeface));
                this.setInactiveColor(typedArray.getColor(R.styleable.NavigationTabStrip_nts_inactive_color, -7829368));
                this.setActiveColor(typedArray.getColor(R.styleable.NavigationTabStrip_nts_active_color, -1));
                this.setAnimationDuration(typedArray.getInteger(R.styleable.NavigationTabStrip_nts_animation_duration, 350));
                this.setCornersRadius(typedArray.getDimension(R.styleable.NavigationTabStrip_nts_corners_radius, 5.0f));
                titles = null;
                try {
                    int titlesResId = typedArray.getResourceId(R.styleable.NavigationTabStrip_nts_titles, 0);
                    Object[] objectArray = titles = titlesResId == 0 ? null : typedArray.getResources().getStringArray(titlesResId);
                    if (titles != null) break block14;
                }
                catch (Exception exception) {
                    block15: {
                        try {
                            titles = null;
                            exception.printStackTrace();
                            if (titles != null) break block15;
                        }
                        catch (Throwable throwable) {
                            if (titles == null) {
                                if (this.isInEditMode()) {
                                    titles = new String[new Random().nextInt(5) + 1];
                                    Arrays.fill(titles, PREVIEW_TITLE);
                                } else {
                                    titles = new String[]{};
                                }
                            }
                            this.setTitles((String[])titles);
                            throw throwable;
                        }
                        if (this.isInEditMode()) {
                            titles = new String[new Random().nextInt(5) + 1];
                            Arrays.fill(titles, PREVIEW_TITLE);
                        } else {
                            titles = new String[]{};
                        }
                    }
                    this.setTitles((String[])titles);
                }
                if (this.isInEditMode()) {
                    titles = new String[new Random().nextInt(5) + 1];
                    Arrays.fill(titles, PREVIEW_TITLE);
                } else {
                    titles = new String[]{};
                }
            }
            this.setTitles((String[])titles);
            this.mAnimator.setFloatValues(new float[]{0.0f, 1.0f});
            this.mAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
            this.mAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    NavigationTabStrip.this.updateIndicatorPosition(((Float)animation.getAnimatedValue()).floatValue());
                }
            });
        }
        finally {
            typedArray.recycle();
        }
    }

    public int getAnimationDuration() {
        return this.mAnimationDuration;
    }

    public void setAnimationDuration(int animationDuration) {
        this.mAnimationDuration = animationDuration;
        this.mAnimator.setDuration((long)this.mAnimationDuration);
        this.resetScroller();
    }

    public String[] getTitles() {
        return this.mTitles;
    }

    public void setTitles(int ... titleResIds) {
        String[] titles = new String[titleResIds.length];
        for (int i = 0; i < titleResIds.length; ++i) {
            titles[i] = this.getResources().getString(titleResIds[i]);
        }
        this.setTitles(titles);
    }

    public void setTitles(String ... titles) {
        for (int i = 0; i < titles.length; ++i) {
            titles[i] = titles[i].toUpperCase();
        }
        this.mTitles = titles;
        this.requestLayout();
    }

    public int getStripColor() {
        return this.mStripPaint.getColor();
    }

    public void setStripColor(int color) {
        this.mStripPaint.setColor(color);
        this.postInvalidate();
    }

    public void setStripWeight(float stripWeight) {
        this.mStripWeight = stripWeight;
        this.requestLayout();
    }

    public StripGravity getStripGravity() {
        return this.mStripGravity;
    }

    private void setStripGravity(int index) {
        switch (index) {
            case 1: {
                this.setStripGravity(StripGravity.TOP);
                break;
            }
            default: {
                this.setStripGravity(StripGravity.BOTTOM);
            }
        }
    }

    public void setStripGravity(StripGravity stripGravity) {
        this.mStripGravity = stripGravity;
        this.requestLayout();
    }

    public StripType getStripType() {
        return this.mStripType;
    }

    private void setStripType(int index) {
        switch (index) {
            case 1: {
                this.setStripType(StripType.POINT);
                break;
            }
            default: {
                this.setStripType(StripType.LINE);
            }
        }
    }

    public void setStripType(StripType stripType) {
        this.mStripType = stripType;
        this.requestLayout();
    }

    public float getStripFactor() {
        return this.mResizeInterpolator.getFactor();
    }

    public void setStripFactor(float factor) {
        this.mResizeInterpolator.setFactor(factor);
    }

    public Typeface getTypeface() {
        return this.mTypeface;
    }

    public void setTypeface(String typeface) {
        Typeface tempTypeface;
        try {
            tempTypeface = Typeface.createFromAsset((AssetManager)this.getContext().getAssets(), (String)typeface);
        }
        catch (Exception e) {
            tempTypeface = Typeface.create((Typeface)Typeface.DEFAULT, (int)0);
            e.printStackTrace();
        }
        this.setTypeface(tempTypeface);
    }

    public void setTypeface(Typeface typeface) {
        this.mTypeface = typeface;
        this.mTitlePaint.setTypeface(typeface);
        this.postInvalidate();
    }

    public int getActiveColor() {
        return this.mActiveColor;
    }

    public void setActiveColor(int activeColor) {
        this.mActiveColor = activeColor;
        this.postInvalidate();
    }

    public int getInactiveColor() {
        return this.mInactiveColor;
    }

    public void setInactiveColor(int inactiveColor) {
        this.mInactiveColor = inactiveColor;
        this.postInvalidate();
    }

    public float getCornersRadius() {
        return this.mCornersRadius;
    }

    public void setCornersRadius(float cornersRadius) {
        this.mCornersRadius = cornersRadius;
        this.postInvalidate();
    }

    public float getTitleSize() {
        return this.mTitleSize;
    }

    public void setTitleSize(float titleSize) {
        this.mTitleSize = titleSize;
        this.mTitlePaint.setTextSize(titleSize);
        this.postInvalidate();
    }

    public OnTabStripSelectedIndexListener getOnTabStripSelectedIndexListener() {
        return this.mOnTabStripSelectedIndexListener;
    }

    public void setOnTabStripSelectedIndexListener(OnTabStripSelectedIndexListener onTabStripSelectedIndexListener) {
        this.mOnTabStripSelectedIndexListener = onTabStripSelectedIndexListener;
        if (this.mAnimatorListener == null) {
            this.mAnimatorListener = new Animator.AnimatorListener(){

                public void onAnimationStart(Animator animation) {
                    if (NavigationTabStrip.this.mOnTabStripSelectedIndexListener != null) {
                        NavigationTabStrip.this.mOnTabStripSelectedIndexListener.onStartTabSelected(NavigationTabStrip.this.mTitles[NavigationTabStrip.this.mIndex], NavigationTabStrip.this.mIndex);
                    }
                    animation.removeListener((Animator.AnimatorListener)this);
                    animation.addListener((Animator.AnimatorListener)this);
                }

                public void onAnimationEnd(Animator animation) {
                    if (NavigationTabStrip.this.mIsViewPagerMode) {
                        return;
                    }
                    animation.removeListener((Animator.AnimatorListener)this);
                    animation.addListener((Animator.AnimatorListener)this);
                    if (NavigationTabStrip.this.mOnTabStripSelectedIndexListener != null) {
                        NavigationTabStrip.this.mOnTabStripSelectedIndexListener.onEndTabSelected(NavigationTabStrip.this.mTitles[NavigationTabStrip.this.mIndex], NavigationTabStrip.this.mIndex);
                    }
                }

                public void onAnimationCancel(Animator animation) {
                }

                public void onAnimationRepeat(Animator animation) {
                }
            };
        }
        this.mAnimator.removeListener(this.mAnimatorListener);
        this.mAnimator.addListener(this.mAnimatorListener);
    }

    public void setViewPager(ViewPager viewPager) {
        if (viewPager == null) {
            this.mIsViewPagerMode = false;
            return;
        }
        if (this.mViewPager == viewPager) {
            return;
        }
        if (this.mViewPager != null) {
            this.mViewPager.setOnPageChangeListener(null);
        }
        if (viewPager.getAdapter() == null) {
            throw new IllegalStateException("ViewPager does not provide adapter instance.");
        }
        this.mIsViewPagerMode = true;
        this.mViewPager = viewPager;
        this.mViewPager.addOnPageChangeListener((ViewPager.OnPageChangeListener)this);
        this.resetScroller();
        this.postInvalidate();
    }

    public void setViewPager(ViewPager viewPager, int index) {
        this.setViewPager(viewPager);
        this.mIndex = index;
        if (this.mIsViewPagerMode) {
            this.mViewPager.setCurrentItem(index, true);
        }
        this.postInvalidate();
    }

    private void resetScroller() {
        if (this.mViewPager == null) {
            return;
        }
        try {
            Field scrollerField = ViewPager.class.getDeclaredField("mScroller");
            scrollerField.setAccessible(true);
            ResizeViewPagerScroller scroller = new ResizeViewPagerScroller(this.getContext());
            scrollerField.set(this.mViewPager, (Object)scroller);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setOnPageChangeListener(ViewPager.OnPageChangeListener listener) {
        this.mOnPageChangeListener = listener;
    }

    public int getTabIndex() {
        return this.mIndex;
    }

    public void setTabIndex(int index) {
        this.setTabIndex(index, false);
    }

    public void setTabIndex(int index, boolean force) {
        if (this.mAnimator.isRunning()) {
            return;
        }
        if (this.mTitles.length == 0) {
            return;
        }
        if (this.mIndex == -1) {
            force = true;
        }
        if (index == this.mIndex) {
            return;
        }
        this.mIsResizeIn = (index = Math.max(0, Math.min(index, this.mTitles.length - 1))) < this.mIndex;
        this.mLastIndex = this.mIndex;
        this.mIndex = index;
        this.mIsSetIndexFromTabBar = true;
        if (this.mIsViewPagerMode) {
            if (this.mViewPager == null) {
                throw new IllegalStateException("ViewPager is null.");
            }
            this.mViewPager.setCurrentItem(index, true);
        }
        this.mStartStripX = this.mStripLeft;
        this.mEndStripX = (float)this.mIndex * this.mTabSize + (this.mStripType == StripType.POINT ? this.mTabSize * 0.5f : 0.0f);
        if (force) {
            this.updateIndicatorPosition(1.0f);
        } else {
            this.mAnimator.start();
        }
    }

    private void updateIndicatorPosition(float fraction) {
        this.mFraction = fraction;
        this.mStripLeft = this.mStartStripX + this.mResizeInterpolator.getResizeInterpolation(fraction, this.mIsResizeIn) * (this.mEndStripX - this.mStartStripX);
        this.mStripRight = this.mStartStripX + (this.mStripType == StripType.LINE ? this.mTabSize : this.mStripWeight) + this.mResizeInterpolator.getResizeInterpolation(fraction, !this.mIsResizeIn) * (this.mEndStripX - this.mStartStripX);
        this.postInvalidate();
    }

    private void notifyDataSetChanged() {
        this.postInvalidate();
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.mAnimator.isRunning()) {
            return true;
        }
        if (this.mScrollState != 0) {
            return true;
        }
        switch (event.getAction()) {
            case 0: {
                this.mIsActionDown = true;
                if (!this.mIsViewPagerMode) break;
                this.mIsTabActionDown = (int)(event.getX() / this.mTabSize) == this.mIndex;
                break;
            }
            case 2: {
                if (this.mIsTabActionDown) {
                    this.mViewPager.setCurrentItem((int)(event.getX() / this.mTabSize), true);
                    break;
                }
                if (this.mIsActionDown) break;
            }
            case 1: {
                if (this.mIsActionDown) {
                    this.setTabIndex((int)(event.getX() / this.mTabSize));
                }
            }
            default: {
                this.mIsTabActionDown = false;
                this.mIsActionDown = false;
            }
        }
        return true;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        float width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        float height = View.MeasureSpec.getSize((int)heightMeasureSpec);
        this.mBounds.set(0.0f, 0.0f, width, height);
        if (this.mTitles.length == 0 || width == 0.0f || height == 0.0f) {
            return;
        }
        this.mTabSize = width / (float)this.mTitles.length;
        if ((int)this.mTitleSize == 0) {
            this.setTitleSize((height - this.mStripWeight) * 0.35f);
        }
        if (this.isInEditMode() || !this.mIsViewPagerMode) {
            this.mIsSetIndexFromTabBar = true;
            if (this.isInEditMode()) {
                this.mIndex = new Random().nextInt(this.mTitles.length);
            }
            this.mEndStripX = this.mStartStripX = (float)this.mIndex * this.mTabSize + (this.mStripType == StripType.POINT ? this.mTabSize * 0.5f : 0.0f);
            this.updateIndicatorPosition(1.0f);
        }
    }

    protected void onDraw(Canvas canvas) {
        this.mStripBounds.set(this.mStripLeft - (this.mStripType == StripType.POINT ? this.mStripWeight * 0.5f : 0.0f), this.mStripGravity == StripGravity.BOTTOM ? this.mBounds.height() - this.mStripWeight : 0.0f, this.mStripRight - (this.mStripType == StripType.POINT ? this.mStripWeight * 0.5f : 0.0f), this.mStripGravity == StripGravity.BOTTOM ? this.mBounds.height() : this.mStripWeight);
        if (this.mCornersRadius == 0.0f) {
            canvas.drawRect(this.mStripBounds, this.mStripPaint);
        } else {
            canvas.drawRoundRect(this.mStripBounds, this.mCornersRadius, this.mCornersRadius, this.mStripPaint);
        }
        for (int i = 0; i < this.mTitles.length; ++i) {
            String title = this.mTitles[i];
            float leftTitleOffset = this.mTabSize * (float)i + this.mTabSize * 0.5f;
            this.mTitlePaint.getTextBounds(title, 0, title.length(), this.mTitleBounds);
            float topTitleOffset = (this.mBounds.height() - this.mStripWeight) * 0.5f + (float)this.mTitleBounds.height() * 0.5f - (float)this.mTitleBounds.bottom;
            float interpolation = this.mResizeInterpolator.getResizeInterpolation(this.mFraction, true);
            float lastInterpolation = this.mResizeInterpolator.getResizeInterpolation(this.mFraction, false);
            if (this.mIsSetIndexFromTabBar) {
                if (this.mIndex == i) {
                    this.updateCurrentTitle(interpolation);
                } else if (this.mLastIndex == i) {
                    this.updateLastTitle(lastInterpolation);
                } else {
                    this.updateInactiveTitle();
                }
            } else if (i != this.mIndex && i != this.mIndex + 1) {
                this.updateInactiveTitle();
            } else if (i == this.mIndex + 1) {
                this.updateCurrentTitle(interpolation);
            } else if (i == this.mIndex) {
                this.updateLastTitle(lastInterpolation);
            }
            canvas.drawText(title, leftTitleOffset, topTitleOffset + (this.mStripGravity == StripGravity.TOP ? this.mStripWeight : 0.0f), this.mTitlePaint);
        }
    }

    private void updateCurrentTitle(float interpolation) {
        this.mTitlePaint.setColor(((Integer)this.mColorEvaluator.evaluate(interpolation, (Object)this.mInactiveColor, (Object)this.mActiveColor)).intValue());
    }

    private void updateLastTitle(float lastInterpolation) {
        this.mTitlePaint.setColor(((Integer)this.mColorEvaluator.evaluate(lastInterpolation, (Object)this.mActiveColor, (Object)this.mInactiveColor)).intValue());
    }

    private void updateInactiveTitle() {
        this.mTitlePaint.setColor(this.mInactiveColor);
    }

    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
        if (!this.mIsSetIndexFromTabBar) {
            this.mIsResizeIn = position < this.mIndex;
            this.mLastIndex = this.mIndex;
            this.mIndex = position;
            this.mStartStripX = (float)position * this.mTabSize + (this.mStripType == StripType.POINT ? this.mTabSize * 0.5f : 0.0f);
            this.mEndStripX = this.mStartStripX + this.mTabSize;
            this.updateIndicatorPosition(positionOffset);
        }
        if (this.mOnPageChangeListener != null) {
            this.mOnPageChangeListener.onPageScrolled(position, positionOffset, positionOffsetPixels);
        }
    }

    public void onPageSelected(int position) {
        if (this.mScrollState == 0) {
            this.mIsResizeIn = position < this.mIndex;
            this.mLastIndex = this.mIndex;
            this.mIndex = position;
            this.postInvalidate();
        }
    }

    public void onPageScrollStateChanged(int state) {
        if (state == 0) {
            this.mFraction = 0.0f;
            this.mIsSetIndexFromTabBar = false;
            if (this.mOnPageChangeListener != null) {
                this.mOnPageChangeListener.onPageSelected(this.mIndex);
            } else if (this.mOnTabStripSelectedIndexListener != null) {
                this.mOnTabStripSelectedIndexListener.onEndTabSelected(this.mTitles[this.mIndex], this.mIndex);
            }
        }
        this.mScrollState = state;
        if (this.mOnPageChangeListener != null) {
            this.mOnPageChangeListener.onPageScrollStateChanged(state);
        }
    }

    public void onRestoreInstanceState(Parcelable state) {
        SavedState savedState = (SavedState)state;
        super.onRestoreInstanceState(savedState.getSuperState());
        this.mIndex = savedState.index;
        this.requestLayout();
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState savedState = new SavedState(superState);
        savedState.index = this.mIndex;
        return savedState;
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.requestLayout();
        final int tempIndex = this.mIndex;
        this.setTabIndex(-1, true);
        this.post(new Runnable(){

            @Override
            public void run() {
                NavigationTabStrip.this.setTabIndex(tempIndex, true);
            }
        });
    }

    public static interface OnTabStripSelectedIndexListener {
        public void onStartTabSelected(String var1, int var2);

        public void onEndTabSelected(String var1, int var2);
    }

    public static enum StripGravity {
        BOTTOM,
        TOP;

        private static final int BOTTOM_INDEX = 0;
        private static final int TOP_INDEX = 1;
    }

    public static enum StripType {
        LINE,
        POINT;

        private static final int LINE_INDEX = 0;
        private static final int POINT_INDEX = 1;
    }

    private static class ResizeInterpolator
    implements Interpolator {
        private float mFactor;
        private boolean mResizeIn;

        private ResizeInterpolator() {
        }

        public float getFactor() {
            return this.mFactor;
        }

        public void setFactor(float factor) {
            this.mFactor = factor;
        }

        public float getInterpolation(float input) {
            if (this.mResizeIn) {
                return (float)(1.0 - Math.pow(1.0f - input, 2.0f * this.mFactor));
            }
            return (float)Math.pow(input, 2.0f * this.mFactor);
        }

        public float getResizeInterpolation(float input, boolean resizeIn) {
            this.mResizeIn = resizeIn;
            return this.getInterpolation(input);
        }
    }

    private class ResizeViewPagerScroller
    extends Scroller {
        public ResizeViewPagerScroller(Context context) {
            super(context, (Interpolator)new AccelerateDecelerateInterpolator());
        }

        public void startScroll(int startX, int startY, int dx, int dy, int duration) {
            super.startScroll(startX, startY, dx, dy, NavigationTabStrip.this.mAnimationDuration);
        }

        public void startScroll(int startX, int startY, int dx, int dy) {
            super.startScroll(startX, startY, dx, dy, NavigationTabStrip.this.mAnimationDuration);
        }
    }

    private static class SavedState
    extends View.BaseSavedState {
        int index;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        public SavedState(Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            this.index = in.readInt();
        }

        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeInt(this.index);
        }
    }
}

