/*
 * Decompiled with CFR 0.152.
 */
package com.gigamole.library.behavior;

import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.support.design.widget.CoordinatorLayout;
import android.support.design.widget.FloatingActionButton;
import android.support.design.widget.Snackbar;
import android.support.v4.view.ViewCompat;
import android.support.v4.view.ViewPropertyAnimatorCompat;
import android.support.v4.view.ViewPropertyAnimatorUpdateListener;
import android.support.v4.view.animation.LinearOutSlowInInterpolator;
import android.util.AttributeSet;
import android.util.Property;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Interpolator;
import com.gigamole.library.R;
import com.gigamole.library.behavior.VerticalScrollingBehavior;
import com.gigamole.library.ntb.NavigationTabBar;

public class NavigationTabBarBehavior
extends VerticalScrollingBehavior<NavigationTabBar> {
    private static final Interpolator INTERPOLATOR = new LinearOutSlowInInterpolator();
    private static final int ANIMATION_DURATION = 300;
    private ViewPropertyAnimatorCompat mTranslationAnimator;
    private ObjectAnimator mTranslationObjectAnimator;
    private Snackbar.SnackbarLayout mSnackbarLayout;
    private FloatingActionButton mFloatingActionButton;
    private int mSnackbarHeight = -1;
    private float mTargetOffset = 0.0f;
    private float mFabTargetOffset = 0.0f;
    private float mFabDefaultBottomMargin = 0.0f;
    private boolean mHidden;
    private boolean mFabBottomMarginInitialized;
    private boolean mBehaviorTranslationEnabled = true;

    public NavigationTabBarBehavior(boolean behaviorTranslationEnabled) {
        this.mBehaviorTranslationEnabled = behaviorTranslationEnabled;
    }

    public NavigationTabBarBehavior(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.NavigationTabBar);
        typedArray.recycle();
    }

    public boolean onLayoutChild(CoordinatorLayout parent, NavigationTabBar child, int layoutDirection) {
        return super.onLayoutChild(parent, (View)child, layoutDirection);
    }

    public boolean onDependentViewChanged(CoordinatorLayout parent, NavigationTabBar child, View dependency) {
        return super.onDependentViewChanged(parent, (View)child, dependency);
    }

    public void onDependentViewRemoved(CoordinatorLayout parent, NavigationTabBar child, View dependency) {
        super.onDependentViewRemoved(parent, (View)child, dependency);
    }

    public boolean layoutDependsOn(CoordinatorLayout parent, NavigationTabBar child, View dependency) {
        this.updateSnackbar(child, dependency);
        this.updateFloatingActionButton(child, dependency);
        return super.layoutDependsOn(parent, (View)child, dependency);
    }

    @Override
    public void onNestedVerticalOverScroll(CoordinatorLayout coordinatorLayout, NavigationTabBar child, int direction, int currentOverScroll, int totalOverScroll) {
    }

    @Override
    public void onDirectionNestedPreScroll(CoordinatorLayout coordinatorLayout, NavigationTabBar child, View target, int dx, int dy, int[] consumed, int scrollDirection) {
    }

    @Override
    protected boolean onNestedDirectionFling(CoordinatorLayout coordinatorLayout, NavigationTabBar child, View target, float velocityX, float velocityY, int scrollDirection) {
        return false;
    }

    @Override
    public void onNestedScroll(CoordinatorLayout coordinatorLayout, NavigationTabBar child, View target, int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed) {
        super.onNestedScroll(coordinatorLayout, child, target, dxConsumed, dyConsumed, dxUnconsumed, dyUnconsumed);
        if (dyConsumed < 0) {
            this.handleDirection(child, -1);
        } else if (dyConsumed > 0) {
            this.handleDirection(child, 1);
        }
    }

    @Override
    public boolean onStartNestedScroll(CoordinatorLayout coordinatorLayout, NavigationTabBar child, View directTargetChild, View target, int nestedScrollAxes) {
        return nestedScrollAxes == 2 || super.onStartNestedScroll(coordinatorLayout, child, directTargetChild, target, nestedScrollAxes);
    }

    private void handleDirection(NavigationTabBar child, int scrollDirection) {
        if (!this.mBehaviorTranslationEnabled) {
            return;
        }
        if (scrollDirection == -1 && this.mHidden) {
            this.mHidden = false;
            this.animateOffset(child, 0, false, true);
        } else if (scrollDirection == 1 && !this.mHidden) {
            this.mHidden = true;
            this.animateOffset(child, child.getHeight(), false, true);
        }
    }

    private void animateOffset(NavigationTabBar child, int offset, boolean forceAnimation, boolean withAnimation) {
        if (!this.mBehaviorTranslationEnabled && !forceAnimation) {
            return;
        }
        if (Build.VERSION.SDK_INT < 19) {
            this.ensureOrCancelObjectAnimation(child, offset, withAnimation);
            this.mTranslationObjectAnimator.start();
        } else {
            this.ensureOrCancelAnimator(child, withAnimation);
            this.mTranslationAnimator.translationY((float)offset).start();
        }
    }

    private void ensureOrCancelAnimator(final NavigationTabBar child, boolean withAnimation) {
        if (this.mTranslationAnimator == null) {
            this.mTranslationAnimator = ViewCompat.animate((View)child);
            this.mTranslationAnimator.setDuration(withAnimation ? 300L : 0L);
            this.mTranslationAnimator.setUpdateListener(new ViewPropertyAnimatorUpdateListener(){

                public void onAnimationUpdate(View view) {
                    ViewGroup.MarginLayoutParams p;
                    if (NavigationTabBarBehavior.this.mSnackbarLayout != null && NavigationTabBarBehavior.this.mSnackbarLayout.getLayoutParams() instanceof ViewGroup.MarginLayoutParams) {
                        NavigationTabBarBehavior.this.mTargetOffset = child.getBarHeight() - view.getTranslationY();
                        p = (ViewGroup.MarginLayoutParams)NavigationTabBarBehavior.this.mSnackbarLayout.getLayoutParams();
                        p.setMargins(p.leftMargin, p.topMargin, p.rightMargin, (int)NavigationTabBarBehavior.this.mTargetOffset);
                        NavigationTabBarBehavior.this.mSnackbarLayout.requestLayout();
                    }
                    if (NavigationTabBarBehavior.this.mFloatingActionButton != null && NavigationTabBarBehavior.this.mFloatingActionButton.getLayoutParams() instanceof ViewGroup.MarginLayoutParams) {
                        p = (ViewGroup.MarginLayoutParams)NavigationTabBarBehavior.this.mFloatingActionButton.getLayoutParams();
                        NavigationTabBarBehavior.this.mFabTargetOffset = NavigationTabBarBehavior.this.mFabDefaultBottomMargin - view.getTranslationY();
                        p.setMargins(p.leftMargin, p.topMargin, p.rightMargin, (int)NavigationTabBarBehavior.this.mFabTargetOffset);
                        NavigationTabBarBehavior.this.mFloatingActionButton.requestLayout();
                    }
                }
            });
            this.mTranslationAnimator.setInterpolator(INTERPOLATOR);
        } else {
            this.mTranslationAnimator.setDuration(withAnimation ? 300L : 0L);
            this.mTranslationAnimator.cancel();
        }
    }

    private static ObjectAnimator objectAnimatorOfTranslationY(View target, int offset) {
        ObjectAnimator res;
        if (Build.VERSION.SDK_INT >= 14) {
            res = ObjectAnimator.ofFloat((Object)target, (Property)View.TRANSLATION_Y, (float[])new float[]{offset});
        } else {
            res = new ObjectAnimator();
            res.setTarget((Object)target);
            res.setPropertyName("translationY");
            res.setFloatValues(new float[]{offset});
        }
        return res;
    }

    private void ensureOrCancelObjectAnimation(final NavigationTabBar child, int offset, boolean withAnimation) {
        if (this.mTranslationObjectAnimator != null) {
            this.mTranslationObjectAnimator.cancel();
        }
        this.mTranslationObjectAnimator = NavigationTabBarBehavior.objectAnimatorOfTranslationY(child, offset);
        this.mTranslationObjectAnimator.setDuration(withAnimation ? 300L : 0L);
        this.mTranslationObjectAnimator.setInterpolator((TimeInterpolator)INTERPOLATOR);
        this.mTranslationObjectAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                ViewGroup.MarginLayoutParams p;
                if (NavigationTabBarBehavior.this.mSnackbarLayout != null && NavigationTabBarBehavior.this.mSnackbarLayout.getLayoutParams() instanceof ViewGroup.MarginLayoutParams) {
                    NavigationTabBarBehavior.this.mTargetOffset = child.getBarHeight() - child.getTranslationY();
                    p = (ViewGroup.MarginLayoutParams)NavigationTabBarBehavior.this.mSnackbarLayout.getLayoutParams();
                    p.setMargins(p.leftMargin, p.topMargin, p.rightMargin, (int)NavigationTabBarBehavior.this.mTargetOffset);
                    NavigationTabBarBehavior.this.mSnackbarLayout.requestLayout();
                }
                if (NavigationTabBarBehavior.this.mFloatingActionButton != null && NavigationTabBarBehavior.this.mFloatingActionButton.getLayoutParams() instanceof ViewGroup.MarginLayoutParams) {
                    NavigationTabBarBehavior.this.mFabTargetOffset = NavigationTabBarBehavior.this.mFabDefaultBottomMargin - child.getTranslationY();
                    p = (ViewGroup.MarginLayoutParams)NavigationTabBarBehavior.this.mFloatingActionButton.getLayoutParams();
                    p.setMargins(p.leftMargin, p.topMargin, p.rightMargin, (int)NavigationTabBarBehavior.this.mFabTargetOffset);
                    NavigationTabBarBehavior.this.mFloatingActionButton.requestLayout();
                }
            }
        });
    }

    public static NavigationTabBarBehavior from(NavigationTabBar view) {
        ViewGroup.LayoutParams params = view.getLayoutParams();
        if (!(params instanceof CoordinatorLayout.LayoutParams)) {
            throw new IllegalArgumentException("The view is not a child of CoordinatorLayout");
        }
        CoordinatorLayout.Behavior behavior = ((CoordinatorLayout.LayoutParams)params).getBehavior();
        if (!(behavior instanceof NavigationTabBarBehavior)) {
            throw new IllegalArgumentException("The view is not associated with NavigationTabBarBehavior");
        }
        return (NavigationTabBarBehavior)behavior;
    }

    public void setBehaviorTranslationEnabled(boolean behaviorTranslationEnabled) {
        this.mBehaviorTranslationEnabled = behaviorTranslationEnabled;
    }

    public void hideView(NavigationTabBar view, int offset, boolean withAnimation) {
        if (!this.mHidden) {
            this.mHidden = true;
            this.animateOffset(view, offset, true, withAnimation);
        }
    }

    public void resetOffset(NavigationTabBar view, boolean withAnimation) {
        if (this.mHidden) {
            this.mHidden = false;
            this.animateOffset(view, 0, true, withAnimation);
        }
    }

    public void updateSnackbar(final NavigationTabBar child, View dependency) {
        if (dependency != null && dependency instanceof Snackbar.SnackbarLayout) {
            this.mSnackbarLayout = (Snackbar.SnackbarLayout)dependency;
            if (Build.VERSION.SDK_INT >= 19) {
                this.mSnackbarLayout.addOnLayoutChangeListener(new View.OnLayoutChangeListener(){

                    public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
                        if (NavigationTabBarBehavior.this.mFloatingActionButton != null && NavigationTabBarBehavior.this.mFloatingActionButton.getLayoutParams() instanceof ViewGroup.MarginLayoutParams) {
                            NavigationTabBarBehavior.this.mFabTargetOffset = NavigationTabBarBehavior.this.mFabDefaultBottomMargin - child.getTranslationY();
                            ViewGroup.MarginLayoutParams p = (ViewGroup.MarginLayoutParams)NavigationTabBarBehavior.this.mFloatingActionButton.getLayoutParams();
                            p.setMargins(p.leftMargin, p.topMargin, p.rightMargin, (int)NavigationTabBarBehavior.this.mFabTargetOffset);
                            NavigationTabBarBehavior.this.mFloatingActionButton.requestLayout();
                        }
                    }
                });
            }
            if (this.mSnackbarHeight == -1) {
                this.mSnackbarHeight = dependency.getHeight();
            }
            int targetMargin = (int)(child.getBarHeight() - child.getTranslationY());
            if (Build.VERSION.SDK_INT < 21) {
                child.bringToFront();
            }
            if (dependency.getLayoutParams() instanceof ViewGroup.MarginLayoutParams) {
                ViewGroup.MarginLayoutParams p = (ViewGroup.MarginLayoutParams)dependency.getLayoutParams();
                p.setMargins(p.leftMargin, p.topMargin, p.rightMargin, targetMargin);
                dependency.requestLayout();
            }
        }
    }

    public void updateFloatingActionButton(NavigationTabBar child, View dependency) {
        if (dependency != null && dependency instanceof FloatingActionButton) {
            this.mFloatingActionButton = (FloatingActionButton)dependency;
            if (!this.mFabBottomMarginInitialized && dependency.getLayoutParams() instanceof ViewGroup.MarginLayoutParams) {
                this.mFabBottomMarginInitialized = true;
                ViewGroup.MarginLayoutParams p = (ViewGroup.MarginLayoutParams)dependency.getLayoutParams();
                this.mFabDefaultBottomMargin = p.bottomMargin;
            }
        }
    }
}

