/*
 * Decompiled with CFR 0.152.
 */
package com.gigamole.library;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.Configuration;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.graphics.Xfermode;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.v4.view.ViewPager;
import android.text.TextPaint;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.widget.Scroller;
import com.gigamole.library.R;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class NavigationTabBar
extends View
implements ViewPager.OnPageChangeListener {
    private static final String PREVIEW_BADGE = "0";
    private static final String PREVIEW_TITLE = "Title";
    private static final int INVALID_INDEX = -1;
    private static final int DEFAULT_BADGE_ANIMATION_DURATION = 200;
    private static final int DEFAULT_BADGE_REFRESH_ANIMATION_DURATION = 100;
    private static final int DEFAULT_ANIMATION_DURATION = 300;
    private static final int DEFAULT_INACTIVE_COLOR = Color.parseColor((String)"#9f90af");
    private static final int DEFAULT_ACTIVE_COLOR = -1;
    private static final float MIN_FRACTION = 0.0f;
    private static final float NON_SCALED_FRACTION = 0.35f;
    private static final float MAX_FRACTION = 1.0f;
    private static final int MIN_ALPHA = 0;
    private static final int MAX_ALPHA = 255;
    private static final float ACTIVE_ICON_SCALE_BY = 0.3f;
    private static final float ICON_SIZE_FRACTION = 0.45f;
    private static final float TITLE_ACTIVE_ICON_SCALE_BY = 0.2f;
    private static final float TITLE_ICON_SIZE_FRACTION = 0.45f;
    private static final float TITLE_ACTIVE_SCALE_BY = 0.2f;
    private static final float TITLE_SIZE_FRACTION = 0.2f;
    private static final float TITLE_MARGIN_FRACTION = 0.15f;
    private static final float BADGE_HORIZONTAL_FRACTION = 0.5f;
    private static final float BADGE_VERTICAL_FRACTION = 0.75f;
    private static final float BADGE_TITLE_SIZE_FRACTION = 0.9f;
    private static final int ALL_INDEX = 0;
    private static final int ACTIVE_INDEX = 1;
    private static final int LEFT_INDEX = 0;
    private static final int CENTER_INDEX = 1;
    private static final int RIGHT_INDEX = 2;
    private static final int TOP_INDEX = 0;
    private static final int BOTTOM_INDEX = 1;
    private static final float LEFT_FRACTION = 0.25f;
    private static final float CENTER_FRACTION = 0.5f;
    private static final float RIGHT_FRACTION = 0.75f;
    private static final Interpolator DECELERATE_INTERPOLATOR = new DecelerateInterpolator();
    private static final Interpolator ACCELERATE_INTERPOLATOR = new AccelerateInterpolator();
    private final RectF mBounds;
    private final RectF mPointerBounds;
    private final Rect mBadgeBounds;
    private final RectF mBgBadgeBounds;
    private Bitmap mBitmap;
    private Canvas mCanvas;
    private Bitmap mIconsBitmap;
    private Canvas mIconsCanvas;
    private Bitmap mPointerBitmap;
    private Canvas mPointerCanvas;
    private final Paint mPaint;
    private final Paint mPointerPaint;
    private final Paint mIconPaint;
    private final Paint mSelectedIconPaint;
    private final Paint mIconPointerPaint;
    private final Paint mModelTitlePaint;
    private final Paint mBadgePaint;
    private final ValueAnimator mAnimator;
    private final ResizeInterpolator mResizeInterpolator;
    private int mAnimationDuration;
    private List<Model> mModels;
    private ViewPager mViewPager;
    private ViewPager.OnPageChangeListener mOnPageChangeListener;
    private int mScrollState;
    private OnTabBarSelectedIndexListener mOnTabBarSelectedIndexListener;
    private Animator.AnimatorListener mAnimatorListener;
    private float mModelSize;
    private int mIconSize;
    private float mCornersRadius;
    private float mModelTitleSize;
    private float mTitleMargin;
    private float mBadgeMargin;
    private float mBadgeTitleSize;
    private TitleMode mTitleMode;
    private BadgePosition mBadgePosition;
    private BadgeGravity mBadgeGravity;
    private int mBadgeTitleColor;
    private int mBadgeBgColor;
    private int mLastIndex;
    private int mIndex;
    private float mFraction;
    private float mStartPointerX;
    private float mEndPointerX;
    private float mPointerLeftTop;
    private float mPointerRightBottom;
    private boolean mIsTitled;
    private boolean mIsBadged;
    private boolean mIsScaled;
    private boolean mIsBadgeUseTypeface;
    private boolean mIsViewPagerMode;
    private boolean mIsHorizontalOrientation;
    private boolean mIsResizeIn;
    private boolean mIsActionDown;
    private boolean mIsPointerActionDown;
    private boolean mIsSetIndexFromTabBar;
    private int mInactiveColor;
    private int mActiveColor;
    private Typeface mTypeface;

    public NavigationTabBar(Context context) {
        this(context, null);
    }

    public NavigationTabBar(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NavigationTabBar(Context context, AttributeSet attrs, int defStyleAttr) {
        block10: {
            super(context, attrs, defStyleAttr);
            this.mBounds = new RectF();
            this.mPointerBounds = new RectF();
            this.mBadgeBounds = new Rect();
            this.mBgBadgeBounds = new RectF();
            this.mPaint = new Paint(1){
                {
                    this.setDither(true);
                    this.setStyle(Paint.Style.FILL);
                }
            };
            this.mPointerPaint = new Paint(1){
                {
                    this.setDither(true);
                    this.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_IN));
                }
            };
            this.mIconPaint = new Paint(1){
                {
                    this.setDither(true);
                }
            };
            this.mSelectedIconPaint = new Paint(1){
                {
                    this.setDither(true);
                }
            };
            this.mIconPointerPaint = new Paint(1){
                {
                    this.setStyle(Paint.Style.FILL);
                    this.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
                }
            };
            this.mModelTitlePaint = new TextPaint(1){
                {
                    this.setDither(true);
                    this.setColor(-1);
                    this.setTextAlign(Paint.Align.CENTER);
                }
            };
            this.mBadgePaint = new TextPaint(1){
                {
                    this.setDither(true);
                    this.setTextAlign(Paint.Align.CENTER);
                    this.setFakeBoldText(true);
                }
            };
            this.mAnimator = new ValueAnimator();
            this.mResizeInterpolator = new ResizeInterpolator();
            this.mModels = new ArrayList<Model>();
            this.mLastIndex = -1;
            this.mIndex = -1;
            this.setWillNotDraw(false);
            this.setLayerType(2, null);
            TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.NavigationTabBar);
            try {
                this.setIsTitled(typedArray.getBoolean(R.styleable.NavigationTabBar_ntb_titled, false));
                this.setIsBadged(typedArray.getBoolean(R.styleable.NavigationTabBar_ntb_badged, false));
                this.setIsScaled(typedArray.getBoolean(R.styleable.NavigationTabBar_ntb_scaled, true));
                this.setIsBadgeUseTypeface(typedArray.getBoolean(R.styleable.NavigationTabBar_ntb_badge_use_typeface, false));
                this.setTitleMode(typedArray.getInt(R.styleable.NavigationTabBar_ntb_title_mode, 0));
                this.setBadgePosition(typedArray.getInt(R.styleable.NavigationTabBar_ntb_badge_position, 2));
                this.setBadgeGravity(typedArray.getInt(R.styleable.NavigationTabBar_ntb_badge_gravity, 0));
                this.setBadgeBgColor(typedArray.getColor(R.styleable.NavigationTabBar_ntb_badge_bg_color, 0));
                this.setBadgeTitleColor(typedArray.getColor(R.styleable.NavigationTabBar_ntb_badge_title_color, 0));
                this.setTypeface(typedArray.getString(R.styleable.NavigationTabBar_ntb_typeface));
                this.setInactiveColor(typedArray.getColor(R.styleable.NavigationTabBar_ntb_inactive_color, DEFAULT_INACTIVE_COLOR));
                this.setActiveColor(typedArray.getColor(R.styleable.NavigationTabBar_ntb_active_color, -1));
                this.setAnimationDuration(typedArray.getInteger(R.styleable.NavigationTabBar_ntb_animation_duration, 300));
                this.setCornersRadius(typedArray.getDimension(R.styleable.NavigationTabBar_ntb_corners_radius, 0.0f));
                this.mAnimator.setFloatValues(new float[]{0.0f, 1.0f});
                this.mAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
                this.mAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                    public void onAnimationUpdate(ValueAnimator animation) {
                        NavigationTabBar.this.updateIndicatorPosition(((Float)animation.getAnimatedValue()).floatValue());
                    }
                });
                if (!this.isInEditMode()) break block10;
                String[] previewColors = null;
                try {
                    int previewColorsId = typedArray.getResourceId(R.styleable.NavigationTabBar_ntb_preview_colors, 0);
                    previewColors = previewColorsId == 0 ? null : typedArray.getResources().getStringArray(previewColorsId);
                }
                catch (Exception exception) {
                    previewColors = null;
                    exception.printStackTrace();
                }
                finally {
                    if (previewColors == null) {
                        previewColors = typedArray.getResources().getStringArray(R.array.default_preview);
                    }
                    for (String previewColor : previewColors) {
                        this.mModels.add(new Model.Builder(null, Color.parseColor((String)previewColor)).build());
                    }
                    this.requestLayout();
                }
            }
            finally {
                typedArray.recycle();
            }
        }
    }

    public int getAnimationDuration() {
        return this.mAnimationDuration;
    }

    public void setAnimationDuration(int animationDuration) {
        this.mAnimationDuration = animationDuration;
        this.mAnimator.setDuration((long)this.mAnimationDuration);
        this.resetScroller();
    }

    public List<Model> getModels() {
        return this.mModels;
    }

    public void setModels(List<Model> models) {
        for (final Model model : models) {
            model.mBadgeAnimator.removeAllUpdateListeners();
            model.mBadgeAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    model.mBadgeFraction = ((Float)animation.getAnimatedValue()).floatValue();
                    NavigationTabBar.this.postInvalidate();
                }
            });
        }
        this.mModels.clear();
        this.mModels = models;
        this.requestLayout();
    }

    public boolean isTitled() {
        return this.mIsTitled;
    }

    public void setIsTitled(boolean isTitled) {
        this.mIsTitled = isTitled;
        this.requestLayout();
    }

    public boolean isBadged() {
        return this.mIsBadged;
    }

    public void setIsBadged(boolean isBadged) {
        this.mIsBadged = isBadged;
        this.requestLayout();
    }

    public boolean isScaled() {
        return this.mIsScaled;
    }

    public void setIsScaled(boolean isScaled) {
        this.mIsScaled = isScaled;
        this.requestLayout();
    }

    public boolean isBadgeUseTypeface() {
        return this.mIsBadgeUseTypeface;
    }

    public void setIsBadgeUseTypeface(boolean isBadgeUseTypeface) {
        this.mIsBadgeUseTypeface = isBadgeUseTypeface;
        this.setBadgeTypeface();
        this.postInvalidate();
    }

    public TitleMode getTitleMode() {
        return this.mTitleMode;
    }

    private void setTitleMode(int index) {
        switch (index) {
            case 1: {
                this.setTitleMode(TitleMode.ACTIVE);
                break;
            }
            default: {
                this.setTitleMode(TitleMode.ALL);
            }
        }
    }

    public void setTitleMode(TitleMode titleMode) {
        this.mTitleMode = titleMode;
        this.postInvalidate();
    }

    public BadgePosition getBadgePosition() {
        return this.mBadgePosition;
    }

    private void setBadgePosition(int index) {
        switch (index) {
            case 0: {
                this.setBadgePosition(BadgePosition.LEFT);
                break;
            }
            case 1: {
                this.setBadgePosition(BadgePosition.CENTER);
                break;
            }
            default: {
                this.setBadgePosition(BadgePosition.RIGHT);
            }
        }
    }

    public void setBadgePosition(BadgePosition badgePosition) {
        this.mBadgePosition = badgePosition;
        this.postInvalidate();
    }

    public BadgeGravity getBadgeGravity() {
        return this.mBadgeGravity;
    }

    private void setBadgeGravity(int index) {
        switch (index) {
            case 1: {
                this.setBadgeGravity(BadgeGravity.BOTTOM);
                break;
            }
            default: {
                this.setBadgeGravity(BadgeGravity.TOP);
            }
        }
    }

    public void setBadgeGravity(BadgeGravity badgeGravity) {
        this.mBadgeGravity = badgeGravity;
        this.requestLayout();
    }

    public int getBadgeBgColor() {
        return this.mBadgeBgColor;
    }

    public void setBadgeBgColor(int badgeBgColor) {
        this.mBadgeBgColor = badgeBgColor;
    }

    public int getBadgeTitleColor() {
        return this.mBadgeTitleColor;
    }

    public void setBadgeTitleColor(int badgeTitleColor) {
        this.mBadgeTitleColor = badgeTitleColor;
    }

    public Typeface getTypeface() {
        return this.mTypeface;
    }

    public void setTypeface(String typeface) {
        Typeface tempTypeface;
        if (TextUtils.isEmpty((CharSequence)typeface)) {
            return;
        }
        try {
            tempTypeface = Typeface.createFromAsset((AssetManager)this.getContext().getAssets(), (String)typeface);
        }
        catch (Exception e) {
            tempTypeface = Typeface.create((Typeface)Typeface.DEFAULT, (int)0);
            e.printStackTrace();
        }
        this.setTypeface(tempTypeface);
    }

    public void setTypeface(Typeface typeface) {
        this.mTypeface = typeface;
        this.mModelTitlePaint.setTypeface(typeface);
        this.setBadgeTypeface();
        this.postInvalidate();
    }

    private void setBadgeTypeface() {
        this.mBadgePaint.setTypeface(this.mIsBadgeUseTypeface ? this.mTypeface : Typeface.create((Typeface)Typeface.DEFAULT, (int)0));
    }

    public int getActiveColor() {
        return this.mActiveColor;
    }

    public void setActiveColor(int activeColor) {
        this.mActiveColor = activeColor;
        this.mIconPointerPaint.setColor(activeColor);
        this.postInvalidate();
    }

    public int getInactiveColor() {
        return this.mInactiveColor;
    }

    public void setInactiveColor(int inactiveColor) {
        this.mInactiveColor = inactiveColor;
        this.mIconPaint.setColorFilter((ColorFilter)new PorterDuffColorFilter(inactiveColor, PorterDuff.Mode.SRC_IN));
        this.mSelectedIconPaint.setColorFilter((ColorFilter)new PorterDuffColorFilter(inactiveColor, PorterDuff.Mode.SRC_IN));
        this.mModelTitlePaint.setColor(this.mInactiveColor);
        this.postInvalidate();
    }

    public float getCornersRadius() {
        return this.mCornersRadius;
    }

    public void setCornersRadius(float cornersRadius) {
        this.mCornersRadius = cornersRadius;
        this.postInvalidate();
    }

    public float getBadgeMargin() {
        return this.mBadgeMargin;
    }

    public float getBarHeight() {
        return this.mBounds.height();
    }

    public OnTabBarSelectedIndexListener getOnTabBarSelectedIndexListener() {
        return this.mOnTabBarSelectedIndexListener;
    }

    public void setOnTabBarSelectedIndexListener(OnTabBarSelectedIndexListener onTabBarSelectedIndexListener) {
        this.mOnTabBarSelectedIndexListener = onTabBarSelectedIndexListener;
        if (this.mAnimatorListener == null) {
            this.mAnimatorListener = new Animator.AnimatorListener(){

                public void onAnimationStart(Animator animation) {
                    if (NavigationTabBar.this.mOnTabBarSelectedIndexListener != null) {
                        NavigationTabBar.this.mOnTabBarSelectedIndexListener.onStartTabSelected((Model)NavigationTabBar.this.mModels.get(NavigationTabBar.this.mIndex), NavigationTabBar.this.mIndex);
                    }
                    animation.removeListener((Animator.AnimatorListener)this);
                    animation.addListener((Animator.AnimatorListener)this);
                }

                public void onAnimationEnd(Animator animation) {
                    if (NavigationTabBar.this.mIsViewPagerMode) {
                        return;
                    }
                    animation.removeListener((Animator.AnimatorListener)this);
                    animation.addListener((Animator.AnimatorListener)this);
                    if (NavigationTabBar.this.mOnTabBarSelectedIndexListener != null) {
                        NavigationTabBar.this.mOnTabBarSelectedIndexListener.onEndTabSelected((Model)NavigationTabBar.this.mModels.get(NavigationTabBar.this.mIndex), NavigationTabBar.this.mIndex);
                    }
                }

                public void onAnimationCancel(Animator animation) {
                }

                public void onAnimationRepeat(Animator animation) {
                }
            };
        }
        this.mAnimator.removeListener(this.mAnimatorListener);
        this.mAnimator.addListener(this.mAnimatorListener);
    }

    public void setViewPager(ViewPager viewPager) {
        if (viewPager == null) {
            this.mIsViewPagerMode = false;
            return;
        }
        if (this.mViewPager == viewPager) {
            return;
        }
        if (this.mViewPager != null) {
            this.mViewPager.setOnPageChangeListener(null);
        }
        if (viewPager.getAdapter() == null) {
            throw new IllegalStateException("ViewPager does not provide adapter instance.");
        }
        this.mIsViewPagerMode = true;
        this.mViewPager = viewPager;
        this.mViewPager.addOnPageChangeListener((ViewPager.OnPageChangeListener)this);
        this.resetScroller();
        this.postInvalidate();
    }

    public void setViewPager(ViewPager viewPager, int index) {
        this.setViewPager(viewPager);
        this.mIndex = index;
        if (this.mIsViewPagerMode) {
            this.mViewPager.setCurrentItem(index, true);
        }
        this.postInvalidate();
    }

    private void resetScroller() {
        if (this.mViewPager == null) {
            return;
        }
        try {
            Field scrollerField = ViewPager.class.getDeclaredField("mScroller");
            scrollerField.setAccessible(true);
            ResizeViewPagerScroller scroller = new ResizeViewPagerScroller(this.getContext());
            scrollerField.set(this.mViewPager, (Object)scroller);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setOnPageChangeListener(ViewPager.OnPageChangeListener listener) {
        this.mOnPageChangeListener = listener;
    }

    public int getModelIndex() {
        return this.mIndex;
    }

    public void setModelIndex(int index) {
        this.setModelIndex(index, false);
    }

    public void setModelIndex(int index, boolean force) {
        if (this.mAnimator.isRunning()) {
            return;
        }
        if (this.mModels.isEmpty()) {
            return;
        }
        if (this.mIndex == -1) {
            force = true;
        }
        if (index == this.mIndex) {
            return;
        }
        this.mIsResizeIn = (index = Math.max(0, Math.min(index, this.mModels.size() - 1))) < this.mIndex;
        this.mLastIndex = this.mIndex;
        this.mIndex = index;
        this.mIsSetIndexFromTabBar = true;
        if (this.mIsViewPagerMode) {
            if (this.mViewPager == null) {
                throw new IllegalStateException("ViewPager is null.");
            }
            this.mViewPager.setCurrentItem(index, true);
        }
        this.mStartPointerX = this.mPointerLeftTop;
        this.mEndPointerX = (float)this.mIndex * this.mModelSize;
        if (force) {
            this.updateIndicatorPosition(1.0f);
        } else {
            this.mAnimator.start();
        }
    }

    private void updateIndicatorPosition(float fraction) {
        this.mFraction = fraction;
        this.mPointerLeftTop = this.mStartPointerX + this.mResizeInterpolator.getResizeInterpolation(fraction, this.mIsResizeIn) * (this.mEndPointerX - this.mStartPointerX);
        this.mPointerRightBottom = this.mStartPointerX + this.mModelSize + this.mResizeInterpolator.getResizeInterpolation(fraction, !this.mIsResizeIn) * (this.mEndPointerX - this.mStartPointerX);
        this.postInvalidate();
    }

    private void notifyDataSetChanged() {
        this.postInvalidate();
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.mAnimator.isRunning()) {
            return true;
        }
        if (this.mScrollState != 0) {
            return true;
        }
        switch (event.getAction()) {
            case 0: {
                this.mIsActionDown = true;
                if (!this.mIsViewPagerMode) break;
                if (this.mIsHorizontalOrientation) {
                    this.mIsPointerActionDown = (int)(event.getX() / this.mModelSize) == this.mIndex;
                    break;
                }
                this.mIsPointerActionDown = (int)(event.getY() / this.mModelSize) == this.mIndex;
                break;
            }
            case 2: {
                if (this.mIsPointerActionDown) {
                    if (this.mIsHorizontalOrientation) {
                        this.mViewPager.setCurrentItem((int)(event.getX() / this.mModelSize), true);
                        break;
                    }
                    this.mViewPager.setCurrentItem((int)(event.getY() / this.mModelSize), true);
                    break;
                }
                if (this.mIsActionDown) break;
            }
            case 1: {
                if (this.mIsActionDown) {
                    if (this.mIsHorizontalOrientation) {
                        this.setModelIndex((int)(event.getX() / this.mModelSize));
                    } else {
                        this.setModelIndex((int)(event.getY() / this.mModelSize));
                    }
                }
            }
            default: {
                this.mIsPointerActionDown = false;
                this.mIsActionDown = false;
            }
        }
        return true;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int height = View.MeasureSpec.getSize((int)heightMeasureSpec);
        if (this.mModels.isEmpty() || width == 0 || height == 0) {
            return;
        }
        if (width > height) {
            float side;
            this.mIsHorizontalOrientation = true;
            float f = side = this.mModelSize > (float)height ? (float)height : this.mModelSize;
            if (this.mIsBadged) {
                side -= side * 0.2f;
            }
            this.mModelSize = (float)width / (float)this.mModels.size();
            this.mIconSize = (int)(side * (this.mIsTitled ? 0.45f : 0.45f));
            this.mModelTitleSize = side * 0.2f;
            this.mTitleMargin = side * 0.15f;
            if (this.mIsBadged) {
                this.mBadgeTitleSize = this.mModelTitleSize * 0.9f;
                Rect badgeBounds = new Rect();
                this.mBadgePaint.setTextSize(this.mBadgeTitleSize);
                this.mBadgePaint.getTextBounds(PREVIEW_BADGE, 0, 1, badgeBounds);
                this.mBadgeMargin = (float)badgeBounds.height() * 0.5f + this.mBadgeTitleSize * 0.5f * 0.75f;
            }
        } else {
            this.mIsHorizontalOrientation = false;
            this.mIsTitled = false;
            this.mIsBadged = false;
            this.mModelSize = (float)height / (float)this.mModels.size();
            this.mIconSize = (int)((this.mModelSize > (float)width ? (float)width : this.mModelSize) * 0.45f);
        }
        this.mBounds.set(0.0f, 0.0f, (float)width, (float)height - this.mBadgeMargin);
        this.mBitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        this.mCanvas = new Canvas(this.mBitmap);
        this.mPointerBitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        this.mPointerCanvas = new Canvas(this.mPointerBitmap);
        this.mIconsBitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        this.mIconsCanvas = new Canvas(this.mIconsBitmap);
        for (Model model : this.mModels) {
            float originalIconSize = model.mIcon.getWidth() > model.mIcon.getHeight() ? (float)model.mIcon.getWidth() : (float)model.mIcon.getHeight();
            model.mInactiveIconScale = (float)this.mIconSize / originalIconSize;
            model.mActiveIconScaleBy = model.mInactiveIconScale * (this.mIsTitled ? 0.2f : 0.3f);
        }
        if (this.isInEditMode() || !this.mIsViewPagerMode) {
            this.mIsSetIndexFromTabBar = true;
            if (this.isInEditMode()) {
                this.mIndex = new Random().nextInt(this.mModels.size());
                if (this.mIsBadged) {
                    for (int i = 0; i < this.mModels.size(); ++i) {
                        Model model;
                        model = this.mModels.get(i);
                        if (i == this.mIndex) {
                            model.mBadgeFraction = 1.0f;
                            model.showBadge();
                            continue;
                        }
                        model.mBadgeFraction = 0.0f;
                        model.hideBadge();
                    }
                }
            }
            this.mEndPointerX = this.mStartPointerX = (float)this.mIndex * this.mModelSize;
            this.updateIndicatorPosition(1.0f);
        }
    }

    protected void onDraw(Canvas canvas) {
        int i;
        if (this.mCanvas == null || this.mPointerCanvas == null || this.mIconsCanvas == null) {
            return;
        }
        this.mCanvas.drawColor(0, PorterDuff.Mode.CLEAR);
        this.mPointerCanvas.drawColor(0, PorterDuff.Mode.CLEAR);
        this.mIconsCanvas.drawColor(0, PorterDuff.Mode.CLEAR);
        float pointerBadgeMargin = this.mBadgeGravity == BadgeGravity.TOP ? this.mBadgeMargin : 0.0f;
        for (i = 0; i < this.mModels.size(); ++i) {
            this.mPaint.setColor(this.mModels.get(i).getColor());
            if (this.mIsHorizontalOrientation) {
                float left = this.mModelSize * (float)i;
                float right = left + this.mModelSize;
                this.mCanvas.drawRect(left, pointerBadgeMargin, right, this.mBounds.height() + pointerBadgeMargin, this.mPaint);
                continue;
            }
            float top = this.mModelSize * (float)i;
            float bottom = top + this.mModelSize;
            this.mCanvas.drawRect(0.0f, top, this.mBounds.width(), bottom, this.mPaint);
        }
        if (this.mIsHorizontalOrientation) {
            this.mPointerBounds.set(this.mPointerLeftTop, pointerBadgeMargin, this.mPointerRightBottom, this.mBounds.height() + pointerBadgeMargin);
        } else {
            this.mPointerBounds.set(0.0f, this.mPointerLeftTop, this.mBounds.width(), this.mPointerRightBottom);
        }
        if (this.mCornersRadius == 0.0f) {
            this.mPointerCanvas.drawRect(this.mPointerBounds, this.mPaint);
        } else {
            this.mPointerCanvas.drawRoundRect(this.mPointerBounds, this.mCornersRadius, this.mCornersRadius, this.mPaint);
        }
        this.mCanvas.drawBitmap(this.mPointerBitmap, 0.0f, 0.0f, this.mPointerPaint);
        for (i = 0; i < this.mModels.size(); ++i) {
            float matrixCenterY;
            float matrixCenterX;
            float topOffset;
            float leftOffset;
            Model model = this.mModels.get(i);
            float iconMarginTitleHeight = (float)this.mIconSize + this.mTitleMargin + this.mModelTitleSize;
            float leftTitleOffset = this.mModelSize * (float)i + this.mModelSize * 0.5f;
            float topTitleOffset = this.mBounds.height() - (this.mBounds.height() - iconMarginTitleHeight) * 0.5f;
            if (this.mIsHorizontalOrientation) {
                leftOffset = this.mModelSize * (float)i + (this.mModelSize - (float)model.mIcon.getWidth()) * 0.5f;
                topOffset = (this.mBounds.height() - (float)model.mIcon.getHeight()) * 0.5f;
                matrixCenterX = leftOffset + (float)model.mIcon.getWidth() * 0.5f;
                matrixCenterY = topOffset + (float)model.mIcon.getHeight() * 0.5f + (this.mIsTitled && this.mTitleMode == TitleMode.ALL ? this.mTitleMargin * 0.5f : 0.0f);
            } else {
                leftOffset = (this.mBounds.width() - (float)model.mIcon.getWidth()) * 0.5f;
                topOffset = this.mModelSize * (float)i + (this.mModelSize - (float)model.mIcon.getHeight()) * 0.5f;
                matrixCenterX = leftOffset + (float)model.mIcon.getWidth() * 0.5f;
                matrixCenterY = topOffset + (float)model.mIcon.getHeight() * 0.5f;
            }
            float titleTranslate = (float)(-model.mIcon.getHeight()) + topTitleOffset - this.mTitleMargin * 0.5f;
            model.mIconMatrix.setTranslate(leftOffset, this.mIsTitled && this.mTitleMode == TitleMode.ALL ? titleTranslate : topOffset);
            float interpolation = this.mResizeInterpolator.getResizeInterpolation(this.mFraction, true);
            float lastInterpolation = this.mResizeInterpolator.getResizeInterpolation(this.mFraction, false);
            float matrixScale = model.mActiveIconScaleBy * (this.mIsScaled ? interpolation : 0.35f);
            float matrixLastScale = model.mActiveIconScaleBy * (this.mIsScaled ? lastInterpolation : 0.65f);
            int titleAlpha = (int)(255.0f * interpolation);
            int titleLastAlpha = 255 - (int)(255.0f * lastInterpolation);
            float titleScale = 1.0f + (this.mIsScaled ? interpolation : 0.35f) * 0.2f;
            float titleLastScale = this.mIsScaled ? 1.2f - lastInterpolation * 0.2f : titleScale;
            this.mIconPaint.setAlpha(255);
            if (model.mSelectedIcon != null) {
                this.mSelectedIconPaint.setAlpha(255);
            }
            if (this.mIsSetIndexFromTabBar) {
                if (this.mIndex == i) {
                    this.updateCurrentModel(model, leftOffset, topOffset, titleTranslate, interpolation, matrixCenterX, matrixCenterY, matrixScale, titleScale, titleAlpha);
                } else if (this.mLastIndex == i) {
                    this.updateLastModel(model, leftOffset, topOffset, titleTranslate, lastInterpolation, matrixCenterX, matrixCenterY, matrixLastScale, titleLastScale, titleLastAlpha);
                } else {
                    this.updateInactiveModel(model, leftOffset, topOffset, titleScale, matrixScale, matrixCenterX, matrixCenterY);
                }
            } else if (i != this.mIndex && i != this.mIndex + 1) {
                this.updateInactiveModel(model, leftOffset, topOffset, titleScale, matrixScale, matrixCenterX, matrixCenterY);
            } else if (i == this.mIndex + 1) {
                this.updateCurrentModel(model, leftOffset, topOffset, titleTranslate, interpolation, matrixCenterX, matrixCenterY, matrixScale, titleScale, titleAlpha);
            } else if (i == this.mIndex) {
                this.updateLastModel(model, leftOffset, topOffset, titleTranslate, lastInterpolation, matrixCenterX, matrixCenterY, matrixLastScale, titleLastScale, titleLastAlpha);
            }
            if (model.mSelectedIcon == null) {
                this.mIconsCanvas.drawBitmap(model.mIcon, model.mIconMatrix, this.mIconPaint);
            } else if (this.mIconPaint.getAlpha() != 0) {
                this.mIconsCanvas.drawBitmap(model.mIcon, model.mIconMatrix, this.mIconPaint);
            }
            if (model.mSelectedIcon != null && this.mSelectedIconPaint.getAlpha() != 0) {
                this.mIconsCanvas.drawBitmap(model.mSelectedIcon, model.mIconMatrix, this.mSelectedIconPaint);
            }
            if (!this.mIsTitled) continue;
            this.mIconsCanvas.drawText(this.isInEditMode() ? PREVIEW_TITLE : model.getTitle(), leftTitleOffset, topTitleOffset, this.mModelTitlePaint);
        }
        if (this.mCornersRadius == 0.0f) {
            this.mIconsCanvas.drawRect(this.mPointerBounds, this.mIconPointerPaint);
        } else {
            this.mIconsCanvas.drawRoundRect(this.mPointerBounds, this.mCornersRadius, this.mCornersRadius, this.mIconPointerPaint);
        }
        canvas.drawBitmap(this.mBitmap, 0.0f, 0.0f, null);
        canvas.drawBitmap(this.mIconsBitmap, 0.0f, pointerBadgeMargin, null);
        if (!this.mIsBadged) {
            return;
        }
        float modelBadgeMargin = this.mBadgeGravity == BadgeGravity.TOP ? this.mBadgeMargin : this.mBounds.height();
        float modelBadgeOffset = this.mBadgeGravity == BadgeGravity.TOP ? 0.0f : this.mBounds.height() - this.mBadgeMargin;
        for (int i2 = 0; i2 < this.mModels.size(); ++i2) {
            Model model = this.mModels.get(i2);
            if (this.isInEditMode() || TextUtils.isEmpty((CharSequence)model.getBadgeTitle())) {
                model.setBadgeTitle(PREVIEW_BADGE);
            }
            this.mBadgePaint.setTextSize(this.mBadgeTitleSize * model.mBadgeFraction);
            this.mBadgePaint.getTextBounds(model.getBadgeTitle(), 0, model.getBadgeTitle().length(), this.mBadgeBounds);
            float horizontalPadding = this.mBadgeTitleSize * 0.5f;
            float verticalPadding = horizontalPadding * 0.75f;
            float badgeBoundsHorizontalOffset = this.mModelSize * (float)i2 + this.mModelSize * this.mBadgePosition.mPositionFraction;
            if (model.getBadgeTitle().length() == 1) {
                float badgeMargin = this.mBadgeMargin * model.mBadgeFraction;
                this.mBgBadgeBounds.set(badgeBoundsHorizontalOffset - badgeMargin, modelBadgeMargin - badgeMargin, badgeBoundsHorizontalOffset + badgeMargin, modelBadgeMargin + badgeMargin);
            } else {
                this.mBgBadgeBounds.set(badgeBoundsHorizontalOffset - (float)this.mBadgeBounds.centerX() - horizontalPadding, modelBadgeMargin - this.mBadgeMargin * model.mBadgeFraction, badgeBoundsHorizontalOffset + (float)this.mBadgeBounds.centerX() + horizontalPadding, modelBadgeOffset + verticalPadding * 2.0f + (float)this.mBadgeBounds.height());
            }
            if (model.mBadgeFraction == 0.0f) {
                this.mBadgePaint.setColor(0);
            } else {
                this.mBadgePaint.setColor(this.mBadgeBgColor == 0 ? this.mActiveColor : this.mBadgeBgColor);
            }
            this.mBadgePaint.setAlpha((int)(255.0f * model.mBadgeFraction));
            float cornerRadius = this.mBgBadgeBounds.height() * 0.5f;
            canvas.drawRoundRect(this.mBgBadgeBounds, cornerRadius, cornerRadius, this.mBadgePaint);
            if (model.mBadgeFraction == 0.0f) {
                this.mBadgePaint.setColor(0);
            } else {
                this.mBadgePaint.setColor(this.mBadgeTitleColor == 0 ? model.getColor() : this.mBadgeTitleColor);
            }
            this.mBadgePaint.setAlpha((int)(255.0f * model.mBadgeFraction));
            float badgeHalfHeight = (float)this.mBadgeBounds.height() * 0.5f;
            float badgeVerticalOffset = this.mBgBadgeBounds.height() * 0.5f + badgeHalfHeight - (float)this.mBadgeBounds.bottom + modelBadgeOffset;
            canvas.drawText(model.getBadgeTitle(), badgeBoundsHorizontalOffset, badgeVerticalOffset + (float)this.mBadgeBounds.height() - (float)this.mBadgeBounds.height() * model.mBadgeFraction, this.mBadgePaint);
        }
    }

    private void updateCurrentModel(Model model, float leftOffset, float topOffset, float titleTranslate, float interpolation, float matrixCenterX, float matrixCenterY, float matrixScale, float textScale, int textAlpha) {
        float selectedIconAlpha;
        float iconAlpha;
        if (this.mIsTitled && this.mTitleMode == TitleMode.ACTIVE) {
            model.mIconMatrix.setTranslate(leftOffset, topOffset - interpolation * (topOffset - titleTranslate));
        }
        model.mIconMatrix.postScale(model.mInactiveIconScale + matrixScale, model.mInactiveIconScale + matrixScale, matrixCenterX, matrixCenterY + (this.mIsTitled && this.mTitleMode == TitleMode.ACTIVE ? this.mTitleMargin * 0.5f * interpolation : 0.0f));
        this.mModelTitlePaint.setTextSize(this.mModelTitleSize * textScale);
        if (this.mTitleMode == TitleMode.ACTIVE) {
            this.mModelTitlePaint.setAlpha(textAlpha);
        }
        if (model.mSelectedIcon == null) {
            this.mIconPaint.setAlpha(255);
            return;
        }
        if (interpolation <= 0.475f) {
            iconAlpha = 1.0f - interpolation * 2.1f;
            selectedIconAlpha = 0.0f;
        } else if (interpolation >= 0.525f) {
            iconAlpha = 0.0f;
            selectedIconAlpha = (interpolation - 0.55f) * 1.9f;
        } else {
            iconAlpha = 0.0f;
            selectedIconAlpha = 0.0f;
        }
        this.mIconPaint.setAlpha((int)(255.0f * this.clampValue(iconAlpha, 0.0f, 1.0f)));
        this.mSelectedIconPaint.setAlpha((int)(255.0f * this.clampValue(selectedIconAlpha, 0.0f, 1.0f)));
    }

    private void updateLastModel(Model model, float leftOffset, float topOffset, float titleTranslate, float lastInterpolation, float matrixCenterX, float matrixCenterY, float matrixLastScale, float textLastScale, int textLastAlpha) {
        float selectedIconAlpha;
        float iconAlpha;
        if (this.mIsTitled && this.mTitleMode == TitleMode.ACTIVE) {
            model.mIconMatrix.setTranslate(leftOffset, titleTranslate + lastInterpolation * (topOffset - titleTranslate));
        }
        model.mIconMatrix.postScale(model.mInactiveIconScale + model.mActiveIconScaleBy - matrixLastScale, model.mInactiveIconScale + model.mActiveIconScaleBy - matrixLastScale, matrixCenterX, matrixCenterY + (this.mIsTitled && this.mTitleMode == TitleMode.ACTIVE ? this.mTitleMargin * 0.5f - this.mTitleMargin * 0.5f * lastInterpolation : 0.0f));
        this.mModelTitlePaint.setTextSize(this.mModelTitleSize * textLastScale);
        if (this.mTitleMode == TitleMode.ACTIVE) {
            this.mModelTitlePaint.setAlpha(textLastAlpha);
        }
        if (model.mSelectedIcon == null) {
            this.mIconPaint.setAlpha(255);
            return;
        }
        if (lastInterpolation <= 0.475f) {
            iconAlpha = 0.0f;
            selectedIconAlpha = 1.0f - lastInterpolation * 2.1f;
        } else if (lastInterpolation >= 0.525f) {
            iconAlpha = (lastInterpolation - 0.55f) * 1.9f;
            selectedIconAlpha = 0.0f;
        } else {
            iconAlpha = 0.0f;
            selectedIconAlpha = 0.0f;
        }
        this.mIconPaint.setAlpha((int)(255.0f * this.clampValue(iconAlpha, 0.0f, 1.0f)));
        this.mSelectedIconPaint.setAlpha((int)(255.0f * this.clampValue(selectedIconAlpha, 0.0f, 1.0f)));
    }

    private void updateInactiveModel(Model model, float leftOffset, float topOffset, float textScale, float matrixScale, float matrixCenterX, float matrixCenterY) {
        if (this.mIsTitled && this.mTitleMode == TitleMode.ACTIVE) {
            model.mIconMatrix.setTranslate(leftOffset, topOffset);
        }
        if (this.mIsScaled) {
            model.mIconMatrix.postScale(model.mInactiveIconScale, model.mInactiveIconScale, matrixCenterX, matrixCenterY);
        } else {
            model.mIconMatrix.postScale(model.mInactiveIconScale + matrixScale, model.mInactiveIconScale + matrixScale, matrixCenterX, matrixCenterY);
        }
        this.mModelTitlePaint.setTextSize(this.mModelTitleSize * (this.mIsScaled ? 1.0f : textScale));
        if (this.mTitleMode == TitleMode.ACTIVE) {
            this.mModelTitlePaint.setAlpha(0);
        }
        if (model.mSelectedIcon == null) {
            this.mIconPaint.setAlpha(255);
            return;
        }
        this.mSelectedIconPaint.setAlpha(0);
    }

    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
        if (!this.mIsSetIndexFromTabBar) {
            this.mIsResizeIn = position < this.mIndex;
            this.mLastIndex = this.mIndex;
            this.mIndex = position;
            this.mStartPointerX = (float)position * this.mModelSize;
            this.mEndPointerX = this.mStartPointerX + this.mModelSize;
            this.updateIndicatorPosition(positionOffset);
        }
        if (this.mOnPageChangeListener != null) {
            this.mOnPageChangeListener.onPageScrolled(position, positionOffset, positionOffsetPixels);
        }
    }

    public void onPageSelected(int position) {
        if (this.mScrollState == 0) {
            this.mIsResizeIn = position < this.mIndex;
            this.mLastIndex = this.mIndex;
            this.mIndex = position;
            this.postInvalidate();
        }
    }

    public void onPageScrollStateChanged(int state) {
        if (state == 0) {
            this.mFraction = 0.0f;
            this.mIsSetIndexFromTabBar = false;
            if (this.mOnPageChangeListener != null) {
                this.mOnPageChangeListener.onPageSelected(this.mIndex);
            } else if (this.mOnTabBarSelectedIndexListener != null) {
                this.mOnTabBarSelectedIndexListener.onEndTabSelected(this.mModels.get(this.mIndex), this.mIndex);
            }
        }
        this.mScrollState = state;
        if (this.mOnPageChangeListener != null) {
            this.mOnPageChangeListener.onPageScrollStateChanged(state);
        }
    }

    public void onRestoreInstanceState(Parcelable state) {
        SavedState savedState = (SavedState)state;
        super.onRestoreInstanceState(savedState.getSuperState());
        this.mIndex = savedState.index;
        this.requestLayout();
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState savedState = new SavedState(superState);
        savedState.index = this.mIndex;
        return savedState;
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.requestLayout();
        final int tempIndex = this.mIndex;
        this.setModelIndex(-1, true);
        this.post(new Runnable(){

            @Override
            public void run() {
                NavigationTabBar.this.setModelIndex(tempIndex, true);
            }
        });
    }

    private float clampValue(float value, float max, float min) {
        return Math.max(Math.min(value, min), max);
    }

    public static interface OnTabBarSelectedIndexListener {
        public void onStartTabSelected(Model var1, int var2);

        public void onEndTabSelected(Model var1, int var2);
    }

    public static enum BadgeGravity {
        TOP,
        BOTTOM;

    }

    public static enum BadgePosition {
        LEFT(0.25f),
        CENTER(0.5f),
        RIGHT(0.75f);

        private float mPositionFraction;

        private BadgePosition() {
            this.mPositionFraction = 0.75f;
        }

        private BadgePosition(float positionFraction) {
            this.mPositionFraction = positionFraction;
        }
    }

    public static enum TitleMode {
        ALL,
        ACTIVE;

    }

    private class ResizeInterpolator
    implements Interpolator {
        private final float mFactor = 1.0f;
        private boolean mResizeIn;

        private ResizeInterpolator() {
        }

        public float getInterpolation(float input) {
            if (this.mResizeIn) {
                return (float)(1.0 - Math.pow(1.0f - input, 2.0));
            }
            return (float)Math.pow(input, 2.0);
        }

        public float getResizeInterpolation(float input, boolean resizeIn) {
            this.mResizeIn = resizeIn;
            return this.getInterpolation(input);
        }
    }

    private class ResizeViewPagerScroller
    extends Scroller {
        public ResizeViewPagerScroller(Context context) {
            super(context, (Interpolator)new AccelerateDecelerateInterpolator());
        }

        public void startScroll(int startX, int startY, int dx, int dy, int duration) {
            super.startScroll(startX, startY, dx, dy, NavigationTabBar.this.mAnimationDuration);
        }

        public void startScroll(int startX, int startY, int dx, int dy) {
            super.startScroll(startX, startY, dx, dy, NavigationTabBar.this.mAnimationDuration);
        }
    }

    public static class Model {
        private int mColor;
        private Bitmap mIcon;
        private Bitmap mSelectedIcon;
        private final Matrix mIconMatrix = new Matrix();
        private String mTitle = "";
        private String mBadgeTitle = "";
        private String mTempBadgeTitle = "";
        private float mBadgeFraction;
        private boolean mIsBadgeShowed;
        private boolean mIsBadgeUpdated;
        private final ValueAnimator mBadgeAnimator = new ValueAnimator();
        private float mInactiveIconScale;
        private float mActiveIconScaleBy;

        public Model(Builder builder) {
            this.mColor = builder.mColor;
            this.mIcon = builder.mIcon;
            this.mSelectedIcon = builder.mSelectedIcon;
            this.mTitle = builder.mTitle;
            this.mBadgeTitle = builder.mBadgeTitle;
            this.mBadgeAnimator.addListener(new Animator.AnimatorListener(){

                public void onAnimationStart(Animator animation) {
                    animation.removeListener((Animator.AnimatorListener)this);
                    animation.addListener((Animator.AnimatorListener)this);
                }

                public void onAnimationEnd(Animator animation) {
                    animation.removeListener((Animator.AnimatorListener)this);
                    animation.addListener((Animator.AnimatorListener)this);
                    if (!Model.this.mIsBadgeUpdated) {
                        Model.this.mIsBadgeShowed = !Model.this.mIsBadgeShowed;
                    } else {
                        Model.this.mIsBadgeUpdated = false;
                    }
                }

                public void onAnimationCancel(Animator animation) {
                }

                public void onAnimationRepeat(Animator animation) {
                    if (Model.this.mIsBadgeUpdated) {
                        Model.this.mBadgeTitle = Model.this.mTempBadgeTitle;
                    }
                }
            });
        }

        public String getTitle() {
            return this.mTitle;
        }

        public void setTitle(String title) {
            this.mTitle = title;
        }

        public int getColor() {
            return this.mColor;
        }

        public void setColor(int color) {
            this.mColor = color;
        }

        public boolean isBadgeShowed() {
            return this.mIsBadgeShowed;
        }

        public String getBadgeTitle() {
            return this.mBadgeTitle;
        }

        public void setBadgeTitle(String badgeTitle) {
            this.mBadgeTitle = badgeTitle;
        }

        public void updateBadgeTitle(String badgeTitle) {
            if (!this.mIsBadgeShowed) {
                return;
            }
            if (this.mBadgeAnimator.isRunning()) {
                this.mBadgeAnimator.end();
            }
            this.mTempBadgeTitle = badgeTitle;
            this.mIsBadgeUpdated = true;
            this.mBadgeAnimator.setFloatValues(new float[]{1.0f, 0.0f});
            this.mBadgeAnimator.setDuration(100L);
            this.mBadgeAnimator.setRepeatMode(2);
            this.mBadgeAnimator.setRepeatCount(1);
            this.mBadgeAnimator.start();
        }

        public void toggleBadge() {
            if (this.mBadgeAnimator.isRunning()) {
                this.mBadgeAnimator.end();
            }
            if (this.mIsBadgeShowed) {
                this.hideBadge();
            } else {
                this.showBadge();
            }
        }

        public void showBadge() {
            this.mIsBadgeUpdated = false;
            if (this.mBadgeAnimator.isRunning()) {
                this.mBadgeAnimator.end();
            }
            if (this.mIsBadgeShowed) {
                return;
            }
            this.mBadgeAnimator.setFloatValues(new float[]{0.0f, 1.0f});
            this.mBadgeAnimator.setInterpolator((TimeInterpolator)DECELERATE_INTERPOLATOR);
            this.mBadgeAnimator.setDuration(200L);
            this.mBadgeAnimator.setRepeatMode(1);
            this.mBadgeAnimator.setRepeatCount(0);
            this.mBadgeAnimator.start();
        }

        public void hideBadge() {
            this.mIsBadgeUpdated = false;
            if (this.mBadgeAnimator.isRunning()) {
                this.mBadgeAnimator.end();
            }
            if (!this.mIsBadgeShowed) {
                return;
            }
            this.mBadgeAnimator.setFloatValues(new float[]{1.0f, 0.0f});
            this.mBadgeAnimator.setInterpolator((TimeInterpolator)ACCELERATE_INTERPOLATOR);
            this.mBadgeAnimator.setDuration(200L);
            this.mBadgeAnimator.setRepeatMode(1);
            this.mBadgeAnimator.setRepeatCount(0);
            this.mBadgeAnimator.start();
        }

        public static class Builder {
            private int mColor;
            private Bitmap mIcon;
            private Bitmap mSelectedIcon;
            private String mTitle;
            private String mBadgeTitle;

            public Builder(Drawable icon, int color) {
                this.mColor = color;
                if (icon != null) {
                    if (icon instanceof BitmapDrawable) {
                        this.mIcon = ((BitmapDrawable)icon).getBitmap();
                    } else {
                        this.mIcon = Bitmap.createBitmap((int)icon.getIntrinsicWidth(), (int)icon.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                        Canvas canvas = new Canvas(this.mIcon);
                        icon.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
                        icon.draw(canvas);
                    }
                } else {
                    this.mIcon = Bitmap.createBitmap((int)1, (int)1, (Bitmap.Config)Bitmap.Config.RGB_565);
                }
            }

            public Builder selectedIcon(Drawable selectedIcon) {
                if (selectedIcon != null) {
                    if (selectedIcon instanceof BitmapDrawable) {
                        this.mSelectedIcon = ((BitmapDrawable)selectedIcon).getBitmap();
                    } else {
                        this.mSelectedIcon = Bitmap.createBitmap((int)selectedIcon.getIntrinsicWidth(), (int)selectedIcon.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                        Canvas canvas = new Canvas(this.mSelectedIcon);
                        selectedIcon.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
                        selectedIcon.draw(canvas);
                    }
                } else {
                    this.mSelectedIcon = null;
                }
                return this;
            }

            public Builder title(String title) {
                this.mTitle = title;
                return this;
            }

            public Builder badgeTitle(String title) {
                this.mBadgeTitle = title;
                return this;
            }

            public Model build() {
                return new Model(this);
            }
        }
    }

    private static class SavedState
    extends View.BaseSavedState {
        int index;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        public SavedState(Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            this.index = in.readInt();
        }

        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeInt(this.index);
        }
    }
}

