/*
 * Decompiled with CFR 0.152.
 */
package com.ahamed.multiviewadapter;

import android.support.annotation.NonNull;
import android.support.v7.util.DiffUtil;
import android.support.v7.util.ListUpdateCallback;
import com.ahamed.multiviewadapter.BaseDataManager;
import com.ahamed.multiviewadapter.RecyclerAdapter;
import com.ahamed.multiviewadapter.util.DiffUtilCallback;
import com.ahamed.multiviewadapter.util.PayloadProvider;
import java.util.Collection;
import java.util.List;

class DataListUpdateManager<M>
extends BaseDataManager<M> {
    final PayloadProvider<M> payloadProvider;

    DataListUpdateManager(@NonNull RecyclerAdapter adapter) {
        this(adapter, new PayloadProvider<M>(){

            @Override
            public boolean areContentsTheSame(M oldItem, M newItem) {
                return oldItem.equals(newItem);
            }

            @Override
            public Object getChangePayload(M oldItem, M newItem) {
                return null;
            }
        });
    }

    DataListUpdateManager(@NonNull RecyclerAdapter adapter, @NonNull PayloadProvider<M> payloadProvider) {
        super(adapter);
        this.payloadProvider = payloadProvider;
    }

    final boolean add(M item, boolean notifyDataSetChanged) {
        boolean result = this.getDataList().add(item);
        if (result && notifyDataSetChanged) {
            this.onInserted(this.getDataList().size() - 1, 1);
        }
        return result;
    }

    final boolean addAll(@NonNull Collection<? extends M> items, boolean notifyDataSetChanged) {
        return this.addAll(this.getDataList().size(), items, notifyDataSetChanged);
    }

    final boolean addAll(int index, @NonNull Collection<? extends M> items, boolean notifyDataSetChanged) {
        boolean result = this.getDataList().addAll(index, items);
        if (result && notifyDataSetChanged) {
            this.onInserted(index, items.size());
        }
        return result;
    }

    final void add(int index, M item, boolean notifyDataSetChanged) {
        this.getDataList().add(index, item);
        if (notifyDataSetChanged) {
            this.onInserted(index, 1);
        }
    }

    final void set(int index, M item, boolean notifyDataSetChanged) {
        Object oldItem = this.getDataList().get(index);
        this.getDataList().set(index, item);
        if (notifyDataSetChanged) {
            this.onChanged(index, 1, this.payloadProvider.getChangePayload(oldItem, item));
        }
    }

    final void set(List<M> dataList, boolean notifyDataSetChanged) {
        DiffUtil.DiffResult result = null;
        if (notifyDataSetChanged) {
            result = DiffUtil.calculateDiff((DiffUtil.Callback)new DiffUtilCallback<M>(this.getDataList(), dataList){

                @Override
                public boolean areContentsTheSame(M oldItem, M newItem) {
                    return DataListUpdateManager.this.payloadProvider.areContentsTheSame(oldItem, newItem);
                }

                @Override
                public Object getChangePayload(M oldItem, M newItem) {
                    return DataListUpdateManager.this.payloadProvider.getChangePayload(oldItem, newItem);
                }
            });
        }
        this.setDataList(dataList);
        if (notifyDataSetChanged) {
            result.dispatchUpdatesTo((ListUpdateCallback)this);
        }
    }

    final void remove(M item, boolean notifyDataSetChanged) {
        int index = this.getDataList().indexOf(item);
        boolean result = this.getDataList().remove(item);
        if (result && notifyDataSetChanged) {
            this.onRemoved(index, 1);
        }
    }

    final void remove(int index, boolean notifyDataSetChanged) {
        if (index >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        this.getDataList().remove(index);
        if (notifyDataSetChanged) {
            this.onRemoved(index, 1);
        }
    }

    final void clear(boolean notifyDataSetChanged) {
        if (this.size() <= 0) {
            return;
        }
        int oldSize = this.getDataList().size();
        this.getDataList().clear();
        if (notifyDataSetChanged) {
            this.onRemoved(0, oldSize);
        }
    }
}

