/*
 * Decompiled with CFR 0.152.
 */
package com.ahamed.multiviewadapter;

import com.ahamed.multiviewadapter.BaseDataManager;
import com.ahamed.multiviewadapter.RecyclerAdapter;

public class SelectableAdapter
extends RecyclerAdapter {
    public static final int SELECTION_MODE_NONE = -1;
    public static final int SELECTION_MODE_SINGLE = 1;
    public static final int SELECTION_MODE_SINGLE_OR_NONE = 2;
    public static final int SELECTION_MODE_MULTIPLE = 3;
    private int selectionMode = -1;

    @Override
    void onItemSelectionToggled(int adapterPosition) {
        switch (this.selectionMode) {
            case 1: {
                int lastSelectedIndex = this.getLastSelectedIndex();
                if (lastSelectedIndex == adapterPosition) {
                    return;
                }
                if (lastSelectedIndex != -1) {
                    this.getDataManager(lastSelectedIndex).onItemSelectionToggled(this.getItemPositionInManager(lastSelectedIndex), false);
                }
                this.getDataManager(adapterPosition).onItemSelectionToggled(this.getItemPositionInManager(adapterPosition), true);
                break;
            }
            case 2: {
                int lastSelectedIndex = this.getLastSelectedIndex();
                if (lastSelectedIndex != -1) {
                    this.getDataManager(lastSelectedIndex).onItemSelectionToggled(this.getItemPositionInManager(lastSelectedIndex), false);
                }
                this.getDataManager(adapterPosition).onItemSelectionToggled(this.getItemPositionInManager(adapterPosition), lastSelectedIndex != adapterPosition);
                break;
            }
            case 3: {
                this.getDataManager(adapterPosition).onItemSelectionToggled(this.getItemPositionInManager(adapterPosition), !this.isItemSelected(adapterPosition));
                break;
            }
        }
    }

    private int getLastSelectedIndex() {
        for (BaseDataManager baseDataManager : this.dataManagers) {
            if (baseDataManager.getSelectedIndex() == -1) continue;
            return this.getPositionInAdapter(baseDataManager, baseDataManager.getSelectedIndex());
        }
        return -1;
    }

    int getSelectionMode() {
        return this.selectionMode;
    }

    public final void setSelectionMode(int selectionMode) {
        this.selectionMode = selectionMode;
    }
}

