/*
 * Decompiled with CFR 0.152.
 */
package com.ahamed.multiviewadapter;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import android.support.v7.util.ListUpdateCallback;
import com.ahamed.multiviewadapter.RecyclerAdapter;
import com.ahamed.multiviewadapter.SelectableAdapter;
import com.ahamed.multiviewadapter.listener.ItemSelectionChangedListener;
import com.ahamed.multiviewadapter.listener.MultiSelectionChangedListener;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseDataManager<M>
implements ListUpdateCallback {
    final RecyclerAdapter adapter;
    private List<M> dataList = new ArrayList<M>();
    private List<M> selectedItems = new ArrayList<M>();
    private ItemSelectionChangedListener<M> itemSelectionChangedListener;
    private MultiSelectionChangedListener<M> multiSelectionChangedListener;

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    BaseDataManager(@NonNull RecyclerAdapter adapter) {
        this.adapter = adapter;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public final void onInserted(int position, int count) {
        this.adapter.notifyBinderItemRangeInserted(this, position, count);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public final void onRemoved(int position, int count) {
        this.adapter.notifyBinderItemRangeRemoved(this, position, count);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public final void onMoved(int fromPosition, int toPosition) {
        this.adapter.notifyBinderItemMoved(this, fromPosition, toPosition);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public final void onChanged(int position, int count, Object payload) {
        this.adapter.notifyBinderItemRangeChanged(this, position, count, payload);
    }

    public final List<M> getSelectedItems() {
        ArrayList<M> selectedItemsList = new ArrayList<M>();
        for (M m : this.selectedItems) {
            if (!this.contains(m)) continue;
            selectedItemsList.add(m);
        }
        this.selectedItems = selectedItemsList;
        return selectedItemsList;
    }

    public final void setSelectedItems(@NonNull List<M> selectedItems) {
        int index;
        if (!(this.adapter instanceof SelectableAdapter)) {
            throw new IllegalStateException("Make sure your adapter extends from com.ahamed.multiviewadapter.SelectableAdapter");
        }
        if (this.size() < 0) {
            return;
        }
        ArrayList<M> oldSelectedItems = new ArrayList<M>(this.selectedItems);
        this.selectedItems.clear();
        for (Object m : selectedItems) {
            index = this.indexOf(m);
            if (!oldSelectedItems.contains(m)) {
                this.onItemSelectionToggled(index, true);
                continue;
            }
            this.selectedItems.add(m);
        }
        for (Object m : oldSelectedItems) {
            index = this.indexOf(m);
            if (selectedItems.contains(m)) continue;
            this.onItemSelectionToggled(index, false);
        }
    }

    public final void clearSelectedItems() {
        if (!(this.adapter instanceof SelectableAdapter)) {
            throw new IllegalStateException("Make sure your adapter extends from com.ahamed.multiviewadapter.SelectableAdapter");
        }
        if (this.size() < 0) {
            return;
        }
        this.selectedItems.clear();
        this.onChanged(0, this.size(), null);
    }

    @Nullable
    public final M getSelectedItem() {
        if (this.selectedItems.size() > 0) {
            return this.selectedItems.get(0);
        }
        return null;
    }

    public final void setSelectedItem(@NonNull M selectedItem) {
        if (!(this.adapter instanceof SelectableAdapter)) {
            throw new IllegalStateException("Make sure your adapter extends from com.ahamed.multiviewadapter.SelectableAdapter");
        }
        if (this.size() < 0) {
            return;
        }
        M previousSelectedItem = this.getSelectedItem();
        int index = this.indexOf(selectedItem);
        if (index != -1 && !selectedItem.equals(previousSelectedItem)) {
            this.onItemSelectionToggled(index, true);
        }
        if (null != previousSelectedItem && !previousSelectedItem.equals(selectedItem)) {
            this.onItemSelectionToggled(this.indexOf(previousSelectedItem), false);
        }
    }

    public final int getCount() {
        return this.size();
    }

    public final boolean isEmpty() {
        return this.dataList.isEmpty();
    }

    public final boolean contains(M item) {
        return this.dataList.contains(item);
    }

    public final M get(int index) {
        return this.dataList.get(index);
    }

    public final int indexOf(M item) {
        return this.dataList.indexOf(item);
    }

    public final int lastIndexOf(M item) {
        return this.dataList.lastIndexOf(item);
    }

    public final void setItemSelectionChangedListener(ItemSelectionChangedListener<M> itemSelectionChangedListener) {
        this.itemSelectionChangedListener = itemSelectionChangedListener;
    }

    public final void setMultiSelectionChangedListener(MultiSelectionChangedListener<M> multiSelectionChangedListener) {
        this.multiSelectionChangedListener = multiSelectionChangedListener;
    }

    void onItemSelectionToggled(int position, boolean isSelected) {
        if (isSelected) {
            this.selectedItems.add(this.getItem(position));
        } else {
            this.selectedItems.remove(this.getItem(position));
        }
        this.onChanged(position, 1, null);
        if (this.adapter instanceof SelectableAdapter && (this.itemSelectionChangedListener != null || this.multiSelectionChangedListener != null)) {
            SelectableAdapter adapter = (SelectableAdapter)this.adapter;
            switch (adapter.getSelectionMode()) {
                case 3: {
                    if (null == this.multiSelectionChangedListener) break;
                    this.multiSelectionChangedListener.onMultiSelectionChangedListener(this.getSelectedItems());
                    break;
                }
                case 1: 
                case 2: {
                    if (null == this.itemSelectionChangedListener) break;
                    this.itemSelectionChangedListener.onItemSelectionChangedListener(this.getItem(position), isSelected);
                    break;
                }
            }
        }
    }

    void onItemExpansionToggled(int position) {
        this.onChanged(position, 1, null);
    }

    void onGroupExpansionToggled() {
    }

    List<M> getDataList() {
        return this.dataList;
    }

    void setDataList(List<M> dataList) {
        this.dataList = new ArrayList<M>(dataList);
    }

    int size() {
        return this.dataList.size();
    }

    M getItem(int dataItemPosition) {
        return this.get(dataItemPosition);
    }

    boolean isItemSelected(int dataItemPosition) {
        return this.selectedItems.contains(this.getItem(dataItemPosition));
    }

    void onSwapped(int currentPosition, int targetPosition) {
        M item = this.dataList.get(currentPosition);
        this.dataList.remove(currentPosition);
        this.dataList.add(targetPosition, item);
        this.onMoved(currentPosition, targetPosition);
    }

    int getSelectedIndex() {
        if (this.selectedItems.size() > 0 && this.contains(this.selectedItems.get(0))) {
            return this.indexOf(this.selectedItems.get(0));
        }
        this.selectedItems.clear();
        return -1;
    }
}

