/*
 * Decompiled with CFR 0.152.
 */
package com.ahamed.multiviewadapter;

import android.content.Context;
import android.support.annotation.RestrictTo;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.helper.ItemTouchHelper;
import android.util.SparseBooleanArray;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import com.ahamed.multiviewadapter.BaseDataManager;
import com.ahamed.multiviewadapter.DataGroupManager;
import com.ahamed.multiviewadapter.DataItemManager;
import com.ahamed.multiviewadapter.DataListManager;
import com.ahamed.multiviewadapter.DataListUpdateManager;
import com.ahamed.multiviewadapter.ItemBinder;
import com.ahamed.multiviewadapter.ItemDecorationManager;
import com.ahamed.multiviewadapter.ItemViewHolder;
import com.ahamed.multiviewadapter.listener.ItemActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class CoreRecyclerAdapter
extends RecyclerView.Adapter<ItemViewHolder> {
    final List<BaseDataManager> dataManagers = new ArrayList<BaseDataManager>();
    final ItemDecorationManager itemDecorationManager;
    final List<ItemBinder> binders = new ArrayList<ItemBinder>();
    final SparseBooleanArray expandedItems = new SparseBooleanArray();
    int maxSpanCount = 1;
    final GridLayoutManager.SpanSizeLookup spanSizeLookup = new GridLayoutManager.SpanSizeLookup(){

        public int getSpanSize(int position) {
            return CoreRecyclerAdapter.this.getBinderForPosition(position).getSpanSize(CoreRecyclerAdapter.this.maxSpanCount);
        }
    };
    ItemTouchHelper itemTouchHelper;
    boolean isInActionMode = false;
    int expandableMode = -1;
    int groupExpandableMode = -1;
    private int lastExpandedIndex = -1;
    final ItemActionListener actionListener = new ItemActionListener(){

        @Override
        public void onItemSelectionToggled(int position) {
            CoreRecyclerAdapter.this.onItemSelectionToggled(position);
        }

        @Override
        public void onItemExpansionToggled(int position) {
            CoreRecyclerAdapter.this.onItemExpansionToggled(position);
        }

        @Override
        public void onGroupExpansionToggled(int position) {
            CoreRecyclerAdapter.this.onGroupExpansionToggled(position);
        }

        @Override
        public boolean isItemSelected(int position) {
            return CoreRecyclerAdapter.this.isItemSelected(position);
        }

        @Override
        public boolean isItemExpanded(int position) {
            return CoreRecyclerAdapter.this.itemExpanded(position);
        }

        @Override
        public boolean isAdapterInActionMode() {
            return CoreRecyclerAdapter.this.isInActionMode;
        }

        @Override
        public void onStartDrag(ItemViewHolder viewHolder) {
            CoreRecyclerAdapter.this.itemTouchHelper.startDrag((RecyclerView.ViewHolder)viewHolder);
        }
    };

    CoreRecyclerAdapter() {
        this.itemDecorationManager = new ItemDecorationManager(this);
    }

    private boolean itemExpanded(int position) {
        return this.expandedItems.get(position, false);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public final ItemViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        return this.binders.get(viewType).createViewHolder(LayoutInflater.from((Context)parent.getContext()), parent, this.actionListener);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public final void onBindViewHolder(ItemViewHolder holder, int adapterPosition) {
        this.onBindViewHolder(holder, adapterPosition, null);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public final void onBindViewHolder(ItemViewHolder holder, int adapterPosition, List<Object> payloads) {
        ItemBinder baseBinder = this.binders.get(holder.getItemViewType());
        int totalCount = 0;
        for (BaseDataManager dataManager : this.dataManagers) {
            if (adapterPosition >= (totalCount += dataManager.getCount())) continue;
            int itemPosition = this.getItemPositionInManager(adapterPosition);
            if (dataManager instanceof DataGroupManager) {
                dataManager = ((DataGroupManager)dataManager).getDataManagerForPosition(itemPosition);
            }
            holder.setItem(dataManager.getItem(itemPosition));
            break;
        }
        if (null == payloads || payloads.size() == 0) {
            baseBinder.bindViewHolder(holder, holder.getItem());
        } else {
            baseBinder.bindViewHolder(holder, holder.getItem(), payloads);
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public final int getItemCount() {
        int itemCount = 0;
        for (BaseDataManager dataManager : this.dataManagers) {
            itemCount += dataManager.size();
        }
        return itemCount;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public final int getItemViewType(int adapterPosition) {
        ItemBinder baseBinder = this.getBinderForPosition(adapterPosition);
        if (null != baseBinder) {
            return this.binders.indexOf(baseBinder);
        }
        return super.getItemViewType(adapterPosition);
    }

    ItemBinder getBinderForPosition(int adapterPosition) {
        BaseDataManager dataManager = this.getDataManager(adapterPosition);
        for (ItemBinder baseBinder : this.binders) {
            if (!baseBinder.canBindData(dataManager.getItem(this.getItemPositionInManager(adapterPosition)))) continue;
            return baseBinder;
        }
        throw new IllegalStateException("Binder not found for position. Position = " + adapterPosition);
    }

    int getItemPositionInManager(int adapterPosition) {
        BaseDataManager dataManager;
        int itemCount;
        Iterator<BaseDataManager> iterator = this.dataManagers.iterator();
        while (iterator.hasNext() && adapterPosition - (itemCount = (dataManager = iterator.next()).getCount()) >= 0) {
            adapterPosition -= itemCount;
        }
        return adapterPosition;
    }

    BaseDataManager getDataManager(int adapterPosition) {
        BaseDataManager dataManager = this.justGetDataManager(adapterPosition);
        if (dataManager instanceof DataGroupManager) {
            return ((DataGroupManager)dataManager).getDataManagerForPosition(this.getItemPositionInManager(adapterPosition));
        }
        return dataManager;
    }

    BaseDataManager justGetDataManager(int adapterPosition) {
        int processedCount = 0;
        for (BaseDataManager dataManager : this.dataManagers) {
            if (adapterPosition >= (processedCount += dataManager.getCount())) continue;
            return dataManager;
        }
        throw new IllegalStateException("Invalid position for DataManager!");
    }

    int getPositionInAdapter(BaseDataManager dataManager, int binderPosition) {
        int dataManagerIndex = this.dataManagers.indexOf(dataManager);
        if (dataManagerIndex < 0) {
            throw new IllegalStateException("DataManager does not exist in adapter");
        }
        int position = binderPosition;
        for (int i = 0; i < dataManagerIndex; ++i) {
            position += this.dataManagers.get(i).getCount();
        }
        return position;
    }

    boolean isItemSelected(int adapterPosition) {
        return this.getDataManager(adapterPosition).isItemSelected(this.getItemPositionInManager(adapterPosition));
    }

    final void notifyBinderItemRangeChanged(BaseDataManager dataManager, int positionStart, int itemCount, Object payload) {
        this.notifyItemRangeChanged(this.getPositionInAdapter(dataManager, positionStart), itemCount, payload);
    }

    final void notifyBinderItemMoved(BaseDataManager dataManager, int fromPosition, int toPosition) {
        this.notifyItemMoved(this.getPositionInAdapter(dataManager, fromPosition), this.getPositionInAdapter(dataManager, toPosition));
    }

    final void notifyBinderItemRangeInserted(BaseDataManager dataManager, int positionStart, int itemCount) {
        this.notifyItemRangeInserted(this.getPositionInAdapter(dataManager, positionStart), itemCount);
    }

    final void notifyBinderItemRangeRemoved(BaseDataManager dataManager, int positionStart, int itemCount) {
        this.notifyItemRangeRemoved(this.getPositionInAdapter(dataManager, positionStart), itemCount);
    }

    boolean isLastItemInManager(int adapterPosition, int itemPosition) {
        return this.getDataManager(adapterPosition).size() - 1 == itemPosition;
    }

    void onItemSelectionToggled(int position) {
    }

    private void onItemExpansionToggled(int adapterPosition) {
        switch (this.expandableMode) {
            case 1: {
                if (this.lastExpandedIndex != -1) {
                    this.expandedItems.put(this.lastExpandedIndex, false);
                    this.getDataManager(this.lastExpandedIndex).onItemExpansionToggled(this.getItemPositionInManager(this.lastExpandedIndex));
                }
                if (this.lastExpandedIndex == adapterPosition) {
                    this.lastExpandedIndex = -1;
                    return;
                }
                this.expandedItems.put(adapterPosition, true);
                this.getDataManager(adapterPosition).onItemExpansionToggled(this.getItemPositionInManager(adapterPosition));
                this.lastExpandedIndex = adapterPosition;
                break;
            }
            case 2: {
                this.expandedItems.put(adapterPosition, !this.expandedItems.get(adapterPosition, false));
                this.getDataManager(adapterPosition).onItemExpansionToggled(this.getItemPositionInManager(adapterPosition));
                break;
            }
        }
    }

    private void onGroupExpansionToggled(int adapterPosition) {
        switch (this.groupExpandableMode) {
            case 1: {
                if (this.lastExpandedIndex == adapterPosition) {
                    return;
                }
                if (this.lastExpandedIndex != -1) {
                    this.justGetDataManager(this.lastExpandedIndex).onGroupExpansionToggled();
                }
                this.justGetDataManager(adapterPosition).onGroupExpansionToggled();
                this.lastExpandedIndex = adapterPosition;
                break;
            }
            case 2: {
                this.expandedItems.put(adapterPosition, !this.expandedItems.get(adapterPosition, false));
                this.justGetDataManager(adapterPosition).onGroupExpansionToggled();
                break;
            }
        }
    }

    void onItemDismiss(int adapterPosition) {
        BaseDataManager baseDataManager = this.getDataManager(adapterPosition);
        if (baseDataManager instanceof DataListManager) {
            ((DataListManager)baseDataManager).onSwiped(this.getItemPositionInManager(adapterPosition));
        } else if (baseDataManager instanceof DataItemManager) {
            ((DataItemManager)baseDataManager).removeItem();
        }
    }

    void onMove(int currentPosition, int targetPosition) {
        if (currentPosition == -1) {
            return;
        }
        BaseDataManager dataManager = this.getDataManager(currentPosition);
        BaseDataManager targetDataManager = this.getDataManager(targetPosition);
        int currentPositionInManager = this.getItemPositionInManager(currentPosition);
        int targetPositionInManager = this.getItemPositionInManager(targetPosition);
        if (dataManager.equals(targetDataManager)) {
            dataManager.onSwapped(currentPositionInManager, targetPositionInManager);
        } else {
            Object obj = dataManager.getItem(currentPositionInManager);
            ((DataListUpdateManager)dataManager).remove(currentPositionInManager, false);
            ((DataListUpdateManager)targetDataManager).add(this.getItemPositionInManager(targetPosition + (targetPosition > currentPosition ? -1 : 0)), obj, false);
            this.notifyItemMoved(currentPosition, targetPosition);
        }
    }

    void resetExpandedItems() {
        if (this.expandableMode != -1) {
            boolean notify = this.expandedItems.size() > 0;
            this.expandedItems.clear();
            this.lastExpandedIndex = -1;
            if (!notify) {
                return;
            }
            for (BaseDataManager dataManager : this.dataManagers) {
                this.notifyBinderItemRangeChanged(dataManager, 0, dataManager.size(), null);
            }
        }
    }
}

