/*
 * Decompiled with CFR 0.152.
 */
package com.ahamed.multiviewadapter;

import android.graphics.Canvas;
import android.graphics.Rect;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.ahamed.multiviewadapter.ItemViewHolder;
import com.ahamed.multiviewadapter.listener.ItemActionListener;
import com.ahamed.multiviewadapter.util.ItemDecorator;
import java.util.ArrayList;
import java.util.List;

public abstract class ItemBinder<M, VH extends ItemViewHolder<M>> {
    private List<ItemDecorator> itemDecorators;

    public ItemBinder() {
    }

    public ItemBinder(ItemDecorator itemDecorator) {
        this.addDecorator(itemDecorator);
    }

    public abstract VH create(LayoutInflater var1, ViewGroup var2);

    public abstract void bind(VH var1, M var2);

    public abstract boolean canBindData(Object var1);

    public void bind(VH holder, M item, List payloads) {
        this.bind(holder, item);
    }

    public int getSpanSize(int maxSpanCount) {
        return 1;
    }

    public final void addDecorator(ItemDecorator itemDecorator) {
        this.addDecorator(itemDecorator, -1);
    }

    public final void addDecorator(ItemDecorator itemDecorator, int priority) {
        if (null == this.itemDecorators) {
            this.itemDecorators = new ArrayList<ItemDecorator>();
        }
        if (priority >= 0 && this.itemDecorators.size() > priority) {
            this.itemDecorators.add(priority, itemDecorator);
        } else {
            this.itemDecorators.add(itemDecorator);
        }
    }

    void bindViewHolder(VH holder, M item) {
        this.bind(holder, item);
    }

    void bindViewHolder(VH holder, M item, List payloads) {
        this.bind(holder, item, payloads);
    }

    VH createViewHolder(LayoutInflater inflater, ViewGroup parent, ItemActionListener actionListener) {
        VH viewHolder = this.create(inflater, parent);
        ((ItemViewHolder)((Object)viewHolder)).setItemActionListener(actionListener);
        return viewHolder;
    }

    boolean isItemDecorationEnabled() {
        return this.itemDecorators != null;
    }

    void getItemOffsets(Rect outRect, int position, int positionType) {
        if (null == this.itemDecorators) {
            return;
        }
        for (ItemDecorator itemDecorator : this.itemDecorators) {
            itemDecorator.getItemOffsets(outRect, position, positionType);
        }
    }

    void onDraw(Canvas canvas, RecyclerView parent, View child, int position, int positionType) {
        if (null == this.itemDecorators) {
            return;
        }
        for (ItemDecorator itemDecorator : this.itemDecorators) {
            itemDecorator.onDraw(canvas, parent, child, position, positionType);
        }
    }
}

