/*
 * Decompiled with CFR 0.152.
 */
package com.ahamed.multiviewadapter;

import android.support.annotation.NonNull;
import com.ahamed.multiviewadapter.BaseDataManager;
import com.ahamed.multiviewadapter.DataItemManager;
import com.ahamed.multiviewadapter.DataListUpdateManager;
import com.ahamed.multiviewadapter.RecyclerAdapter;
import com.ahamed.multiviewadapter.util.PayloadProvider;
import java.util.Collection;
import java.util.List;

public class DataGroupManager<H, M>
extends DataListUpdateManager<M> {
    private final DataItemManager<H> headerItemManager;
    private boolean isExpanded = false;

    public DataGroupManager(RecyclerAdapter adapter, H headerItem) {
        super(adapter);
        this.headerItemManager = new DataItemManager<H>(adapter, headerItem);
    }

    public DataGroupManager(RecyclerAdapter adapter, H headerItem, @NonNull PayloadProvider<M> payloadProvider) {
        super(adapter, payloadProvider);
        this.headerItemManager = new DataItemManager<H>(adapter, headerItem);
    }

    @Override
    void onGroupExpansionToggled() {
        boolean bl = this.isExpanded = !this.isExpanded;
        if (this.isExpanded) {
            this.onInserted(1, this.getDataList().size());
        } else {
            this.onRemoved(1, this.getDataList().size());
        }
    }

    @Override
    M getItem(int dataItemPosition) {
        return super.getItem(dataItemPosition - 1);
    }

    BaseDataManager getDataManagerForPosition(int itemPositionInManager) {
        if (itemPositionInManager == 0) {
            return this.headerItemManager;
        }
        return this;
    }

    @Override
    int size() {
        return this.headerItemManager.size() + (this.isExpanded ? super.size() : 0);
    }

    public void setExpanded(boolean expanded) {
        this.isExpanded = expanded;
    }

    public final void setItem(M item) {
        if (this.getDataList().size() == 0) {
            this.getDataList().add(item);
            this.onInserted(0, 1);
        } else {
            this.getDataList().set(0, item);
            this.onChanged(0, 1, null);
        }
    }

    public final void removeGroup() {
        if (this.getDataList().size() > 0) {
            this.getDataList().clear();
        }
        this.headerItemManager.removeItem();
    }

    public final boolean add(M item) {
        return this.add(item, this.isExpanded);
    }

    public final boolean addAll(@NonNull Collection<? extends M> items) {
        return this.addAll(this.getDataList().size(), items, this.isExpanded);
    }

    public final boolean addAll(int index, @NonNull Collection<? extends M> items) {
        return this.addAll(index, items, this.isExpanded);
    }

    public final void add(int index, M item) {
        this.add(index, item, this.isExpanded);
    }

    public final void set(int index, M item) {
        this.set(index, item, this.isExpanded);
    }

    public final void set(List<M> dataList) {
        this.set(dataList, this.isExpanded);
    }

    public final void remove(M item) {
        this.remove(item, this.isExpanded);
    }

    public final void remove(int index) {
        this.remove(index, this.isExpanded);
    }

    public final void clear() {
        this.clear(this.isExpanded);
    }
}

