/*
 * Decompiled with CFR 0.152.
 */
package com.ahamed.multiviewadapter;

import com.ahamed.multiviewadapter.ItemBinder;
import com.ahamed.multiviewadapter.RecyclerAdapter;
import com.ahamed.multiviewadapter.SelectableBinder;
import com.ahamed.multiviewadapter.SelectableViewHolder;

public class SelectableAdapter
extends RecyclerAdapter
implements SelectableViewHolder.OnItemSelectedListener {
    public static final int SELECTION_MODE_NONE = -1;
    public static final int SELECTION_MODE_SINGLE = 1;
    public static final int SELECTION_MODE_SINGLE_OR_NONE = 2;
    public static final int SELECTION_MODE_MULTIPLE = 3;
    private int lastSelectedIndex = -1;
    private int selectionMode = -1;

    @Override
    public final void onItemSelected(int adapterPosition) {
        switch (this.selectionMode) {
            case 1: {
                if (this.lastSelectedIndex == adapterPosition) {
                    return;
                }
                if (this.lastSelectedIndex != -1) {
                    this.getDataManager(this.lastSelectedIndex).onItemSelectionToggled(this.getItemPositionInManager(this.lastSelectedIndex), false);
                }
                this.getDataManager(adapterPosition).onItemSelectionToggled(this.getItemPositionInManager(adapterPosition), true);
                this.lastSelectedIndex = adapterPosition;
                break;
            }
            case 2: {
                if (this.lastSelectedIndex != -1) {
                    this.getDataManager(this.lastSelectedIndex).onItemSelectionToggled(this.getItemPositionInManager(this.lastSelectedIndex), false);
                }
                this.getDataManager(adapterPosition).onItemSelectionToggled(this.getItemPositionInManager(adapterPosition), this.lastSelectedIndex != adapterPosition);
                this.lastSelectedIndex = this.lastSelectedIndex != adapterPosition ? adapterPosition : -1;
                break;
            }
            case 3: {
                this.getDataManager(adapterPosition).onItemSelectionToggled(this.getItemPositionInManager(adapterPosition), !this.isItemSelected(adapterPosition));
                break;
            }
        }
    }

    @Override
    boolean isItemSelected(int adapterPosition) {
        return this.getDataManager(adapterPosition).isItemSelected(this.getItemPositionInManager(adapterPosition));
    }

    @Override
    void addBinder(ItemBinder binder) {
        if (binder instanceof SelectableBinder) {
            ((SelectableBinder)binder).setListener(this);
        }
        super.addBinder(binder);
    }

    void setLastSelectedIndex(int index) {
        this.lastSelectedIndex = index;
    }

    int getSelectionMode() {
        return this.selectionMode;
    }

    public final void setSelectionMode(int selectionMode) {
        this.selectionMode = selectionMode;
    }
}

