/*
 * Decompiled with CFR 0.152.
 */
package com.ahamed.multiviewadapter;

import android.graphics.Canvas;
import android.graphics.Rect;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import com.ahamed.multiviewadapter.ItemBinder;
import com.ahamed.multiviewadapter.RecyclerAdapter;

class ItemDecorationManager
extends RecyclerView.ItemDecoration {
    private final RecyclerAdapter adapter;

    ItemDecorationManager(RecyclerAdapter adapter) {
        this.adapter = adapter;
    }

    public void getItemOffsets(Rect outRect, View view, RecyclerView parent, RecyclerView.State state) {
        boolean isReverseLayout = this.getIsReverseLayout(parent);
        ItemBinder binder = this.adapter.getBinderForPosition(parent.getChildAdapterPosition(view));
        if (binder.isItemDecorationEnabled()) {
            int itemPosition = this.adapter.getItemPositionInManager(parent.getChildAdapterPosition(view));
            int positionType = this.getPositionType(parent, view, itemPosition, isReverseLayout);
            binder.getItemOffsets(outRect, itemPosition, positionType);
        }
    }

    public void onDraw(Canvas canvas, RecyclerView parent, RecyclerView.State state) {
        boolean isReverseLayout = this.getIsReverseLayout(parent);
        int childCount = parent.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = parent.getChildAt(i);
            ItemBinder binder = this.adapter.getBinderForPosition(parent.getChildAdapterPosition(child));
            if (!binder.isItemDecorationEnabled()) continue;
            int itemPosition = this.adapter.getItemPositionInManager(parent.getChildAdapterPosition(child));
            int positionType = this.getPositionType(parent, child, itemPosition, isReverseLayout);
            binder.onDraw(canvas, parent, child, itemPosition, positionType);
        }
    }

    private boolean getIsReverseLayout(RecyclerView parent) {
        return parent.getLayoutManager() instanceof LinearLayoutManager && ((LinearLayoutManager)parent.getLayoutManager()).getReverseLayout();
    }

    private int getPositionType(RecyclerView parent, View child, int itemPosition, boolean isReverseLayout) {
        boolean isLastItem;
        boolean isFirstItem;
        boolean bl = isReverseLayout ? this.adapter.isLastItemInManager(parent.getChildAdapterPosition(child)) : (isFirstItem = itemPosition == 0);
        boolean bl2 = isReverseLayout ? itemPosition == 0 : (isLastItem = this.adapter.isLastItemInManager(parent.getChildAdapterPosition(child)));
        return isFirstItem ? 1 : (isLastItem ? 3 : 2);
    }
}

