/*
 * Decompiled with CFR 0.152.
 */
package com.ahamed.multiviewadapter;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.support.v4.view.ViewCompat;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import com.ahamed.multiviewadapter.ItemDecorator;

public class SimpleItemDecoration
implements ItemDecorator {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    private static final int[] ATTRS = new int[]{16843284};
    private final Rect mBounds = new Rect();
    private Drawable mDivider;
    private int mOrientation;

    public SimpleItemDecoration(Context context, int orientation) {
        TypedArray a = context.obtainStyledAttributes(ATTRS);
        this.mDivider = a.getDrawable(0);
        a.recycle();
        this.setOrientation(orientation);
    }

    @Override
    public void getItemOffsets(Rect outRect, int position, int positionType) {
        if (positionType == 3) {
            return;
        }
        if (this.mOrientation == 1) {
            outRect.set(0, 0, 0, this.mDivider.getIntrinsicHeight());
        } else {
            outRect.set(0, 0, this.mDivider.getIntrinsicWidth(), 0);
        }
    }

    @Override
    public void onDraw(Canvas canvas, RecyclerView parent, View child, int position, int positionType) {
        if (parent.getLayoutManager() == null) {
            return;
        }
        if (positionType == 3) {
            return;
        }
        if (this.mOrientation == 1) {
            this.drawVertical(canvas, parent, child);
        } else {
            this.drawHorizontal(canvas, parent, child);
        }
    }

    public void setOrientation(int orientation) {
        if (orientation != 0 && orientation != 1) {
            throw new IllegalArgumentException("Invalid orientation. It should be either HORIZONTAL or VERTICAL");
        }
        this.mOrientation = orientation;
    }

    @SuppressLint(value={"NewApi"})
    private void drawVertical(Canvas canvas, RecyclerView parent, View child) {
        int right;
        int left;
        canvas.save();
        if (parent.getClipToPadding()) {
            left = parent.getPaddingLeft();
            right = parent.getWidth() - parent.getPaddingRight();
            canvas.clipRect(left, parent.getPaddingTop(), right, parent.getHeight() - parent.getPaddingBottom());
        } else {
            left = 0;
            right = parent.getWidth();
        }
        parent.getDecoratedBoundsWithMargins(child, this.mBounds);
        int bottom = this.mBounds.bottom + Math.round(ViewCompat.getTranslationY((View)child));
        int top = bottom - this.mDivider.getIntrinsicHeight();
        this.mDivider.setBounds(left, top, right, bottom);
        this.mDivider.draw(canvas);
        canvas.restore();
    }

    @SuppressLint(value={"NewApi"})
    private void drawHorizontal(Canvas canvas, RecyclerView parent, View child) {
        int bottom;
        int top;
        canvas.save();
        if (parent.getClipToPadding()) {
            top = parent.getPaddingTop();
            bottom = parent.getHeight() - parent.getPaddingBottom();
            canvas.clipRect(parent.getPaddingLeft(), top, parent.getWidth() - parent.getPaddingRight(), bottom);
        } else {
            top = 0;
            bottom = parent.getHeight();
        }
        parent.getLayoutManager().getDecoratedBoundsWithMargins(child, this.mBounds);
        int right = this.mBounds.right + Math.round(ViewCompat.getTranslationX((View)child));
        int left = right - this.mDivider.getIntrinsicWidth();
        this.mDivider.setBounds(left, top, right, bottom);
        this.mDivider.draw(canvas);
        canvas.restore();
    }
}

