/*
 * Decompiled with CFR 0.152.
 */
package com.ahamed.multiviewadapter;

import android.content.Context;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import com.ahamed.multiviewadapter.BaseDataManager;
import com.ahamed.multiviewadapter.BaseViewHolder;
import com.ahamed.multiviewadapter.ItemBinder;
import com.ahamed.multiviewadapter.ItemDecorationManager;
import java.util.ArrayList;
import java.util.List;

public class RecyclerAdapter
extends RecyclerView.Adapter<BaseViewHolder> {
    private List<ItemBinder> binders = new ArrayList<ItemBinder>();
    private List<BaseDataManager> dataManagers = new ArrayList<BaseDataManager>();
    private ItemDecorationManager itemDecorationManager;
    private int maxSpanCount = 1;
    private final GridLayoutManager.SpanSizeLookup spanSizeLookup = new GridLayoutManager.SpanSizeLookup(){

        public int getSpanSize(int position) {
            return RecyclerAdapter.this.getBinderForPosition(position).getSpanSize(RecyclerAdapter.this.maxSpanCount);
        }
    };

    protected RecyclerAdapter() {
        this.itemDecorationManager = new ItemDecorationManager(this);
    }

    public final BaseViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        return this.binders.get(viewType).createViewHolder(LayoutInflater.from((Context)parent.getContext()), parent);
    }

    public final void onBindViewHolder(BaseViewHolder holder, int adapterPosition) {
        this.onBindViewHolder(holder, adapterPosition, null);
    }

    public final void onBindViewHolder(BaseViewHolder holder, int adapterPosition, List<Object> payloads) {
        ItemBinder baseBinder = this.binders.get(holder.getItemViewType());
        int totalCount = 0;
        for (BaseDataManager dataManager : this.dataManagers) {
            if (adapterPosition >= (totalCount += dataManager.getCount())) continue;
            holder.setItem(dataManager.getItem(this.getItemPositionInManager(adapterPosition)));
            break;
        }
        if (null == payloads) {
            baseBinder.bindViewHolder(holder, holder.getItem(), this.isItemSelected(adapterPosition));
        } else {
            baseBinder.bindViewHolder(holder, holder.getItem(), this.isItemSelected(adapterPosition), payloads);
        }
    }

    public final int getItemCount() {
        int itemCount = 0;
        int size = this.dataManagers.size();
        for (int i = 0; i < size; ++i) {
            itemCount += this.dataManagers.get(i).size();
        }
        return itemCount;
    }

    public final int getItemViewType(int adapterPosition) {
        ItemBinder baseBinder = this.getBinderForPosition(adapterPosition);
        if (null != baseBinder) {
            return this.binders.indexOf(baseBinder);
        }
        return super.getItemViewType(adapterPosition);
    }

    public final void setSpanCount(int maxSpanCount) {
        this.maxSpanCount = maxSpanCount;
    }

    public final GridLayoutManager.SpanSizeLookup getSpanSizeLookup() {
        return this.spanSizeLookup;
    }

    public ItemDecorationManager getItemDecorationManager() {
        return this.itemDecorationManager;
    }

    protected final void addDataManager(BaseDataManager dataManager) {
        this.dataManagers.add(dataManager);
    }

    protected final void registerBinder(ItemBinder binder) {
        this.addBinder(binder);
    }

    ItemBinder getBinderForPosition(int adapterPosition) {
        BaseDataManager dataManager = this.getDataManager(adapterPosition);
        for (ItemBinder baseBinder : this.binders) {
            if (!baseBinder.canBindData(dataManager.getItem(this.getItemPositionInManager(adapterPosition)))) continue;
            return baseBinder;
        }
        throw new IllegalStateException("Binder not found for position. Position = " + adapterPosition);
    }

    int getItemPositionInManager(int adapterPosition) {
        int binderItemCount;
        int size = this.dataManagers.size();
        for (int i = 0; i < size && adapterPosition - (binderItemCount = this.dataManagers.get(i).getCount()) >= 0; ++i) {
            adapterPosition -= binderItemCount;
        }
        return adapterPosition;
    }

    BaseDataManager getDataManager(int adapterPosition) {
        int processedCount = 0;
        for (BaseDataManager dataManager : this.dataManagers) {
            if (adapterPosition >= (processedCount += dataManager.getCount())) continue;
            return dataManager;
        }
        throw new IllegalStateException("Invalid position for DataManager!");
    }

    private int getPosition(BaseDataManager dataManager, int binderPosition) {
        int viewType = this.dataManagers.indexOf(dataManager);
        if (viewType < 0) {
            throw new IllegalStateException("DataManager does not exist in adapter");
        }
        int position = binderPosition;
        for (int i = 0; i < viewType; ++i) {
            position += this.dataManagers.get(i).getCount();
        }
        return position;
    }

    boolean isItemSelected(int adapterPosition) {
        return false;
    }

    final void notifyBinderItemRangeChanged(BaseDataManager binder, int positionStart, int itemCount, Object payload) {
        this.notifyItemRangeChanged(this.getPosition(binder, positionStart), itemCount, payload);
    }

    final void notifyBinderItemMoved(BaseDataManager binder, int fromPosition, int toPosition) {
        this.notifyItemMoved(this.getPosition(binder, fromPosition), this.getPosition(binder, toPosition));
    }

    final void notifyBinderItemRangeInserted(BaseDataManager binder, int positionStart, int itemCount) {
        this.notifyItemRangeInserted(this.getPosition(binder, positionStart), itemCount);
    }

    final void notifyBinderItemRangeRemoved(BaseDataManager binder, int positionStart, int itemCount) {
        this.notifyItemRangeRemoved(this.getPosition(binder, positionStart), itemCount);
    }

    void addBinder(ItemBinder binder) {
        this.binders.add(binder);
    }

    boolean isLastItemInManager(int adapterPosition) {
        int size = this.dataManagers.size();
        for (int i = 0; i < size; ++i) {
            int itemsCount = this.dataManagers.get(i).getCount();
            if (adapterPosition - itemsCount < 0) {
                return adapterPosition == itemsCount - 1;
            }
            adapterPosition -= itemsCount;
        }
        return false;
    }
}

