/*
 * Decompiled with CFR 0.152.
 */
package com.ahamed.multiviewadapter;

import android.support.annotation.NonNull;
import android.support.v7.util.DiffUtil;
import android.support.v7.util.ListUpdateCallback;
import com.ahamed.multiviewadapter.BaseDataManager;
import com.ahamed.multiviewadapter.DiffUtilCallback;
import com.ahamed.multiviewadapter.RecyclerAdapter;
import java.util.Collection;
import java.util.List;

public class DataListManager<M>
extends BaseDataManager<M> {
    public DataListManager(RecyclerAdapter baseAdapter) {
        super(baseAdapter);
    }

    public final boolean add(M item) {
        boolean result = this.getDataList().add(item);
        if (result) {
            this.onInserted(this.getDataList().size() - 1, 1);
        }
        return result;
    }

    public final boolean addAll(@NonNull Collection<? extends M> items) {
        return this.addAll(this.getDataList().size(), items);
    }

    public final boolean addAll(int index, @NonNull Collection<? extends M> items) {
        boolean result = this.getDataList().addAll(index, items);
        if (result) {
            this.onInserted(index, items.size());
        }
        return result;
    }

    public final void add(int index, M item) {
        this.getDataList().add(index, item);
        this.onInserted(index, 1);
    }

    public final void set(int index, M item) {
        Object oldItem = this.getDataList().get(index);
        this.getDataList().set(index, item);
        this.onChanged(index, 1, this.getChangePayload(oldItem, (Object)item));
    }

    public final void set(List<M> dataList) {
        DiffUtil.DiffResult result = DiffUtil.calculateDiff((DiffUtil.Callback)new DiffUtilCallback<M>(this.getDataList(), dataList){

            @Override
            public boolean areContentsTheSame(M oldItem, M newItem) {
                return DataListManager.this.areContentsTheSame(oldItem, newItem);
            }

            @Override
            public Object getChangePayload(M oldItem, M newItem) {
                return DataListManager.this.getChangePayload(oldItem, newItem);
            }
        });
        this.setDataList(dataList);
        result.dispatchUpdatesTo((ListUpdateCallback)this);
    }

    public final void remove(M item) {
        int index = this.getDataList().indexOf(item);
        boolean result = this.getDataList().remove(item);
        if (result) {
            this.onRemoved(index, 1);
        }
    }

    public final void remove(int index) {
        if (index >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        this.getDataList().remove(index);
        this.onRemoved(index, 1);
    }

    public final void clear() {
        if (this.size() <= 0) {
            return;
        }
        int oldSize = this.getDataList().size();
        this.getDataList().clear();
        this.onRemoved(0, oldSize);
    }
}

