/*
 * Decompiled with CFR 0.152.
 */
package com.ahamed.multiviewadapter;

import android.support.v7.util.DiffUtil;
import android.support.v7.util.ListUpdateCallback;
import com.ahamed.multiviewadapter.BaseDataManager;
import com.ahamed.multiviewadapter.DiffUtilCallback;
import com.ahamed.multiviewadapter.RecyclerListAdapter;
import java.util.List;

public class DataListManager<M>
extends BaseDataManager<M> {
    public DataListManager(RecyclerListAdapter baseAdapter) {
        super(baseAdapter);
    }

    public final void add(M item) {
        this.add(this.getDataList().size(), item);
    }

    public final void addAll(List<M> items) {
        this.addAll(this.getDataList().size(), items);
    }

    public final void add(int index, M item) {
        this.getDataList().add(index, item);
        this.onInserted(index, 1);
    }

    public final void addAll(int index, List<M> items) {
        this.getDataList().addAll(index, items);
        this.onInserted(index, items.size());
    }

    public final void set(int position, M item) {
        Object oldItem = this.getDataList().get(position);
        this.getDataList().set(position, item);
        this.onChanged(position, 1, this.getChangePayload(oldItem, (Object)item));
    }

    public final void set(List<M> dataList) {
        DiffUtil.DiffResult result = DiffUtil.calculateDiff((DiffUtil.Callback)new DiffUtilCallback<M>(this.getDataList(), dataList){

            @Override
            public boolean areContentsTheSame(M oldItem, M newItem) {
                return DataListManager.this.areContentsTheSame(oldItem, newItem);
            }

            @Override
            public Object getChangePayload(M oldItem, M newItem) {
                return DataListManager.this.getChangePayload(oldItem, newItem);
            }
        });
        this.setDataList(dataList);
        result.dispatchUpdatesTo((ListUpdateCallback)this);
    }

    public final void remove(M item) {
        this.remove(this.getDataList().indexOf(item));
    }

    public final void remove(int index) {
        this.getDataList().remove(index);
        this.onRemoved(index, 1);
    }

    public final void removeAll() {
        int oldSize = this.getDataList().size();
        this.getDataList().clear();
        this.onRemoved(0, oldSize);
    }
}

