/*
 * Decompiled with CFR 0.152.
 */
package com.ahamed.multiviewadapter;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import com.ahamed.multiviewadapter.BaseBinder;
import com.ahamed.multiviewadapter.BaseDataManager;
import com.ahamed.multiviewadapter.BaseViewHolder;
import java.util.ArrayList;
import java.util.List;

public class RecyclerListAdapter
extends RecyclerView.Adapter<BaseViewHolder> {
    private List<BaseBinder> binders = new ArrayList<BaseBinder>();
    private List<BaseDataManager> dataManagers = new ArrayList<BaseDataManager>();

    public final BaseViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        return this.binders.get(viewType).create(LayoutInflater.from((Context)parent.getContext()), parent);
    }

    public final void onBindViewHolder(BaseViewHolder holder, int position) {
        this.onBindViewHolder(holder, position, null);
    }

    public final void onBindViewHolder(BaseViewHolder holder, int position, List<Object> payloads) {
        BaseBinder baseBinder = this.binders.get(holder.getItemViewType());
        int totalCount = 0;
        for (BaseDataManager dataManager : this.dataManagers) {
            if (position >= (totalCount += dataManager.getCount())) continue;
            holder.setItem(dataManager.getItem(this.getItemPositionInManager(position)));
            break;
        }
        if (null == payloads) {
            baseBinder.bind(holder, holder.getItem());
        } else {
            baseBinder.bind(holder, holder.getItem(), payloads);
        }
    }

    public final int getItemCount() {
        int itemCount = 0;
        int size = this.dataManagers.size();
        for (int i = 0; i < size; ++i) {
            BaseDataManager dataManager = this.dataManagers.get(i);
            itemCount += dataManager.getCount();
        }
        return itemCount;
    }

    public final int getItemViewType(int position) {
        BaseBinder baseBinder = this.getBinderForPosition(position);
        if (null != baseBinder) {
            return this.binders.indexOf(baseBinder);
        }
        return super.getItemViewType(position);
    }

    BaseBinder getBinderForPosition(int position) {
        int processedCount = 0;
        for (BaseDataManager dataManager : this.dataManagers) {
            if (position >= (processedCount += dataManager.getCount())) continue;
            for (BaseBinder baseBinder : this.binders) {
                if (!dataManager.getItem(this.getItemPositionInManager(position)).getClass().isAssignableFrom(baseBinder.getType())) continue;
                return baseBinder;
            }
        }
        throw new IllegalStateException("Binder not found for position. Position = " + position);
    }

    final int getItemPositionInManager(int position) {
        int binderItemCount;
        int size = this.dataManagers.size();
        for (int i = 0; i < size && position - (binderItemCount = this.dataManagers.get(i).getCount()) >= 0; ++i) {
            position -= binderItemCount;
        }
        return position;
    }

    final BaseDataManager getDataManager(int position) {
        int processedCount = 0;
        for (BaseDataManager dataManager : this.dataManagers) {
            if (position >= (processedCount += dataManager.getCount())) continue;
            return dataManager;
        }
        throw new IllegalStateException("Invalid position!");
    }

    private int getPosition(BaseDataManager dataManager, int binderPosition) {
        int viewType = this.dataManagers.indexOf(dataManager);
        if (viewType < 0) {
            throw new IllegalStateException("DataManager does not exist in adapter");
        }
        int position = binderPosition;
        for (int i = 0; i < viewType; ++i) {
            position += this.dataManagers.get(i).getCount();
        }
        return position;
    }

    final void notifyBinderItemRangeChanged(BaseDataManager binder, int positionStart, int itemCount, Object payload) {
        this.notifyItemRangeChanged(this.getPosition(binder, positionStart), itemCount);
    }

    final void notifyBinderItemMoved(BaseDataManager binder, int fromPosition, int toPosition) {
        this.notifyItemMoved(this.getPosition(binder, fromPosition), this.getPosition(binder, toPosition));
    }

    final void notifyBinderItemRangeInserted(BaseDataManager binder, int positionStart, int itemCount) {
        this.notifyItemRangeInserted(this.getPosition(binder, positionStart), itemCount);
    }

    final void notifyBinderItemRangeRemoved(BaseDataManager binder, int positionStart, int itemCount) {
        this.notifyItemRangeRemoved(this.getPosition(binder, positionStart), itemCount);
    }

    protected final void addDataManager(BaseDataManager dataManager) {
        this.dataManagers.add(dataManager);
    }

    protected final void registerBinder(BaseBinder binder) {
        this.binders.add(binder);
    }
}

