/*
 * Decompiled with CFR 0.152.
 */
package org.socialsignin.spring.data.dynamodb.repository.config;

import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapper;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapperConfig;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.Autowired;

public class DynamoDBMapperFactory
implements FactoryBean<DynamoDBMapper> {
    private final AmazonDynamoDB amazonDynamoDB;
    private final DynamoDBMapperConfig dynamoDBMapperConfig;

    @Autowired
    public DynamoDBMapperFactory(AmazonDynamoDB amazonDynamoDB, DynamoDBMapperConfig dynamoDBMapperConfig) {
        this.amazonDynamoDB = amazonDynamoDB;
        this.dynamoDBMapperConfig = dynamoDBMapperConfig;
    }

    public DynamoDBMapper getObject() throws Exception {
        return new DynamoDBMapper(this.amazonDynamoDB, this.dynamoDBMapperConfig);
    }

    public Class<?> getObjectType() {
        return DynamoDBMapper.class;
    }
}

