/*
 * Decompiled with CFR 0.152.
 */
package com.github.debop.kodatimes;

import com.github.debop.kodatimes.DurationBuilder;
import com.github.debop.kodatimes.KodaTimeExtensions;
import com.github.debop.kodatimes.TimestampZoneText;
import java.sql.Timestamp;
import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.Interval;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import org.joda.time.MutableDateTime;
import org.joda.time.Period;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;
import org.joda.time.ReadablePeriod;
import org.joda.time.base.AbstractInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u0000\u00ac\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\t2\u0006\u0010\u000b\u001a\u00020\f\u001a\u000e\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\f\u001aL\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u00112\b\b\u0002\u0010\u0013\u001a\u00020\u00112\b\b\u0002\u0010\u0014\u001a\u00020\u00112\b\b\u0002\u0010\u0015\u001a\u00020\u00112\b\b\u0002\u0010\u0016\u001a\u00020\u00112\b\b\u0002\u0010\u0017\u001a\u00020\u0011H\u0007\u001a\u0006\u0010\u0018\u001a\u00020\u0001\u001a\u0006\u0010\u0019\u001a\u00020\u0001\u001a\u0006\u0010\u001a\u001a\u00020\u0001\u001a\u0006\u0010\u001b\u001a\u00020\u0001\u001a\u0006\u0010\u001c\u001a\u00020\u0001\u001a\u0006\u0010\u001d\u001a\u00020\u0001\u001a\u0006\u0010\u001e\u001a\u00020\u0001\u001a\u0006\u0010\u001f\u001a\u00020\u0001\u001a\u0006\u0010 \u001a\u00020\u0001\u001a\u0006\u0010!\u001a\u00020\u0001\u001a\u0006\u0010\"\u001a\u00020\u0001\u001a\u0006\u0010#\u001a\u00020\u0001\u001a\u0006\u0010$\u001a\u00020\u0001\u001a\u0006\u0010%\u001a\u00020\u0001\u001a\u0006\u0010&\u001a\u00020\u0001\u001a\u000e\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0011\u001a\u000e\u0010*\u001a\u00020(2\u0006\u0010+\u001a\u00020\u0011\u001a\u000e\u0010,\u001a\u00020(2\u0006\u0010-\u001a\u00020\u0011\u001a\u000e\u0010.\u001a\u00020(2\u0006\u0010-\u001a\u00020\u0011\u001a\u000e\u0010/\u001a\u00020(2\u0006\u0010-\u001a\u00020\u0011\u001a\u000e\u00100\u001a\u00020(2\u0006\u00101\u001a\u00020\u0011\u001a\u000e\u00102\u001a\u00020(2\u0006\u00103\u001a\u00020\u0011\u001a\u000e\u00104\u001a\u00020(2\u0006\u00105\u001a\u00020\u0011\u001a\u000e\u00106\u001a\u00020\u00052\u0006\u00107\u001a\u000208\u001a\u000e\u00109\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u000208\u001a\u000e\u0010:\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u000208\u001a\u000e\u0010;\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u000208\u001a\u0006\u0010<\u001a\u00020=\u001a\u0006\u0010>\u001a\u00020=\u001a\u0006\u0010?\u001a\u00020=\u001a\u0006\u0010@\u001a\u00020\u0001\u001a\u0006\u0010A\u001a\u00020\u0001\u001a\n\u0010B\u001a\u00020\u0005*\u00020\u0005\u001a\n\u0010C\u001a\u00020\u0001*\u00020\u0005\u001a\n\u0010D\u001a\u00020\u0001*\u00020(\u001a\n\u0010E\u001a\u00020\u0001*\u00020\u0005\u001a\u0016\u0010F\u001a\u00020\u0001*\u00020\u00012\b\b\u0002\u0010G\u001a\u00020HH\u0007\u001a\n\u0010I\u001a\u00020\u0001*\u00020\u0001\u001a\u0012\u0010J\u001a\u00020\u0001*\u00020(2\u0006\u0010K\u001a\u00020\u0001\u001a\n\u0010L\u001a\u00020\u0001*\u00020M\u001a\n\u0010N\u001a\u00020=*\u00020\u0001\u001a\n\u00107\u001a\u00020(*\u00020\u0011\u001a\n\u00107\u001a\u00020(*\u000208\u001a\n\u00107\u001a\u000208*\u00020\u0005\u001a\u0010\u00107\u001a\b\u0012\u0004\u0012\u00020\u00010O*\u00020P\u001a\u0012\u0010Q\u001a\u00020\u0005*\u00020\u00052\u0006\u0010R\u001a\u00020\u0005\u001a\u0015\u0010S\u001a\u00020\u0005*\u00020\u00052\u0006\u0010T\u001a\u000208H\u0086\u0002\u001a\u0012\u0010U\u001a\u00020\u0001*\u00020(2\u0006\u0010K\u001a\u00020\u0001\u001a\n\u0010V\u001a\u00020\u0001*\u00020\u0005\u001a\n\u0010\u0014\u001a\u00020W*\u00020\u0011\u001a\n\u0010\u0014\u001a\u00020W*\u000208\u001a\n\u0010\u0014\u001a\u000208*\u00020\u0005\u001a\u0010\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00010O*\u00020P\u001a\n\u0010X\u001a\u00020Y*\u00020\u0005\u001a\n\u0010\u0018\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\u0019\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\u001a\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\u001b\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\u001c\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\u001d\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\u001e\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010Z\u001a\u00020\u0001*\u00020(\u001a\u0015\u0010[\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\\\u001a\u00020\u0001H\u0086\u0004\u001a\u0015\u0010[\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\\\u001a\u00020\u0005H\u0086\u0004\u001a\n\u0010\u0017\u001a\u00020W*\u00020\u0011\u001a\n\u0010\u0017\u001a\u00020W*\u000208\u001a\n\u0010\u0017\u001a\u000208*\u00020P\u001a\u0015\u0010]\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\\\u001a\u00020\u0001H\u0086\u0004\u001a\u0015\u0010]\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\\\u001a\u00020\u0005H\u0086\u0004\u001a\u0015\u0010^\u001a\u00020\u0001*\u00020\u00012\u0006\u0010_\u001a\u00020WH\u0086\u0002\u001a\u0015\u0010^\u001a\u00020`*\u00020`2\u0006\u0010_\u001a\u00020WH\u0086\u0002\u001a\u0015\u0010^\u001a\u00020a*\u00020a2\u0006\u0010_\u001a\u00020WH\u0086\u0002\u001a\u0015\u0010^\u001a\u00020b*\u00020b2\u0006\u0010_\u001a\u00020WH\u0086\u0002\u001a\u0015\u0010^\u001a\u00020c*\u00020c2\u0006\u0010_\u001a\u00020WH\u0086\u0002\u001a\n\u0010\u0015\u001a\u00020W*\u00020\u0011\u001a\n\u0010\u0015\u001a\u00020W*\u000208\u001a\n\u0010\u0015\u001a\u000208*\u00020\u0005\u001a\u0010\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00010O*\u00020P\u001a\n\u0010d\u001a\u00020=*\u00020\u0001\u001a\n\u0010e\u001a\u00020(*\u00020\u0011\u001a\n\u0010e\u001a\u00020(*\u000208\u001a\u0010\u0010e\u001a\b\u0012\u0004\u0012\u00020\u00010O*\u00020P\u001a\n\u0010f\u001a\u00020g*\u00020M\u001a\n\u0010\u001f\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010 \u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010!\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\"\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010#\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010$\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010%\u001a\u00020\u0001*\u00020\u0001\u001a\u0015\u0010h\u001a\u00020\u0001*\u00020\u00012\u0006\u0010_\u001a\u00020WH\u0086\u0002\u001a\u0015\u0010h\u001a\u00020`*\u00020`2\u0006\u0010_\u001a\u00020WH\u0086\u0002\u001a\u0015\u0010h\u001a\u00020a*\u00020a2\u0006\u0010_\u001a\u00020WH\u0086\u0002\u001a\u0015\u0010h\u001a\u00020b*\u00020b2\u0006\u0010_\u001a\u00020WH\u0086\u0002\u001a\u0015\u0010h\u001a\u00020c*\u00020c2\u0006\u0010_\u001a\u00020WH\u0086\u0002\u001a\u0015\u0010i\u001a\u00020=*\u00020j2\u0006\u0010R\u001a\u00020jH\u0086\u0002\u001a\n\u0010\u0016\u001a\u00020W*\u00020\u0011\u001a\n\u0010\u0016\u001a\u00020W*\u000208\u001a\n\u0010\u0016\u001a\u000208*\u00020\u0005\u001a\u0010\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00010O*\u00020P\u001a\n\u0010k\u001a\u00020\u0005*\u00020(\u001a\n\u0010l\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010m\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010n\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010o\u001a\u00020\u0001*\u00020\u0001\u001a\u001b\u0010p\u001a\b\u0012\u0004\u0012\u00020\u00010O*\u00020P2\u0006\u0010q\u001a\u00020rH\u0086\u0004\u001a\u0015\u0010s\u001a\u00020W*\u00020\u00112\u0006\u0010_\u001a\u00020WH\u0086\u0002\u001a\u0015\u0010s\u001a\u00020(*\u00020\u00112\u0006\u0010t\u001a\u00020(H\u0086\u0002\u001a\u0015\u0010s\u001a\u00020W*\u0002082\u0006\u0010_\u001a\u00020WH\u0086\u0002\u001a\u0015\u0010s\u001a\u00020(*\u0002082\u0006\u0010t\u001a\u00020(H\u0086\u0002\u001a\u0015\u0010s\u001a\u00020\u0005*\u00020\u00052\u0006\u0010u\u001a\u000208H\u0086\u0002\u001a\n\u0010v\u001a\u00020\u0001*\u00020w\u001a\u0018\u0010v\u001a\u0004\u0018\u00010\u0001*\u00020\f2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u001a\f\u0010x\u001a\u0004\u0018\u00010=*\u00020\f\u001a\n\u0010y\u001a\u00020\f*\u00020\u0001\u001a\n\u0010z\u001a\u00020\f*\u00020\u0001\u001a\n\u0010{\u001a\u00020\f*\u00020\u0001\u001a\n\u0010|\u001a\u00020\f*\u00020\u0001\u001a\n\u0010}\u001a\u00020\f*\u00020\u0001\u001a\n\u0010~\u001a\u00020a*\u00020w\u001a\u0018\u0010~\u001a\u0004\u0018\u00010a*\u00020\f2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u001a\n\u0010\u007f\u001a\u00020b*\u00020w\u001a\u000b\u0010\u0080\u0001\u001a\u00020c*\u00020w\u001a\u0019\u0010\u0080\u0001\u001a\u0004\u0018\u00010c*\u00020\f2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u001a\f\u0010\u0081\u0001\u001a\u00030\u0082\u0001*\u00020\u0001\u001a\f\u0010\u0083\u0001\u001a\u00030\u0084\u0001*\u00020\u0001\u001a\n\u0010@\u001a\u00020\u0001*\u00020\u0001\u001a\u000e\u0010\u0085\u0001\u001a\u00020\u0005*\u00020\u0005H\u0086\u0002\u001a\u000b\u0010\u0086\u0001\u001a\u00020(*\u00020\u0011\u001a\u000b\u0010\u0086\u0001\u001a\u00020(*\u000208\u001a\u0011\u0010\u0086\u0001\u001a\b\u0012\u0004\u0012\u00020\u00010O*\u00020P\u001a\u000b\u0010\u0087\u0001\u001a\u00020(*\u00020\u0011\u001a\u000b\u0010\u0087\u0001\u001a\u00020(*\u000208\u001a\n\u0010A\u001a\u00020\u0001*\u00020\u0001\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0088\u0001"}, d2={"EPOCH", "Lorg/joda/time/DateTime;", "getEPOCH", "()Lorg/joda/time/DateTime;", "emptyDuration", "Lorg/joda/time/Duration;", "getEmptyDuration", "()Lorg/joda/time/Duration;", "dateTimeFormat", "Lorg/joda/time/format/DateTimeFormatter;", "kotlin.jvm.PlatformType", "pattern", "", "dateTimeFromJson", "json", "dateTimeOf", "year", "", "month", "day", "hours", "minutes", "seconds", "millis", "lastDay", "lastHour", "lastMinute", "lastMonth", "lastSecond", "lastWeek", "lastYear", "nextDay", "nextHour", "nextMinute", "nextMonth", "nextSecond", "nextWeek", "nextYear", "now", "periodOfDay", "Lorg/joda/time/Period;", "d", "periodOfHours", "h", "periodOfMillis", "m", "periodOfMinutes", "periodOfMonths", "periodOfSeconds", "s", "periodOfWeek", "w", "periodOfYears", "y", "standardDays", "days", "", "standardHours", "standardMinutes", "standardSeconds", "thisHour", "Lorg/joda/time/Interval;", "thisMinute", "thisSecond", "tomorrow", "yesterday", "abs", "afterEpoch", "ago", "agoNow", "asLocal", "tz", "Lorg/joda/time/DateTimeZone;", "asUtc", "before", "moment", "dateTimeUTC", "Lorg/joda/time/base/AbstractInstant;", "dayInterval", "Lkotlin/sequences/Sequence;", "Lorg/joda/time/ReadableInterval;", "diff", "other", "div", "divisor", "from", "fromNow", "Lcom/github/debop/kodatimes/DurationBuilder;", "isZero", "", "later", "max", "that", "min", "minus", "builder", "Lorg/joda/time/Instant;", "Lorg/joda/time/LocalDate;", "Lorg/joda/time/LocalDateTime;", "Lorg/joda/time/LocalTime;", "monthInterval", "months", "mutableDateTimeUTC", "Lorg/joda/time/MutableDateTime;", "plus", "rangeTo", "Lorg/joda/time/ReadableInstant;", "standardDuration", "startOfDay", "startOfMonth", "startOfWeek", "startOfYear", "step", "instance", "Lorg/joda/time/ReadablePeriod;", "times", "period", "multiplicand", "toDateTime", "Ljava/util/Date;", "toInterval", "toIsoFormatDateString", "toIsoFormatHMSString", "toIsoFormatString", "toIsoFormatTimeNoMillisString", "toIsoFormatTimeString", "toLocalDate", "toLocalDateTime", "toLocalTime", "toTimestamp", "Ljava/sql/Timestamp;", "toTimestampZoneText", "Lcom/github/debop/kodatimes/TimestampZoneText;", "unaryMinus", "weeks", "years", "koda-time-compileKotlin"})
@JvmName(name="KodaTimeExtensions")
public final class KodaTimeExtensions {
    @NotNull
    private static final DateTime EPOCH = new DateTime(0L);
    @NotNull
    private static final Duration emptyDuration;

    @NotNull
    public static final DateTime getEPOCH() {
        return EPOCH;
    }

    @NotNull
    public static final DateTime toDateTime(@NotNull Date $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return new DateTime($receiver.getTime());
    }

    @NotNull
    public static final LocalDateTime toLocalDateTime(@NotNull Date $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        LocalDateTime localDateTime = LocalDateTime.fromDateFields((Date)$receiver);
        Intrinsics.checkExpressionValueIsNotNull((Object)localDateTime, (String)"LocalDateTime.fromDateFields(this)");
        return localDateTime;
    }

    @NotNull
    public static final LocalDate toLocalDate(@NotNull Date $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        LocalDate localDate = LocalDate.fromDateFields((Date)$receiver);
        Intrinsics.checkExpressionValueIsNotNull((Object)localDate, (String)"LocalDate.fromDateFields(this)");
        return localDate;
    }

    @NotNull
    public static final LocalTime toLocalTime(@NotNull Date $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        LocalTime localTime = LocalTime.fromDateFields((Date)$receiver);
        Intrinsics.checkExpressionValueIsNotNull((Object)localTime, (String)"LocalTime.fromDateFields(this)");
        return localTime;
    }

    @NotNull
    public static final DateTime dateTimeUTC(@NotNull AbstractInstant $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        DateTime dateTime = $receiver.toDateTime(DateTimeZone.UTC);
        Intrinsics.checkExpressionValueIsNotNull((Object)dateTime, (String)"this.toDateTime(DateTimeZone.UTC)");
        return dateTime;
    }

    @NotNull
    public static final MutableDateTime mutableDateTimeUTC(@NotNull AbstractInstant $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        MutableDateTime mutableDateTime = $receiver.toMutableDateTime(DateTimeZone.UTC);
        Intrinsics.checkExpressionValueIsNotNull((Object)mutableDateTime, (String)"this.toMutableDateTime(DateTimeZone.UTC)");
        return mutableDateTime;
    }

    @NotNull
    public static final DurationBuilder millis(int $receiver) {
        Period period = Period.millis((int)$receiver);
        Intrinsics.checkExpressionValueIsNotNull((Object)period, (String)"Period.millis(this)");
        return new DurationBuilder(period);
    }

    @NotNull
    public static final DurationBuilder seconds(int $receiver) {
        Period period = Period.seconds((int)$receiver);
        Intrinsics.checkExpressionValueIsNotNull((Object)period, (String)"Period.seconds(this)");
        return new DurationBuilder(period);
    }

    @NotNull
    public static final DurationBuilder minutes(int $receiver) {
        Period period = Period.minutes((int)$receiver);
        Intrinsics.checkExpressionValueIsNotNull((Object)period, (String)"Period.minutes(this)");
        return new DurationBuilder(period);
    }

    @NotNull
    public static final DurationBuilder hours(int $receiver) {
        Period period = Period.hours((int)$receiver);
        Intrinsics.checkExpressionValueIsNotNull((Object)period, (String)"Period.hours(this)");
        return new DurationBuilder(period);
    }

    @NotNull
    public static final Period days(int $receiver) {
        Period period = Period.days((int)$receiver);
        Intrinsics.checkExpressionValueIsNotNull((Object)period, (String)"Period.days(this)");
        return period;
    }

    @NotNull
    public static final Period weeks(int $receiver) {
        Period period = Period.weeks((int)$receiver);
        Intrinsics.checkExpressionValueIsNotNull((Object)period, (String)"Period.weeks(this)");
        return period;
    }

    @NotNull
    public static final Period months(int $receiver) {
        Period period = Period.months((int)$receiver);
        Intrinsics.checkExpressionValueIsNotNull((Object)period, (String)"Period.months(this)");
        return period;
    }

    @NotNull
    public static final Period years(int $receiver) {
        Period period = Period.years((int)$receiver);
        Intrinsics.checkExpressionValueIsNotNull((Object)period, (String)"Period.years(this)");
        return period;
    }

    @NotNull
    public static final DurationBuilder times(int $receiver, @NotNull DurationBuilder builder) {
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        Period period = builder.getPeriod().multipliedBy($receiver);
        Intrinsics.checkExpressionValueIsNotNull((Object)period, (String)"builder.period.multipliedBy(this)");
        return new DurationBuilder(period);
    }

    @NotNull
    public static final Period times(int $receiver, @NotNull Period period) {
        Intrinsics.checkParameterIsNotNull((Object)period, (String)"period");
        Period period2 = period.multipliedBy($receiver);
        Intrinsics.checkExpressionValueIsNotNull((Object)period2, (String)"period.multipliedBy(this)");
        return period2;
    }

    @NotNull
    public static final DurationBuilder millis(long $receiver) {
        Period period = Period.millis((int)((int)$receiver));
        Intrinsics.checkExpressionValueIsNotNull((Object)period, (String)"Period.millis(this.toInt())");
        return new DurationBuilder(period);
    }

    @NotNull
    public static final DurationBuilder seconds(long $receiver) {
        Period period = Period.seconds((int)((int)$receiver));
        Intrinsics.checkExpressionValueIsNotNull((Object)period, (String)"Period.seconds(this.toInt())");
        return new DurationBuilder(period);
    }

    @NotNull
    public static final DurationBuilder minutes(long $receiver) {
        Period period = Period.minutes((int)((int)$receiver));
        Intrinsics.checkExpressionValueIsNotNull((Object)period, (String)"Period.minutes(this.toInt())");
        return new DurationBuilder(period);
    }

    @NotNull
    public static final DurationBuilder hours(long $receiver) {
        Period period = Period.hours((int)((int)$receiver));
        Intrinsics.checkExpressionValueIsNotNull((Object)period, (String)"Period.hours(this.toInt())");
        return new DurationBuilder(period);
    }

    @NotNull
    public static final Period days(long $receiver) {
        Period period = Period.days((int)((int)$receiver));
        Intrinsics.checkExpressionValueIsNotNull((Object)period, (String)"Period.days(this.toInt())");
        return period;
    }

    @NotNull
    public static final Period weeks(long $receiver) {
        Period period = Period.weeks((int)((int)$receiver));
        Intrinsics.checkExpressionValueIsNotNull((Object)period, (String)"Period.weeks(this.toInt())");
        return period;
    }

    @NotNull
    public static final Period months(long $receiver) {
        Period period = Period.months((int)((int)$receiver));
        Intrinsics.checkExpressionValueIsNotNull((Object)period, (String)"Period.months(this.toInt())");
        return period;
    }

    @NotNull
    public static final Period years(long $receiver) {
        Period period = Period.years((int)((int)$receiver));
        Intrinsics.checkExpressionValueIsNotNull((Object)period, (String)"Period.years(this.toInt())");
        return period;
    }

    @NotNull
    public static final DurationBuilder times(long $receiver, @NotNull DurationBuilder builder) {
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        Period period = builder.getPeriod().multipliedBy((int)$receiver);
        Intrinsics.checkExpressionValueIsNotNull((Object)period, (String)"builder.period.multipliedBy(this.toInt())");
        return new DurationBuilder(period);
    }

    @NotNull
    public static final Period times(long $receiver, @NotNull Period period) {
        Intrinsics.checkParameterIsNotNull((Object)period, (String)"period");
        Period period2 = period.multipliedBy((int)$receiver);
        Intrinsics.checkExpressionValueIsNotNull((Object)period2, (String)"period.multipliedBy(this.toInt())");
        return period2;
    }

    public static final DateTimeFormatter dateTimeFormat(@NotNull String pattern) {
        Intrinsics.checkParameterIsNotNull((Object)pattern, (String)"pattern");
        return DateTimeFormat.forPattern((String)pattern);
    }

    @Nullable
    public static final DateTime toDateTime(@NotNull String $receiver, @Nullable String pattern) {
        CharSequence charSequence;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        try {
            DateTime dateTime;
            charSequence = pattern;
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                dateTime = new DateTime((Object)$receiver);
            } else {
                String string = pattern;
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                dateTime = DateTime.parse((String)$receiver, (DateTimeFormatter)KodaTimeExtensions.dateTimeFormat(string));
            }
            charSequence = dateTime;
        }
        catch (Throwable ignored) {
            charSequence = null;
        }
        return charSequence;
    }

    @Nullable
    public static /* bridge */ /* synthetic */ DateTime toDateTime$default(String string, String string2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: toDateTime");
        }
        if ((n & 1) != 0) {
            string2 = null;
        }
        return KodaTimeExtensions.toDateTime(string, string2);
    }

    @Nullable
    public static final Interval toInterval(@NotNull String $receiver) {
        Interval interval;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        try {
            interval = Interval.parse((String)$receiver);
        }
        catch (Throwable ignored) {
            interval = null;
        }
        return interval;
    }

    @Nullable
    public static final LocalDate toLocalDate(@NotNull String $receiver, @Nullable String pattern) {
        CharSequence charSequence;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        try {
            LocalDate localDate;
            charSequence = pattern;
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                localDate = new LocalDate((Object)$receiver);
            } else {
                String string = pattern;
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                localDate = LocalDate.parse((String)$receiver, (DateTimeFormatter)KodaTimeExtensions.dateTimeFormat(string));
            }
            charSequence = localDate;
        }
        catch (Throwable ignored) {
            charSequence = null;
        }
        return charSequence;
    }

    @Nullable
    public static /* bridge */ /* synthetic */ LocalDate toLocalDate$default(String string, String string2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: toLocalDate");
        }
        if ((n & 1) != 0) {
            string2 = null;
        }
        return KodaTimeExtensions.toLocalDate(string, string2);
    }

    @Nullable
    public static final LocalTime toLocalTime(@NotNull String $receiver, @Nullable String pattern) {
        CharSequence charSequence;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        try {
            LocalTime localTime;
            charSequence = pattern;
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                localTime = new LocalTime((Object)$receiver);
            } else {
                String string = pattern;
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                localTime = LocalTime.parse((String)$receiver, (DateTimeFormatter)KodaTimeExtensions.dateTimeFormat(string));
            }
            charSequence = localTime;
        }
        catch (Throwable ignored) {
            charSequence = null;
        }
        return charSequence;
    }

    @Nullable
    public static /* bridge */ /* synthetic */ LocalTime toLocalTime$default(String string, String string2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: toLocalTime");
        }
        if ((n & 1) != 0) {
            string2 = null;
        }
        return KodaTimeExtensions.toLocalTime(string, string2);
    }

    @NotNull
    public static final DateTime dateTimeFromJson(@NotNull String json) {
        Intrinsics.checkParameterIsNotNull((Object)json, (String)"json");
        return new DateTime((Object)json);
    }

    @JvmOverloads
    @NotNull
    public static final DateTime dateTimeOf(int year, int month, int day, int hours2, int minutes2, int seconds2, int millis) {
        return new DateTime(year, month, day, hours2, minutes2, seconds2, millis);
    }

    @JvmOverloads
    @NotNull
    public static /* bridge */ /* synthetic */ DateTime dateTimeOf$default(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: dateTimeOf");
        }
        if ((n8 & 2) != 0) {
            n2 = 1;
        }
        if ((n8 & 4) != 0) {
            n3 = 1;
        }
        if ((n8 & 8) != 0) {
            n4 = 0;
        }
        if ((n8 & 0x10) != 0) {
            n5 = 0;
        }
        if ((n8 & 0x20) != 0) {
            n6 = 0;
        }
        if ((n8 & 0x40) != 0) {
            n7 = 0;
        }
        return KodaTimeExtensions.dateTimeOf(n, n2, n3, n4, n5, n6, n7);
    }

    @JvmOverloads
    @NotNull
    public static DateTime dateTimeOf(int year, int month, int day, int hours2, int minutes2, int seconds2) {
        return KodaTimeExtensions.dateTimeOf$default(year, month, day, hours2, minutes2, seconds2, 0, 64, null);
    }

    @JvmOverloads
    @NotNull
    public static DateTime dateTimeOf(int year, int month, int day, int hours2, int minutes2) {
        return KodaTimeExtensions.dateTimeOf$default(year, month, day, hours2, minutes2, 0, 0, 96, null);
    }

    @JvmOverloads
    @NotNull
    public static DateTime dateTimeOf(int year, int month, int day, int hours2) {
        return KodaTimeExtensions.dateTimeOf$default(year, month, day, hours2, 0, 0, 0, 112, null);
    }

    @JvmOverloads
    @NotNull
    public static DateTime dateTimeOf(int year, int month, int day) {
        return KodaTimeExtensions.dateTimeOf$default(year, month, day, 0, 0, 0, 0, 120, null);
    }

    @JvmOverloads
    @NotNull
    public static DateTime dateTimeOf(int year, int month) {
        return KodaTimeExtensions.dateTimeOf$default(year, month, 0, 0, 0, 0, 0, 124, null);
    }

    @JvmOverloads
    @NotNull
    public static DateTime dateTimeOf(int year) {
        return KodaTimeExtensions.dateTimeOf$default(year, 0, 0, 0, 0, 0, 0, 126, null);
    }

    @NotNull
    public static final DateTime startOfDay(@NotNull DateTime $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        DateTime dateTime = $receiver.withTimeAtStartOfDay();
        Intrinsics.checkExpressionValueIsNotNull((Object)dateTime, (String)"this.withTimeAtStartOfDay()");
        return dateTime;
    }

    @NotNull
    public static final DateTime startOfWeek(@NotNull DateTime $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return KodaTimeExtensions.startOfDay($receiver.minusDays($receiver.getDayOfWeek() - 1));
    }

    @NotNull
    public static final DateTime startOfMonth(@NotNull DateTime $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return KodaTimeExtensions.dateTimeOf$default($receiver.getYear(), $receiver.getMonthOfYear(), 0, 0, 0, 0, 0, 124, null);
    }

    @NotNull
    public static final DateTime startOfYear(@NotNull DateTime $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return KodaTimeExtensions.dateTimeOf$default($receiver.getYear(), 0, 0, 0, 0, 0, 0, 126, null);
    }

    @NotNull
    public static final DateTime minus(@NotNull DateTime $receiver, @NotNull DurationBuilder builder) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        DateTime dateTime = $receiver.minus((ReadablePeriod)builder.getPeriod());
        Intrinsics.checkExpressionValueIsNotNull((Object)dateTime, (String)"this.minus(builder.period)");
        return dateTime;
    }

    @NotNull
    public static final DateTime plus(@NotNull DateTime $receiver, @NotNull DurationBuilder builder) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        DateTime dateTime = $receiver.plus((ReadablePeriod)builder.getPeriod());
        Intrinsics.checkExpressionValueIsNotNull((Object)dateTime, (String)"this.plus(builder.period)");
        return dateTime;
    }

    @NotNull
    public static final DateTime tomorrow(@NotNull DateTime $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return KodaTimeExtensions.nextDay($receiver);
    }

    @NotNull
    public static final DateTime yesterday(@NotNull DateTime $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return KodaTimeExtensions.lastDay($receiver);
    }

    @NotNull
    public static final DateTime nextSecond(@NotNull DateTime $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        DateTime dateTime = $receiver.plusSeconds(1);
        Intrinsics.checkExpressionValueIsNotNull((Object)dateTime, (String)"this.plusSeconds(1)");
        return dateTime;
    }

    @NotNull
    public static final DateTime nextMinute(@NotNull DateTime $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        DateTime dateTime = $receiver.plusMinutes(1);
        Intrinsics.checkExpressionValueIsNotNull((Object)dateTime, (String)"this.plusMinutes(1)");
        return dateTime;
    }

    @NotNull
    public static final DateTime nextHour(@NotNull DateTime $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        DateTime dateTime = $receiver.plusHours(1);
        Intrinsics.checkExpressionValueIsNotNull((Object)dateTime, (String)"this.plusHours(1)");
        return dateTime;
    }

    @NotNull
    public static final DateTime nextDay(@NotNull DateTime $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        DateTime dateTime = $receiver.plusDays(1);
        Intrinsics.checkExpressionValueIsNotNull((Object)dateTime, (String)"this.plusDays(1)");
        return dateTime;
    }

    @NotNull
    public static final DateTime nextWeek(@NotNull DateTime $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        DateTime dateTime = $receiver.plusWeeks(1);
        Intrinsics.checkExpressionValueIsNotNull((Object)dateTime, (String)"this.plusWeeks(1)");
        return dateTime;
    }

    @NotNull
    public static final DateTime nextMonth(@NotNull DateTime $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        DateTime dateTime = $receiver.plusMonths(1);
        Intrinsics.checkExpressionValueIsNotNull((Object)dateTime, (String)"this.plusMonths(1)");
        return dateTime;
    }

    @NotNull
    public static final DateTime nextYear(@NotNull DateTime $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        DateTime dateTime = $receiver.plusYears(1);
        Intrinsics.checkExpressionValueIsNotNull((Object)dateTime, (String)"this.plusYears(1)");
        return dateTime;
    }

    @NotNull
    public static final DateTime lastSecond(@NotNull DateTime $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        DateTime dateTime = $receiver.minusSeconds(1);
        Intrinsics.checkExpressionValueIsNotNull((Object)dateTime, (String)"this.minusSeconds(1)");
        return dateTime;
    }

    @NotNull
    public static final DateTime lastMinute(@NotNull DateTime $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        DateTime dateTime = $receiver.minusMinutes(1);
        Intrinsics.checkExpressionValueIsNotNull((Object)dateTime, (String)"this.minusMinutes(1)");
        return dateTime;
    }

    @NotNull
    public static final DateTime lastHour(@NotNull DateTime $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        DateTime dateTime = $receiver.minusHours(1);
        Intrinsics.checkExpressionValueIsNotNull((Object)dateTime, (String)"this.minusHours(1)");
        return dateTime;
    }

    @NotNull
    public static final DateTime lastDay(@NotNull DateTime $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        DateTime dateTime = $receiver.minusDays(1);
        Intrinsics.checkExpressionValueIsNotNull((Object)dateTime, (String)"this.minusDays(1)");
        return dateTime;
    }

    @NotNull
    public static final DateTime lastWeek(@NotNull DateTime $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        DateTime dateTime = $receiver.minusWeeks(1);
        Intrinsics.checkExpressionValueIsNotNull((Object)dateTime, (String)"this.minusWeeks(1)");
        return dateTime;
    }

    @NotNull
    public static final DateTime lastMonth(@NotNull DateTime $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        DateTime dateTime = $receiver.minusMonths(1);
        Intrinsics.checkExpressionValueIsNotNull((Object)dateTime, (String)"this.minusMonths(1)");
        return dateTime;
    }

    @NotNull
    public static final DateTime lastYear(@NotNull DateTime $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        DateTime dateTime = $receiver.minusYears(1);
        Intrinsics.checkExpressionValueIsNotNull((Object)dateTime, (String)"this.minusYears(1)");
        return dateTime;
    }

    @NotNull
    public static final Timestamp toTimestamp(@NotNull DateTime $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return new Timestamp($receiver.getMillis());
    }

    @NotNull
    public static final DateTime asUtc(@NotNull DateTime $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        DateTime dateTime = $receiver.toDateTime(DateTimeZone.UTC);
        Intrinsics.checkExpressionValueIsNotNull((Object)dateTime, (String)"this.toDateTime(DateTimeZone.UTC)");
        return dateTime;
    }

    @JvmOverloads
    @NotNull
    public static final DateTime asLocal(@NotNull DateTime $receiver, @NotNull DateTimeZone tz) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)tz, (String)"tz");
        DateTime dateTime = $receiver.toDateTime(tz);
        Intrinsics.checkExpressionValueIsNotNull((Object)dateTime, (String)"this.toDateTime(tz)");
        return dateTime;
    }

    @JvmOverloads
    @NotNull
    public static /* bridge */ /* synthetic */ DateTime asLocal$default(DateTime dateTime, DateTimeZone dateTimeZone, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: asLocal");
        }
        if ((n & 1) != 0) {
            DateTimeZone dateTimeZone2 = DateTimeZone.getDefault();
            Intrinsics.checkExpressionValueIsNotNull((Object)dateTimeZone2, (String)"DateTimeZone.getDefault()");
            dateTimeZone = dateTimeZone2;
        }
        return KodaTimeExtensions.asLocal(dateTime, dateTimeZone);
    }

    @JvmOverloads
    @NotNull
    public static DateTime asLocal(DateTime $receiver) {
        return KodaTimeExtensions.asLocal$default($receiver, null, 1, null);
    }

    @NotNull
    public static final String toIsoFormatString(@NotNull DateTime $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        String string = ISODateTimeFormat.dateTime().print((ReadableInstant)$receiver);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ISODateTimeFormat.dateTime().print(this)");
        return string;
    }

    @NotNull
    public static final String toIsoFormatDateString(@NotNull DateTime $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        String string = ISODateTimeFormat.date().print((ReadableInstant)$receiver);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ISODateTimeFormat.date().print(this)");
        return string;
    }

    @NotNull
    public static final String toIsoFormatTimeString(@NotNull DateTime $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        String string = ISODateTimeFormat.time().print((ReadableInstant)$receiver);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ISODateTimeFormat.time().print(this)");
        return string;
    }

    @NotNull
    public static final String toIsoFormatTimeNoMillisString(@NotNull DateTime $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        String string = ISODateTimeFormat.timeNoMillis().print((ReadableInstant)$receiver);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ISODateTimeFormat.timeNoMillis().print(this)");
        return string;
    }

    @NotNull
    public static final String toIsoFormatHMSString(@NotNull DateTime $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        String string = ISODateTimeFormat.dateHourMinuteSecond().print((ReadableInstant)$receiver);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ISODateTimeFormat.dateHo\u2026inuteSecond().print(this)");
        return string;
    }

    @NotNull
    public static final TimestampZoneText toTimestampZoneText(@NotNull DateTime $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return new TimestampZoneText($receiver);
    }

    @NotNull
    public static final DateTime min(@NotNull DateTime $receiver, @NotNull DateTime that) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)that, (String)"that");
        return $receiver.compareTo((ReadableInstant)that) < 0 ? $receiver : that;
    }

    @NotNull
    public static final DateTime max(@NotNull DateTime $receiver, @NotNull DateTime that) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)that, (String)"that");
        return $receiver.compareTo((ReadableInstant)that) > 0 ? $receiver : that;
    }

    @NotNull
    public static final Interval monthInterval(@NotNull DateTime $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        DateTime start = $receiver.withDayOfMonth(1).withTimeAtStartOfDay();
        return new Interval((ReadableInstant)start, (ReadableInstant)start.plus((ReadablePeriod)KodaTimeExtensions.months(1)));
    }

    @NotNull
    public static final Interval dayInterval(@NotNull DateTime $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        DateTime start = KodaTimeExtensions.startOfDay($receiver);
        return new Interval((ReadableInstant)start, (ReadableInstant)start.plus((ReadablePeriod)KodaTimeExtensions.days(1)));
    }

    @NotNull
    public static final DateTime now() {
        DateTime dateTime = DateTime.now();
        Intrinsics.checkExpressionValueIsNotNull((Object)dateTime, (String)"DateTime.now()");
        return dateTime;
    }

    @NotNull
    public static final DateTime tomorrow() {
        return KodaTimeExtensions.tomorrow(KodaTimeExtensions.now());
    }

    @NotNull
    public static final DateTime yesterday() {
        return KodaTimeExtensions.yesterday(KodaTimeExtensions.now());
    }

    @NotNull
    public static final DateTime nextSecond() {
        DateTime dateTime = KodaTimeExtensions.now().plusSeconds(1);
        Intrinsics.checkExpressionValueIsNotNull((Object)dateTime, (String)"now().plusSeconds(1)");
        return dateTime;
    }

    @NotNull
    public static final DateTime nextMinute() {
        DateTime dateTime = KodaTimeExtensions.now().plusMinutes(1);
        Intrinsics.checkExpressionValueIsNotNull((Object)dateTime, (String)"now().plusMinutes(1)");
        return dateTime;
    }

    @NotNull
    public static final DateTime nextHour() {
        DateTime dateTime = KodaTimeExtensions.now().plusHours(1);
        Intrinsics.checkExpressionValueIsNotNull((Object)dateTime, (String)"now().plusHours(1)");
        return dateTime;
    }

    @NotNull
    public static final DateTime nextDay() {
        DateTime dateTime = KodaTimeExtensions.now().plusDays(1);
        Intrinsics.checkExpressionValueIsNotNull((Object)dateTime, (String)"now().plusDays(1)");
        return dateTime;
    }

    @NotNull
    public static final DateTime nextWeek() {
        DateTime dateTime = KodaTimeExtensions.now().plusWeeks(1);
        Intrinsics.checkExpressionValueIsNotNull((Object)dateTime, (String)"now().plusWeeks(1)");
        return dateTime;
    }

    @NotNull
    public static final DateTime nextMonth() {
        DateTime dateTime = KodaTimeExtensions.now().plusMonths(1);
        Intrinsics.checkExpressionValueIsNotNull((Object)dateTime, (String)"now().plusMonths(1)");
        return dateTime;
    }

    @NotNull
    public static final DateTime nextYear() {
        DateTime dateTime = KodaTimeExtensions.now().plusYears(1);
        Intrinsics.checkExpressionValueIsNotNull((Object)dateTime, (String)"now().plusYears(1)");
        return dateTime;
    }

    @NotNull
    public static final DateTime lastSecond() {
        DateTime dateTime = KodaTimeExtensions.now().minusSeconds(1);
        Intrinsics.checkExpressionValueIsNotNull((Object)dateTime, (String)"now().minusSeconds(1)");
        return dateTime;
    }

    @NotNull
    public static final DateTime lastMinute() {
        DateTime dateTime = KodaTimeExtensions.now().minusMinutes(1);
        Intrinsics.checkExpressionValueIsNotNull((Object)dateTime, (String)"now().minusMinutes(1)");
        return dateTime;
    }

    @NotNull
    public static final DateTime lastHour() {
        DateTime dateTime = KodaTimeExtensions.now().minusHours(1);
        Intrinsics.checkExpressionValueIsNotNull((Object)dateTime, (String)"now().minusHours(1)");
        return dateTime;
    }

    @NotNull
    public static final DateTime lastDay() {
        DateTime dateTime = KodaTimeExtensions.now().minusDays(1);
        Intrinsics.checkExpressionValueIsNotNull((Object)dateTime, (String)"now().minusDays(1)");
        return dateTime;
    }

    @NotNull
    public static final DateTime lastWeek() {
        DateTime dateTime = KodaTimeExtensions.now().minusWeeks(1);
        Intrinsics.checkExpressionValueIsNotNull((Object)dateTime, (String)"now().minusWeeks(1)");
        return dateTime;
    }

    @NotNull
    public static final DateTime lastMonth() {
        DateTime dateTime = KodaTimeExtensions.now().minusMonths(1);
        Intrinsics.checkExpressionValueIsNotNull((Object)dateTime, (String)"now().minusMonths(1)");
        return dateTime;
    }

    @NotNull
    public static final DateTime lastYear() {
        DateTime dateTime = KodaTimeExtensions.now().minusYears(1);
        Intrinsics.checkExpressionValueIsNotNull((Object)dateTime, (String)"now().minusYears(1)");
        return dateTime;
    }

    @NotNull
    public static final LocalDateTime minus(@NotNull LocalDateTime $receiver, @NotNull DurationBuilder builder) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        LocalDateTime localDateTime = $receiver.minus((ReadablePeriod)builder.getPeriod());
        Intrinsics.checkExpressionValueIsNotNull((Object)localDateTime, (String)"this.minus(builder.period)");
        return localDateTime;
    }

    @NotNull
    public static final LocalDateTime plus(@NotNull LocalDateTime $receiver, @NotNull DurationBuilder builder) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        LocalDateTime localDateTime = $receiver.plus((ReadablePeriod)builder.getPeriod());
        Intrinsics.checkExpressionValueIsNotNull((Object)localDateTime, (String)"this.plus(builder.period)");
        return localDateTime;
    }

    @NotNull
    public static final LocalDate minus(@NotNull LocalDate $receiver, @NotNull DurationBuilder builder) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        LocalDate localDate = $receiver.minus((ReadablePeriod)builder.getPeriod());
        Intrinsics.checkExpressionValueIsNotNull((Object)localDate, (String)"this.minus(builder.period)");
        return localDate;
    }

    @NotNull
    public static final LocalDate plus(@NotNull LocalDate $receiver, @NotNull DurationBuilder builder) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        LocalDate localDate = $receiver.plus((ReadablePeriod)builder.getPeriod());
        Intrinsics.checkExpressionValueIsNotNull((Object)localDate, (String)"this.plus(builder.period)");
        return localDate;
    }

    @NotNull
    public static final LocalTime minus(@NotNull LocalTime $receiver, @NotNull DurationBuilder builder) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        LocalTime localTime = $receiver.minus((ReadablePeriod)builder.getPeriod());
        Intrinsics.checkExpressionValueIsNotNull((Object)localTime, (String)"this.minus(builder.period)");
        return localTime;
    }

    @NotNull
    public static final LocalTime plus(@NotNull LocalTime $receiver, @NotNull DurationBuilder builder) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        LocalTime localTime = $receiver.plus((ReadablePeriod)builder.getPeriod());
        Intrinsics.checkExpressionValueIsNotNull((Object)localTime, (String)"this.plus(builder.period)");
        return localTime;
    }

    @NotNull
    public static final Duration getEmptyDuration() {
        return emptyDuration;
    }

    @NotNull
    public static final Duration standardDays(long days2) {
        Duration duration = Duration.standardDays((long)days2);
        Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"Duration.standardDays(days)");
        return duration;
    }

    @NotNull
    public static final Duration standardHours(long hours2) {
        Duration duration = Duration.standardHours((long)hours2);
        Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"Duration.standardHours(hours)");
        return duration;
    }

    @NotNull
    public static final Duration standardMinutes(long minutes2) {
        Duration duration = Duration.standardMinutes((long)minutes2);
        Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"Duration.standardMinutes(minutes)");
        return duration;
    }

    @NotNull
    public static final Duration standardSeconds(long seconds2) {
        Duration duration = Duration.standardSeconds((long)seconds2);
        Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"Duration.standardSeconds(seconds)");
        return duration;
    }

    public static final long days(@NotNull Duration $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver.getStandardDays();
    }

    public static final long hours(@NotNull Duration $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver.getStandardHours();
    }

    public static final long minutes(@NotNull Duration $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver.getStandardMinutes();
    }

    public static final long seconds(@NotNull Duration $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver.getStandardSeconds();
    }

    @NotNull
    public static final Duration abs(@NotNull Duration $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver.compareTo((ReadableDuration)emptyDuration) < 0 ? KodaTimeExtensions.unaryMinus($receiver) : $receiver;
    }

    @NotNull
    public static final DateTime fromNow(@NotNull Duration $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        DateTime dateTime = KodaTimeExtensions.now().plus((ReadableDuration)$receiver);
        Intrinsics.checkExpressionValueIsNotNull((Object)dateTime, (String)"now() + this");
        return dateTime;
    }

    @NotNull
    public static final DateTime agoNow(@NotNull Duration $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        DateTime dateTime = KodaTimeExtensions.now().minus((ReadableDuration)$receiver);
        Intrinsics.checkExpressionValueIsNotNull((Object)dateTime, (String)"now() - this");
        return dateTime;
    }

    @NotNull
    public static final DateTime afterEpoch(@NotNull Duration $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        DateTime dateTime = EPOCH.plus((ReadableDuration)$receiver);
        Intrinsics.checkExpressionValueIsNotNull((Object)dateTime, (String)"EPOCH + this");
        return dateTime;
    }

    @NotNull
    public static final Duration diff(@NotNull Duration $receiver, @NotNull Duration other) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        Duration duration = $receiver.minus((ReadableDuration)other);
        Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"this - other");
        return duration;
    }

    @NotNull
    public static final Duration unaryMinus(@NotNull Duration $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Duration duration = $receiver.negated();
        Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"this.negated()");
        return duration;
    }

    @NotNull
    public static final Duration div(@NotNull Duration $receiver, long divisor) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Duration duration = $receiver.dividedBy(divisor);
        Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"this.dividedBy(divisor)");
        return duration;
    }

    @NotNull
    public static final Duration times(@NotNull Duration $receiver, long multiplicand) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Duration duration = $receiver.multipliedBy(multiplicand);
        Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"this.multipliedBy(multiplicand)");
        return duration;
    }

    public static final boolean isZero(@NotNull Duration $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver.getMillis() == 0L;
    }

    @NotNull
    public static final Duration min(@NotNull Duration $receiver, @NotNull Duration that) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)that, (String)"that");
        return $receiver.compareTo((ReadableDuration)that) < 0 ? $receiver : that;
    }

    @NotNull
    public static final Duration max(@NotNull Duration $receiver, @NotNull Duration that) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)that, (String)"that");
        return $receiver.compareTo((ReadableDuration)that) > 0 ? $receiver : that;
    }

    @NotNull
    public static final DateTime ago(@NotNull Period $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        DateTime dateTime = DateTime.now().minus((ReadablePeriod)$receiver);
        Intrinsics.checkExpressionValueIsNotNull((Object)dateTime, (String)"DateTime.now() - this");
        return dateTime;
    }

    @NotNull
    public static final DateTime later(@NotNull Period $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        DateTime dateTime = DateTime.now().plus((ReadablePeriod)$receiver);
        Intrinsics.checkExpressionValueIsNotNull((Object)dateTime, (String)"DateTime.now() + this");
        return dateTime;
    }

    @NotNull
    public static final DateTime from(@NotNull Period $receiver, @NotNull DateTime moment) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)moment, (String)"moment");
        DateTime dateTime = moment.plus((ReadablePeriod)$receiver);
        Intrinsics.checkExpressionValueIsNotNull((Object)dateTime, (String)"moment + this");
        return dateTime;
    }

    @NotNull
    public static final DateTime before(@NotNull Period $receiver, @NotNull DateTime moment) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)moment, (String)"moment");
        DateTime dateTime = moment.minus((ReadablePeriod)$receiver);
        Intrinsics.checkExpressionValueIsNotNull((Object)dateTime, (String)"moment - this");
        return dateTime;
    }

    @NotNull
    public static final Duration standardDuration(@NotNull Period $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Duration duration = $receiver.toStandardDuration();
        Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"this.toStandardDuration()");
        return duration;
    }

    @NotNull
    public static final Period periodOfYears(int y) {
        Period period = Period.years((int)y);
        Intrinsics.checkExpressionValueIsNotNull((Object)period, (String)"Period.years(y)");
        return period;
    }

    @NotNull
    public static final Period periodOfMonths(int m) {
        Period period = Period.months((int)m);
        Intrinsics.checkExpressionValueIsNotNull((Object)period, (String)"Period.months(m)");
        return period;
    }

    @NotNull
    public static final Period periodOfWeek(int w) {
        Period period = Period.weeks((int)w);
        Intrinsics.checkExpressionValueIsNotNull((Object)period, (String)"Period.weeks(w)");
        return period;
    }

    @NotNull
    public static final Period periodOfDay(int d) {
        Period period = Period.days((int)d);
        Intrinsics.checkExpressionValueIsNotNull((Object)period, (String)"Period.days(d)");
        return period;
    }

    @NotNull
    public static final Period periodOfHours(int h) {
        Period period = Period.hours((int)h);
        Intrinsics.checkExpressionValueIsNotNull((Object)period, (String)"Period.hours(h)");
        return period;
    }

    @NotNull
    public static final Period periodOfMinutes(int m) {
        Period period = Period.minutes((int)m);
        Intrinsics.checkExpressionValueIsNotNull((Object)period, (String)"Period.minutes(m)");
        return period;
    }

    @NotNull
    public static final Period periodOfSeconds(int s) {
        Period period = Period.seconds((int)s);
        Intrinsics.checkExpressionValueIsNotNull((Object)period, (String)"Period.seconds(s)");
        return period;
    }

    @NotNull
    public static final Period periodOfMillis(int m) {
        Period period = Period.millis((int)m);
        Intrinsics.checkExpressionValueIsNotNull((Object)period, (String)"Period.millis(m)");
        return period;
    }

    @NotNull
    public static final Instant minus(@NotNull Instant $receiver, @NotNull DurationBuilder builder) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        Instant instant = $receiver.minus((ReadableDuration)builder.getPeriod().toStandardDuration());
        Intrinsics.checkExpressionValueIsNotNull((Object)instant, (String)"this.minus(builder.period.toStandardDuration())");
        return instant;
    }

    @NotNull
    public static final Instant plus(@NotNull Instant $receiver, @NotNull DurationBuilder builder) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        Instant instant = $receiver.plus((ReadableDuration)builder.getPeriod().toStandardDuration());
        Intrinsics.checkExpressionValueIsNotNull((Object)instant, (String)"this.plus(builder.period.toStandardDuration())");
        return instant;
    }

    @NotNull
    public static final Interval thisSecond() {
        Interval interval = KodaTimeExtensions.now().secondOfMinute().toInterval();
        Intrinsics.checkExpressionValueIsNotNull((Object)interval, (String)"now().secondOfMinute().toInterval()");
        return interval;
    }

    @NotNull
    public static final Interval thisMinute() {
        Interval interval = KodaTimeExtensions.now().minuteOfHour().toInterval();
        Intrinsics.checkExpressionValueIsNotNull((Object)interval, (String)"now().minuteOfHour().toInterval()");
        return interval;
    }

    @NotNull
    public static final Interval thisHour() {
        Interval interval = KodaTimeExtensions.now().hourOfDay().toInterval();
        Intrinsics.checkExpressionValueIsNotNull((Object)interval, (String)"now().hourOfDay().toInterval()");
        return interval;
    }

    @NotNull
    public static final Interval rangeTo(@NotNull ReadableInstant $receiver, @NotNull ReadableInstant other) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return new Interval($receiver, other);
    }

    public static final long millis(@NotNull ReadableInterval $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver.toDurationMillis();
    }

    @NotNull
    public static final Sequence<DateTime> step(@NotNull ReadableInterval $receiver, @NotNull ReadablePeriod instance) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)instance, (String)"instance");
        return SequencesKt.takeWhile((Sequence)SequencesKt.generateSequence((Object)$receiver.getStart().plus(instance), (Function1)((Function1)new Function1<DateTime, DateTime>(instance){
            final /* synthetic */ ReadablePeriod $instance;

            public final DateTime invoke(@NotNull DateTime it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return it.plus(this.$instance);
            }
            {
                this.$instance = readablePeriod;
                super(1);
            }
        })), (Function1)((Function1)new Function1<DateTime, Boolean>($receiver){
            final /* synthetic */ ReadableInterval receiver$0;

            public final boolean invoke(@NotNull DateTime it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return it.compareTo((ReadableInstant)this.receiver$0.getEnd()) <= 0;
            }
            {
                this.receiver$0 = readableInterval;
                super(1);
            }
        }));
    }

    @NotNull
    public static final Sequence<DateTime> seconds(@NotNull ReadableInterval $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return SequencesKt.takeWhile((Sequence)SequencesKt.generateSequence((Object)$receiver.getStart(), (Function1)seconds.1.INSTANCE), (Function1)((Function1)new Function1<DateTime, Boolean>($receiver){
            final /* synthetic */ ReadableInterval receiver$0;

            public final boolean invoke(@NotNull DateTime it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return it.compareTo((ReadableInstant)this.receiver$0.getEnd()) <= 0;
            }
            {
                this.receiver$0 = readableInterval;
                super(1);
            }
        }));
    }

    @NotNull
    public static final Sequence<DateTime> minutes(@NotNull ReadableInterval $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return SequencesKt.takeWhile((Sequence)SequencesKt.generateSequence((Object)$receiver.getStart(), (Function1)minutes.1.INSTANCE), (Function1)((Function1)new Function1<DateTime, Boolean>($receiver){
            final /* synthetic */ ReadableInterval receiver$0;

            public final boolean invoke(@NotNull DateTime it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return it.compareTo((ReadableInstant)this.receiver$0.getEnd()) <= 0;
            }
            {
                this.receiver$0 = readableInterval;
                super(1);
            }
        }));
    }

    @NotNull
    public static final Sequence<DateTime> hours(@NotNull ReadableInterval $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return SequencesKt.takeWhile((Sequence)SequencesKt.generateSequence((Object)$receiver.getStart(), (Function1)hours.1.INSTANCE), (Function1)((Function1)new Function1<DateTime, Boolean>($receiver){
            final /* synthetic */ ReadableInterval receiver$0;

            public final boolean invoke(@NotNull DateTime it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return it.compareTo((ReadableInstant)this.receiver$0.getEnd()) <= 0;
            }
            {
                this.receiver$0 = readableInterval;
                super(1);
            }
        }));
    }

    @NotNull
    public static final Sequence<DateTime> days(@NotNull ReadableInterval $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return SequencesKt.takeWhile((Sequence)SequencesKt.generateSequence((Object)KodaTimeExtensions.startOfDay($receiver.getStart()), (Function1)days.1.INSTANCE), (Function1)((Function1)new Function1<DateTime, Boolean>($receiver){
            final /* synthetic */ ReadableInterval receiver$0;

            public final boolean invoke(@NotNull DateTime it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return it.compareTo((ReadableInstant)this.receiver$0.getEnd()) <= 0;
            }
            {
                this.receiver$0 = readableInterval;
                super(1);
            }
        }));
    }

    @NotNull
    public static final Sequence<DateTime> weeks(@NotNull ReadableInterval $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return SequencesKt.takeWhile((Sequence)SequencesKt.generateSequence((Object)KodaTimeExtensions.startOfWeek($receiver.getStart()), (Function1)weeks.1.INSTANCE), (Function1)((Function1)new Function1<DateTime, Boolean>($receiver){
            final /* synthetic */ ReadableInterval receiver$0;

            public final boolean invoke(@NotNull DateTime it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return it.compareTo((ReadableInstant)this.receiver$0.getEnd()) <= 0;
            }
            {
                this.receiver$0 = readableInterval;
                super(1);
            }
        }));
    }

    @NotNull
    public static final Sequence<DateTime> months(@NotNull ReadableInterval $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return SequencesKt.takeWhile((Sequence)SequencesKt.generateSequence((Object)KodaTimeExtensions.startOfMonth($receiver.getStart()), (Function1)months.1.INSTANCE), (Function1)((Function1)new Function1<DateTime, Boolean>($receiver){
            final /* synthetic */ ReadableInterval receiver$0;

            public final boolean invoke(@NotNull DateTime it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return it.compareTo((ReadableInstant)this.receiver$0.getEnd()) <= 0;
            }
            {
                this.receiver$0 = readableInterval;
                super(1);
            }
        }));
    }

    static {
        Duration duration = Duration.ZERO;
        Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"Duration.ZERO");
        emptyDuration = duration;
    }
}

