/*
 * Decompiled with CFR 0.152.
 */
package com.github.debop.kodatimes;

import com.github.debop.kodatimes.KodaTimeExtensions;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.Period;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadablePeriod;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001aJ\u0011\u0010\u001d\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u0006H\u0086\u0002J\u000e\u0010\u001f\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001aJ\u0006\u0010 \u001a\u00020\u001aJ\u0011\u0010!\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010!\u001a\u00020\n2\u0006\u0010#\u001a\u00020\u0006H\u0086\u0002J\u0011\u0010!\u001a\u00020\n2\u0006\u0010#\u001a\u00020$H\u0086\u0002J\u0011\u0010!\u001a\u00020\u00032\u0006\u0010%\u001a\u00020&H\u0086\u0002J\u0011\u0010'\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010'\u001a\u00020\n2\u0006\u0010#\u001a\u00020\u0006H\u0086\u0002J\u0011\u0010'\u001a\u00020\n2\u0006\u0010#\u001a\u00020$H\u0086\u0002J\u0011\u0010'\u001a\u00020\u00032\u0006\u0010%\u001a\u00020&H\u0086\u0002J\u0011\u0010(\u001a\u00020\n2\u0006\u0010)\u001a\u00020\u0006H\u0086\u0002J\u0006\u0010*\u001a\u00020\u0003J\t\u0010+\u001a\u00020\nH\u0086\u0002R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\bR\u0011\u0010\u000f\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\bR\u0011\u0010\u0011\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\bR\u0011\u0010\u0017\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\f\u00a8\u0006,"}, d2={"Lcom/github/debop/kodatimes/DurationBuilder;", "", "period", "Lorg/joda/time/Period;", "(Lorg/joda/time/Period;)V", "days", "", "getDays", "()J", "duration", "Lorg/joda/time/Duration;", "getDuration", "()Lorg/joda/time/Duration;", "hours", "getHours", "millis", "getMillis", "minutes", "getMinutes", "getPeriod", "()Lorg/joda/time/Period;", "seconds", "getSeconds", "standardDuration", "getStandardDuration", "ago", "Lorg/joda/time/DateTime;", "before", "moment", "div", "divisor", "from", "later", "minus", "that", "amount", "Lorg/joda/time/ReadableDuration;", "rp", "Lorg/joda/time/ReadablePeriod;", "plus", "times", "multiplicand", "toPeriod", "unaryMinus", "koda-time-compileKotlin"})
public final class DurationBuilder {
    @NotNull
    private final Period period;

    @NotNull
    public final DurationBuilder minus(@NotNull DurationBuilder that) {
        Intrinsics.checkParameterIsNotNull((Object)that, (String)"that");
        Period period = this.period.minus((ReadablePeriod)that.period);
        Intrinsics.checkExpressionValueIsNotNull((Object)period, (String)"this.period.minus(that.period)");
        return new DurationBuilder(period);
    }

    @NotNull
    public final Period minus(@NotNull ReadablePeriod rp) {
        Intrinsics.checkParameterIsNotNull((Object)rp, (String)"rp");
        Period period = this.period.minus(rp);
        Intrinsics.checkExpressionValueIsNotNull((Object)period, (String)"period.minus(rp)");
        return period;
    }

    @NotNull
    public final Duration minus(long amount) {
        Duration duration = this.getStandardDuration().minus(amount);
        Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"standardDuration.minus(amount)");
        return duration;
    }

    @NotNull
    public final Duration minus(@NotNull ReadableDuration amount) {
        Intrinsics.checkParameterIsNotNull((Object)amount, (String)"amount");
        Duration duration = this.getStandardDuration().minus(amount);
        Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"standardDuration.minus(amount)");
        return duration;
    }

    @NotNull
    public final DurationBuilder plus(@NotNull DurationBuilder that) {
        Intrinsics.checkParameterIsNotNull((Object)that, (String)"that");
        Period period = this.period.plus((ReadablePeriod)that.period);
        Intrinsics.checkExpressionValueIsNotNull((Object)period, (String)"this.period.plus(that.period)");
        return new DurationBuilder(period);
    }

    @NotNull
    public final Period plus(@NotNull ReadablePeriod rp) {
        Intrinsics.checkParameterIsNotNull((Object)rp, (String)"rp");
        Period period = this.period.plus(rp);
        Intrinsics.checkExpressionValueIsNotNull((Object)period, (String)"period.plus(rp)");
        return period;
    }

    @NotNull
    public final Duration plus(long amount) {
        Duration duration = this.getStandardDuration().plus(amount);
        Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"standardDuration.plus(amount)");
        return duration;
    }

    @NotNull
    public final Duration plus(@NotNull ReadableDuration amount) {
        Intrinsics.checkParameterIsNotNull((Object)amount, (String)"amount");
        Duration duration = this.getStandardDuration().plus(amount);
        Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"standardDuration.plus(amount)");
        return duration;
    }

    @NotNull
    public final Duration times(long multiplicand) {
        return KodaTimeExtensions.times(this.getStandardDuration(), multiplicand);
    }

    @NotNull
    public final Duration div(long divisor) {
        return KodaTimeExtensions.div(this.getStandardDuration(), divisor);
    }

    @NotNull
    public final Duration unaryMinus() {
        Duration duration = this.getStandardDuration().negated();
        Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"standardDuration.negated()");
        return duration;
    }

    @NotNull
    public final DateTime ago() {
        DateTime dateTime = DateTime.now().minus((ReadablePeriod)this.period);
        Intrinsics.checkExpressionValueIsNotNull((Object)dateTime, (String)"DateTime.now().minus(period)");
        return dateTime;
    }

    @NotNull
    public final DateTime later() {
        DateTime dateTime = DateTime.now().plus((ReadablePeriod)this.period);
        Intrinsics.checkExpressionValueIsNotNull((Object)dateTime, (String)"DateTime.now().plus(period)");
        return dateTime;
    }

    @NotNull
    public final DateTime from(@NotNull DateTime moment) {
        Intrinsics.checkParameterIsNotNull((Object)moment, (String)"moment");
        DateTime dateTime = moment.plus((ReadablePeriod)this.period);
        Intrinsics.checkExpressionValueIsNotNull((Object)dateTime, (String)"moment.plus(period)");
        return dateTime;
    }

    @NotNull
    public final DateTime before(@NotNull DateTime moment) {
        Intrinsics.checkParameterIsNotNull((Object)moment, (String)"moment");
        DateTime dateTime = moment.minus((ReadablePeriod)this.period);
        Intrinsics.checkExpressionValueIsNotNull((Object)dateTime, (String)"moment.minus(period)");
        return dateTime;
    }

    @NotNull
    public final Duration getStandardDuration() {
        Duration duration = this.period.toStandardDuration();
        Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"period.toStandardDuration()");
        return duration;
    }

    @NotNull
    public final Duration getDuration() {
        Duration duration = this.period.toStandardDuration();
        Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"period.toStandardDuration()");
        return duration;
    }

    @NotNull
    public final Period toPeriod() {
        return this.period;
    }

    public final long getMillis() {
        return this.getStandardDuration().getMillis();
    }

    public final long getSeconds() {
        return this.getStandardDuration().getStandardSeconds();
    }

    public final long getMinutes() {
        return this.getStandardDuration().getStandardMinutes();
    }

    public final long getHours() {
        return this.getStandardDuration().getStandardHours();
    }

    public final long getDays() {
        return this.getStandardDuration().getStandardDays();
    }

    @NotNull
    public final Period getPeriod() {
        return this.period;
    }

    public DurationBuilder(@NotNull Period period) {
        Intrinsics.checkParameterIsNotNull((Object)period, (String)"period");
        this.period = period;
    }
}

