/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.redis.hibernate52.strategy;

import org.hibernate.cache.redis.hibernate52.regions.RedisCollectionRegion;
import org.hibernate.cache.redis.hibernate52.regions.RedisEntityRegion;
import org.hibernate.cache.redis.hibernate52.regions.RedisNaturalIdRegion;
import org.hibernate.cache.redis.hibernate52.strategy.NonStrictReadWriteRedisCollectionRegionAccessStrategy;
import org.hibernate.cache.redis.hibernate52.strategy.NonStrictReadWriteRedisEntityRegionAccessStrategy;
import org.hibernate.cache.redis.hibernate52.strategy.NonStrictReadWriteRedisNaturalIdRegionAccessStrategy;
import org.hibernate.cache.redis.hibernate52.strategy.ReadOnlyRedisCollectionRegionAccessStrategy;
import org.hibernate.cache.redis.hibernate52.strategy.ReadOnlyRedisEntityRegionAccessStrategy;
import org.hibernate.cache.redis.hibernate52.strategy.ReadOnlyRedisNaturalIdRegionAccessStrategy;
import org.hibernate.cache.redis.hibernate52.strategy.ReadWriteRedisCollectionRegionAccessStrategy;
import org.hibernate.cache.redis.hibernate52.strategy.ReadWriteRedisEntityRegionAccessStrategy;
import org.hibernate.cache.redis.hibernate52.strategy.ReadWriteRedisNaturalIdRegionAccessStrategy;
import org.hibernate.cache.redis.hibernate52.strategy.RedisAccessStrategyFactory;
import org.hibernate.cache.redis.hibernate52.strategy.TransactionalRedisCollectionRegionAccessStrategy;
import org.hibernate.cache.redis.hibernate52.strategy.TransactionalRedisEntityRegionAccessStrategy;
import org.hibernate.cache.redis.hibernate52.strategy.TransactionalRedisNaturalIdRegionAccessStrategy;
import org.hibernate.cache.spi.access.AccessType;
import org.hibernate.cache.spi.access.CollectionRegionAccessStrategy;
import org.hibernate.cache.spi.access.EntityRegionAccessStrategy;
import org.hibernate.cache.spi.access.NaturalIdRegionAccessStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisAccessStrategyFactoryImpl
implements RedisAccessStrategyFactory {
    private static final Logger log = LoggerFactory.getLogger(RedisAccessStrategyFactoryImpl.class);

    @Override
    public EntityRegionAccessStrategy createEntityRegionAccessStrategy(RedisEntityRegion entityRegion, AccessType accessType) {
        switch (accessType) {
            case READ_ONLY: {
                if (entityRegion.getCacheDataDescription().isMutable()) {
                    log.warn("read-only cache configured for mutable entity regionName=[{}]", (Object)entityRegion.getName());
                }
                return new ReadOnlyRedisEntityRegionAccessStrategy(entityRegion, entityRegion.getOptions());
            }
            case READ_WRITE: {
                return new ReadWriteRedisEntityRegionAccessStrategy(entityRegion, entityRegion.getOptions());
            }
            case NONSTRICT_READ_WRITE: {
                return new NonStrictReadWriteRedisEntityRegionAccessStrategy(entityRegion, entityRegion.getOptions());
            }
            case TRANSACTIONAL: {
                return new TransactionalRedisEntityRegionAccessStrategy(entityRegion, entityRegion.getOptions());
            }
        }
        throw new IllegalArgumentException("unrecognized access strategy type [" + accessType + "]");
    }

    @Override
    public CollectionRegionAccessStrategy createCollectionRegionAccessStrategy(RedisCollectionRegion collectionRegion, AccessType accessType) {
        switch (accessType) {
            case READ_ONLY: {
                if (collectionRegion.getCacheDataDescription().isMutable()) {
                    log.warn("read-only cache configured for mutable entity collectionRegionName=[{}]", (Object)collectionRegion.getName());
                }
                return new ReadOnlyRedisCollectionRegionAccessStrategy(collectionRegion, collectionRegion.getOptions());
            }
            case READ_WRITE: {
                return new ReadWriteRedisCollectionRegionAccessStrategy(collectionRegion, collectionRegion.getOptions());
            }
            case NONSTRICT_READ_WRITE: {
                return new NonStrictReadWriteRedisCollectionRegionAccessStrategy(collectionRegion, collectionRegion.getOptions());
            }
            case TRANSACTIONAL: {
                return new TransactionalRedisCollectionRegionAccessStrategy(collectionRegion, collectionRegion.getOptions());
            }
        }
        throw new IllegalArgumentException("unrecognized access strategy type [" + accessType + "]");
    }

    @Override
    public NaturalIdRegionAccessStrategy createNaturalIdRegionAccessStrategy(RedisNaturalIdRegion naturalIdRegion, AccessType accessType) {
        switch (accessType) {
            case READ_ONLY: {
                if (naturalIdRegion.getCacheDataDescription().isMutable()) {
                    log.warn("read-only cache configured for mutable entity naturalIdRegion=[{}]", (Object)naturalIdRegion.getName());
                }
                return new ReadOnlyRedisNaturalIdRegionAccessStrategy(naturalIdRegion, naturalIdRegion.getOptions());
            }
            case READ_WRITE: {
                return new ReadWriteRedisNaturalIdRegionAccessStrategy(naturalIdRegion, naturalIdRegion.getOptions());
            }
            case NONSTRICT_READ_WRITE: {
                return new NonStrictReadWriteRedisNaturalIdRegionAccessStrategy(naturalIdRegion, naturalIdRegion.getOptions());
            }
            case TRANSACTIONAL: {
                return new TransactionalRedisNaturalIdRegionAccessStrategy(naturalIdRegion, naturalIdRegion.getOptions());
            }
        }
        throw new IllegalArgumentException("unrecognized access strategy type [" + accessType + "]");
    }
}

