/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.redis.hibernate5.strategy;

import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.cache.internal.DefaultCacheKeysFactory;
import org.hibernate.cache.redis.hibernate5.regions.RedisEntityRegion;
import org.hibernate.cache.redis.hibernate5.strategy.AbstractRedisAccessStrategy;
import org.hibernate.cache.spi.EntityRegion;
import org.hibernate.cache.spi.access.EntityRegionAccessStrategy;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NonStrictReadWriteRedisEntityRegionAccessStrategy
extends AbstractRedisAccessStrategy<RedisEntityRegion>
implements EntityRegionAccessStrategy {
    private static final Logger log = LoggerFactory.getLogger(NonStrictReadWriteRedisEntityRegionAccessStrategy.class);

    public NonStrictReadWriteRedisEntityRegionAccessStrategy(RedisEntityRegion region, SessionFactoryOptions options) {
        super(region, options);
    }

    public Object generateCacheKey(Object id, EntityPersister persister, SessionFactoryImplementor factory, String tenantIdentifier) {
        return DefaultCacheKeysFactory.createEntityKey((Object)id, (EntityPersister)persister, (SessionFactoryImplementor)factory, (String)tenantIdentifier);
    }

    public Object getCacheKeyId(Object cacheKey) {
        return DefaultCacheKeysFactory.getEntityId((Object)cacheKey);
    }

    public EntityRegion getRegion() {
        return (EntityRegion)this.region;
    }

    @Override
    public Object get(SessionImplementor session, Object key, long txTimestamp) {
        return ((RedisEntityRegion)this.region).get(key);
    }

    @Override
    public boolean putFromLoad(SessionImplementor session, Object key, Object value, long txTimestamp, Object version, boolean minimalPutOverride) {
        if (minimalPutOverride && ((RedisEntityRegion)this.region).contains(key)) {
            return false;
        }
        ((RedisEntityRegion)this.region).put(key, value);
        return true;
    }

    @Override
    public SoftLock lockItem(SessionImplementor session, Object key, Object version) {
        return null;
    }

    @Override
    public void unlockItem(SessionImplementor session, Object key, SoftLock lock) {
        ((RedisEntityRegion)this.region).remove(key);
    }

    public boolean insert(SessionImplementor session, Object key, Object value, Object version) {
        return false;
    }

    public boolean afterInsert(SessionImplementor session, Object key, Object value, Object version) {
        return false;
    }

    public boolean update(SessionImplementor session, Object key, Object value, Object currentVersion, Object previousVersion) {
        this.remove(session, key);
        return false;
    }

    public boolean afterUpdate(SessionImplementor session, Object key, Object value, Object currentVersion, Object previousVersion, SoftLock lock) {
        this.unlockItem(session, key, lock);
        return false;
    }
}

