/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.redis.hibernate4.regions;

import java.util.Properties;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.redis.client.RedisClient;
import org.hibernate.cache.redis.hibernate4.regions.RedisDataRegion;
import org.hibernate.cache.redis.hibernate4.strategy.RedisAccessStrategyFactory;
import org.hibernate.cache.spi.CacheDataDescription;
import org.hibernate.cache.spi.TransactionalDataRegion;
import org.hibernate.cfg.Settings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisTransactionalDataRegion
extends RedisDataRegion
implements TransactionalDataRegion {
    private static final Logger log = LoggerFactory.getLogger(RedisTransactionalDataRegion.class);
    protected final Settings settings;
    protected final CacheDataDescription metadata;

    public RedisTransactionalDataRegion(RedisAccessStrategyFactory accessStrategyFactory, RedisClient redis, String regionName, Settings settings, CacheDataDescription metadata, Properties props) {
        super(accessStrategyFactory, redis, regionName, props);
        this.settings = settings;
        this.metadata = metadata;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public boolean isTransactionAware() {
        return false;
    }

    public CacheDataDescription getCacheDataDescription() {
        return this.metadata;
    }

    public <T> T get(Object key) {
        try {
            return this.redis.get(this.getName(), key);
        }
        catch (Exception e) {
            log.warn("Fail to get cache item... key=" + key, (Throwable)e);
            return null;
        }
    }

    public void put(Object key, Object value) {
        try {
            this.redis.set(this.getName(), key, value, this.getExpiryInSeconds());
        }
        catch (Exception e) {
            log.warn("Fail to put cache item... key=" + key, (Throwable)e);
        }
    }

    public void remove(Object key) throws CacheException {
        try {
            this.redis.del(this.getName(), key);
        }
        catch (Exception e) {
            log.warn("Fail to remove cache item... key=" + key, (Throwable)e);
        }
    }

    public void clear() {
        try {
            this.redis.deleteRegion(this.getName());
        }
        catch (Exception e) {
            log.warn("Fail to clear region... name=" + this.getName(), (Throwable)e);
        }
    }
}

