/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.redis.hibernate4;

import java.util.Properties;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.redis.client.RedisClientFactory;
import org.hibernate.cache.redis.hibernate4.AbstractRedisRegionFactory;
import org.hibernate.cache.redis.util.RedisCacheUtil;
import org.hibernate.cfg.Settings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisRegionFactory
extends AbstractRedisRegionFactory {
    private static final Logger log = LoggerFactory.getLogger(RedisRegionFactory.class);
    private static final long serialVersionUID = 563532064197800959L;

    public RedisRegionFactory(Properties props) {
        super(props);
    }

    public void start(Settings settings, Properties properties) throws CacheException {
        log.info("Starting RedisRegionFactory...");
        this.settings = settings;
        try {
            if (this.redis == null) {
                RedisCacheUtil.loadCacheProperties(properties);
                this.redis = RedisClientFactory.createRedisClient(RedisCacheUtil.getRedissonConfigPath());
            }
            log.info("RedisRegionFactory is started");
        }
        catch (Exception e) {
            log.error("Fail to start RedisRegionFactory.", (Throwable)e);
            throw new CacheException((Throwable)e);
        }
    }

    public void stop() {
        if (this.redis == null || this.redis.isShutdown()) {
            return;
        }
        log.debug("Stopping RedisRegionFactory...");
        try {
            this.redis.shutdown();
            this.redis = null;
            log.info("RedisRegionFactory is stopped.");
        }
        catch (Exception e) {
            log.error("Fail to stop RedisRegionFactory.", (Throwable)e);
            throw new CacheException((Throwable)e);
        }
    }
}

