/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.redis.hibernate4;

import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.redis.client.RedisClient;
import org.hibernate.cache.redis.hibernate4.regions.RedisCollectionRegion;
import org.hibernate.cache.redis.hibernate4.regions.RedisEntityRegion;
import org.hibernate.cache.redis.hibernate4.regions.RedisNaturalIdRegion;
import org.hibernate.cache.redis.hibernate4.regions.RedisQueryResultsRegion;
import org.hibernate.cache.redis.hibernate4.regions.RedisTimestampsRegion;
import org.hibernate.cache.redis.hibernate4.strategy.RedisAccessStrategyFactory;
import org.hibernate.cache.redis.hibernate4.strategy.RedisAccessStrategyFactoryImpl;
import org.hibernate.cache.redis.util.Timestamper;
import org.hibernate.cache.spi.CacheDataDescription;
import org.hibernate.cache.spi.CollectionRegion;
import org.hibernate.cache.spi.EntityRegion;
import org.hibernate.cache.spi.NaturalIdRegion;
import org.hibernate.cache.spi.QueryResultsRegion;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.cache.spi.TimestampsRegion;
import org.hibernate.cache.spi.access.AccessType;
import org.hibernate.cfg.Settings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractRedisRegionFactory
implements RegionFactory {
    private static final Logger log = LoggerFactory.getLogger(AbstractRedisRegionFactory.class);
    protected Settings settings;
    protected final Properties props;
    protected final RedisAccessStrategyFactory accessStrategyFactory = new RedisAccessStrategyFactoryImpl();
    protected final Set<String> regionNames = new HashSet<String>();
    protected RedisClient redis = null;
    private static final long serialVersionUID = -5441842686229077097L;

    protected AbstractRedisRegionFactory(Properties props) {
        this.props = props;
    }

    public boolean isMinimalPutsEnabledByDefault() {
        return true;
    }

    public AccessType getDefaultAccessType() {
        return AccessType.READ_WRITE;
    }

    public long nextTimestamp() {
        return Timestamper.next();
    }

    public EntityRegion buildEntityRegion(String regionName, Properties properties, CacheDataDescription metadata) throws CacheException {
        this.regionNames.add(regionName);
        return new RedisEntityRegion(this.accessStrategyFactory, this.redis, regionName, this.settings, metadata, properties);
    }

    public NaturalIdRegion buildNaturalIdRegion(String regionName, Properties properties, CacheDataDescription metadata) throws CacheException {
        this.regionNames.add(regionName);
        return new RedisNaturalIdRegion(this.accessStrategyFactory, this.redis, regionName, this.settings, metadata, properties);
    }

    public CollectionRegion buildCollectionRegion(String regionName, Properties properties, CacheDataDescription metadata) throws CacheException {
        this.regionNames.add(regionName);
        return new RedisCollectionRegion(this.accessStrategyFactory, this.redis, regionName, this.settings, metadata, properties);
    }

    public QueryResultsRegion buildQueryResultsRegion(String regionName, Properties properties) throws CacheException {
        this.regionNames.add(regionName);
        return new RedisQueryResultsRegion(this.accessStrategyFactory, this.redis, regionName, properties);
    }

    public TimestampsRegion buildTimestampsRegion(String regionName, Properties properties) throws CacheException {
        return new RedisTimestampsRegion(this.accessStrategyFactory, this.redis, regionName, properties);
    }
}

