/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.redis.client;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import lombok.NonNull;
import org.hibernate.cache.redis.client.RedisClient;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.client.codec.Codec;
import org.redisson.codec.SnappyCodec;
import org.redisson.config.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RedisClientFactory {
    private static final Logger log = LoggerFactory.getLogger(RedisClientFactory.class);

    private RedisClientFactory() {
    }

    public static RedisClient createRedisClient(@NonNull URL redissonYamlUrl) {
        if (redissonYamlUrl == null) {
            throw new NullPointerException("redissonYamlUrl");
        }
        try {
            Config config = Config.fromYAML((URL)redissonYamlUrl);
            if (config.getCodec() == null) {
                config.setCodec((Codec)new SnappyCodec());
            }
            log.debug("Set Redisson Codec = {}", (Object)config.getCodec().getClass().getName());
            RedissonClient redisson = Redisson.create((Config)config);
            return new RedisClient(redisson);
        }
        catch (IOException e) {
            log.error("Error in create RedisClient. redissonYamlUrl={}", (Object)redissonYamlUrl, (Object)e);
            throw new RuntimeException(e);
        }
    }

    public static RedisClient createRedisClient(@NonNull String redissonYamlPath) {
        if (redissonYamlPath == null) {
            throw new NullPointerException("redissonYamlPath");
        }
        log.trace("load redisson config yaml file. path={}", (Object)redissonYamlPath);
        String path = null;
        URL url = null;
        if (redissonYamlPath.startsWith("classpath:")) {
            path = redissonYamlPath.substring("classpath:".length());
            url = Thread.currentThread().getContextClassLoader().getResource(path);
            log.trace("load redisson yaml. path={}, url={}", (Object)path, (Object)url);
            return RedisClientFactory.createRedisClient(url);
        }
        path = redissonYamlPath;
        if (redissonYamlPath.startsWith("file:")) {
            path = path.substring("file:".length());
        }
        url = new File(path).toURI().toURL();
        log.trace("load redisson yaml. path={}, url={}", (Object)path, (Object)url);
        return RedisClientFactory.createRedisClient(url);
    }
}

