/*
 * Decompiled with CFR 0.152.
 */
package com.github.dbunit.rules.junit5;

import com.github.dbunit.rules.api.connection.ConnectionHolder;
import com.github.dbunit.rules.api.dataset.DataSet;
import com.github.dbunit.rules.api.dataset.DataSetExecutor;
import com.github.dbunit.rules.api.dataset.ExpectedDataSet;
import com.github.dbunit.rules.api.expoter.DataSetExportConfig;
import com.github.dbunit.rules.api.expoter.ExportDataSet;
import com.github.dbunit.rules.api.leak.LeakHunter;
import com.github.dbunit.rules.configuration.ConnectionConfig;
import com.github.dbunit.rules.configuration.DBUnitConfig;
import com.github.dbunit.rules.configuration.DataSetConfig;
import com.github.dbunit.rules.connection.ConnectionHolderImpl;
import com.github.dbunit.rules.dataset.DataSetExecutorImpl;
import com.github.dbunit.rules.exporter.DataSetExporter;
import com.github.dbunit.rules.junit5.DBUnitTestContext;
import com.github.dbunit.rules.leak.LeakHunterException;
import com.github.dbunit.rules.leak.LeakHunterFactory;
import com.github.dbunit.rules.util.EntityManagerProvider;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Arrays;
import java.util.Optional;
import org.dbunit.DatabaseUnitException;
import org.junit.jupiter.api.extension.AfterTestExecutionCallback;
import org.junit.jupiter.api.extension.BeforeTestExecutionCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestExtensionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBUnitExtension
implements BeforeTestExecutionCallback,
AfterTestExecutionCallback {
    private static final Logger log = LoggerFactory.getLogger(DBUnitExtension.class);
    private static final ExtensionContext.Namespace namespace = ExtensionContext.Namespace.create((Object[])new Object[]{DBUnitExtension.class});

    public void beforeTestExecution(TestExtensionContext testExtensionContext) throws Exception {
        DataSet annotation;
        if (!this.shouldCreateDataSet(testExtensionContext)) {
            return;
        }
        ConnectionHolder connectionHolder = this.findTestConnection(testExtensionContext);
        if (EntityManagerProvider.isEntityManagerActive()) {
            EntityManagerProvider.em().clear();
        }
        if ((annotation = ((Method)testExtensionContext.getTestMethod().get()).getAnnotation(DataSet.class)) == null) {
            annotation = ((Class)testExtensionContext.getTestClass().get()).getAnnotation(DataSet.class);
        }
        DBUnitConfig dbUnitConfig = DBUnitConfig.from((Method)((Method)testExtensionContext.getTestMethod().get()));
        DataSetConfig dataSetConfig = new DataSetConfig().from(annotation);
        if (connectionHolder == null || connectionHolder.getConnection() == null) {
            connectionHolder = this.createConnection(dbUnitConfig, ((Method)testExtensionContext.getTestMethod().get()).getName());
        }
        DataSetExecutorImpl executor = DataSetExecutorImpl.instance((String)dataSetConfig.getExecutorId(), (ConnectionHolder)connectionHolder);
        executor.setDBUnitConfig(dbUnitConfig);
        DBUnitTestContext dbUnitTestContext = this.getTestContext((ExtensionContext)testExtensionContext);
        dbUnitTestContext.setExecutor((DataSetExecutor)executor).setDataSetConfig(dataSetConfig);
        if (dataSetConfig != null && dataSetConfig.getExecuteStatementsBefore() != null && dataSetConfig.getExecuteStatementsBefore().length > 0) {
            try {
                executor.executeStatements(dataSetConfig.getExecuteStatementsBefore());
            }
            catch (Exception e) {
                log.error(((Method)testExtensionContext.getTestMethod().get()).getName() + "() - Could not execute statements Before:" + e.getMessage(), (Throwable)e);
            }
        }
        if (dataSetConfig.getExecuteScriptsBefore() != null && dataSetConfig.getExecuteScriptsBefore().length > 0) {
            try {
                for (int i = 0; i < dataSetConfig.getExecuteScriptsBefore().length; ++i) {
                    executor.executeScript(dataSetConfig.getExecuteScriptsBefore()[i]);
                }
            }
            catch (Exception e) {
                if (e instanceof DatabaseUnitException) {
                    throw e;
                }
                log.error(((Method)testExtensionContext.getTestMethod().get()).getName() + "() - Could not execute scriptsBefore:" + e.getMessage(), (Throwable)e);
            }
        }
        if (dbUnitConfig.isLeakHunter()) {
            LeakHunter leakHunter = LeakHunterFactory.from((Connection)connectionHolder.getConnection());
            dbUnitTestContext.setLeakHunter(leakHunter).setOpenConnections(leakHunter.openConnections());
        }
        try {
            executor.createDataSet(dataSetConfig);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Could not create dataset for test method %s due to following error " + e.getMessage(), ((Method)testExtensionContext.getTestMethod().get()).getName()), e);
        }
        boolean isTransactional = dataSetConfig.isTransactional();
        if (isTransactional) {
            if (EntityManagerProvider.isEntityManagerActive()) {
                if (!EntityManagerProvider.tx().isActive()) {
                    EntityManagerProvider.em().getTransaction().begin();
                }
            } else {
                Connection connection = executor.getConnectionHolder().getConnection();
                connection.setAutoCommit(false);
            }
        }
    }

    private boolean shouldCreateDataSet(TestExtensionContext testExtensionContext) {
        return ((Method)testExtensionContext.getTestMethod().get()).isAnnotationPresent(DataSet.class) || ((Class)testExtensionContext.getTestClass().get()).isAnnotationPresent(DataSet.class);
    }

    private boolean shouldCompareDataSet(TestExtensionContext testExtensionContext) {
        return ((Method)testExtensionContext.getTestMethod().get()).isAnnotationPresent(ExpectedDataSet.class) || ((Class)testExtensionContext.getTestClass().get()).isAnnotationPresent(ExpectedDataSet.class);
    }

    private boolean shouldExportDataSet(TestExtensionContext testExtensionContext) {
        return ((Method)testExtensionContext.getTestMethod().get()).isAnnotationPresent(ExportDataSet.class) || ((Class)testExtensionContext.getTestClass().get()).isAnnotationPresent(ExportDataSet.class);
    }

    public void exportDataSet(DataSetExecutor dataSetExecutor, Method method) {
        ExportDataSet exportDataSet = this.resolveExportDataSet(method);
        if (exportDataSet != null) {
            DataSetExportConfig exportConfig = DataSetExportConfig.from((ExportDataSet)exportDataSet);
            String outputName = exportConfig.getOutputFileName();
            if (outputName == null || "".equals(outputName.trim())) {
                outputName = method.getName().toLowerCase() + "." + exportConfig.getDataSetFormat().name().toLowerCase();
            }
            exportConfig.outputFileName(outputName);
            try {
                DataSetExporter.getInstance().export(dataSetExecutor.getDBUnitConnection(), exportConfig);
            }
            catch (Exception e) {
                log.warn("Could not export dataset after method " + method.getName(), (Throwable)e);
            }
        }
    }

    private ExportDataSet resolveExportDataSet(Method method) {
        ExportDataSet exportDataSet = method.getAnnotation(ExportDataSet.class);
        if (exportDataSet == null) {
            exportDataSet = method.getDeclaringClass().getAnnotation(ExportDataSet.class);
        }
        return exportDataSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterTestExecution(TestExtensionContext testExtensionContext) throws Exception {
        DataSetExecutor executor;
        DBUnitTestContext dbUnitTestContext = this.getTestContext((ExtensionContext)testExtensionContext);
        DBUnitConfig dbUnitConfig = dbUnitTestContext.getExecutor().getDBUnitConfig();
        try {
            if (this.shouldCompareDataSet(testExtensionContext)) {
                ExpectedDataSet expectedDataSet = ((Method)testExtensionContext.getTestMethod().get()).getAnnotation(ExpectedDataSet.class);
                if (expectedDataSet == null) {
                    expectedDataSet = ((Class)testExtensionContext.getTestClass().get()).getAnnotation(ExpectedDataSet.class);
                }
                if (expectedDataSet != null) {
                    executor = dbUnitTestContext.getExecutor();
                    DataSetConfig datasetConfig = dbUnitTestContext.getDataSetConfig();
                    boolean isTransactional = datasetConfig.isTransactional();
                    if (isTransactional) {
                        try {
                            if (EntityManagerProvider.isEntityManagerActive()) {
                                if (EntityManagerProvider.tx().isActive()) {
                                    EntityManagerProvider.tx().commit();
                                }
                            } else {
                                Connection connection = executor.getConnectionHolder().getConnection();
                                connection.commit();
                                connection.setAutoCommit(false);
                            }
                        }
                        catch (Exception e) {
                            if (EntityManagerProvider.isEntityManagerActive()) {
                                EntityManagerProvider.tx().rollback();
                            }
                            Connection connection = executor.getConnectionHolder().getConnection();
                            connection.setAutoCommit(false);
                            connection.setReadOnly(true);
                        }
                    }
                    executor.compareCurrentDataSetWith(new DataSetConfig(expectedDataSet.value()).disableConstraints(true), expectedDataSet.ignoreCols());
                }
            }
            if (dbUnitConfig != null && dbUnitConfig.isLeakHunter()) {
                LeakHunter leakHunter = dbUnitTestContext.getLeakHunter();
                int openConnectionsBefore = dbUnitTestContext.getOpenConnections();
                int openConnectionsAfter = leakHunter.openConnections();
                if (openConnectionsAfter > openConnectionsBefore) {
                    throw new LeakHunterException(((Method)testExtensionContext.getTestMethod().get()).getName(), openConnectionsAfter - openConnectionsBefore);
                }
            }
        }
        finally {
            DataSetConfig dataSetConfig = dbUnitTestContext.getDataSetConfig();
            if (dataSetConfig == null) {
                return;
            }
            executor = dbUnitTestContext.getExecutor();
            if (this.shouldExportDataSet(testExtensionContext)) {
                this.exportDataSet(executor, (Method)testExtensionContext.getTestMethod().get());
            }
            if (dataSetConfig != null && dataSetConfig.getExecuteStatementsAfter() != null && dataSetConfig.getExecuteStatementsAfter().length > 0) {
                try {
                    executor.executeStatements(dataSetConfig.getExecuteStatementsAfter());
                }
                catch (Exception e) {
                    log.error(((Method)testExtensionContext.getTestMethod().get()).getName() + "() - Could not execute statements after:" + e.getMessage(), (Throwable)e);
                }
            }
            if (dataSetConfig.getExecuteScriptsAfter() != null && dataSetConfig.getExecuteScriptsAfter().length > 0) {
                try {
                    for (int i = 0; i < dataSetConfig.getExecuteScriptsAfter().length; ++i) {
                        executor.executeScript(dataSetConfig.getExecuteScriptsAfter()[i]);
                    }
                }
                catch (Exception e) {
                    if (e instanceof DatabaseUnitException) {
                        throw e;
                    }
                    log.error(((Method)testExtensionContext.getTestMethod().get()).getName() + "() - Could not execute scriptsAfter:" + e.getMessage(), (Throwable)e);
                }
            }
            if (dataSetConfig.isCleanAfter()) {
                executor.clearDatabase(dataSetConfig);
            }
        }
    }

    private ConnectionHolder findTestConnection(TestExtensionContext testExtensionContext) {
        Class testClass = (Class)testExtensionContext.getTestClass().get();
        try {
            Optional<Field> fieldFound = Arrays.stream(testClass.getDeclaredFields()).filter(f -> f.getType() == ConnectionHolder.class).findFirst();
            if (fieldFound.isPresent()) {
                ConnectionHolder connectionHolder;
                Field field = fieldFound.get();
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                if ((connectionHolder = (ConnectionHolder)ConnectionHolder.class.cast(field.get(testExtensionContext.getTestInstance()))) == null || connectionHolder.getConnection() == null) {
                    throw new RuntimeException("ConnectionHolder not initialized correctly");
                }
                return connectionHolder;
            }
            Optional<Method> methodFound = Arrays.stream(testClass.getDeclaredMethods()).filter(m -> m.getReturnType() == ConnectionHolder.class).findFirst();
            if (methodFound.isPresent()) {
                ConnectionHolder connectionHolder;
                Method method = methodFound.get();
                if (!method.isAccessible()) {
                    method.setAccessible(true);
                }
                if ((connectionHolder = (ConnectionHolder)ConnectionHolder.class.cast(method.invoke(testExtensionContext.getTestInstance(), new Object[0]))) == null || connectionHolder.getConnection() == null) {
                    throw new RuntimeException("ConnectionHolder not initialized correctly");
                }
                return connectionHolder;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not get database connection for test " + testClass, e);
        }
        return null;
    }

    private ConnectionHolder createConnection(DBUnitConfig dbUnitConfig, String currentMethod) {
        ConnectionConfig connectionConfig = dbUnitConfig.getConnectionConfig();
        if ("".equals(connectionConfig.getUrl()) || "".equals(connectionConfig.getUser())) {
            throw new RuntimeException(String.format("Could not create JDBC connection for method %s, provide a connection at test level or via configuration, see documentation here: https://github.com/rmpestano/dbunit-rules#jdbc-connection", currentMethod));
        }
        try {
            if (!"".equals(connectionConfig.getDriver())) {
                Class.forName(connectionConfig.getDriver());
            }
            return new ConnectionHolderImpl(DriverManager.getConnection(connectionConfig.getUrl(), connectionConfig.getUser(), connectionConfig.getPassword()));
        }
        catch (Exception e) {
            log.error("Could not create JDBC connection for method " + currentMethod, (Throwable)e);
            return null;
        }
    }

    private DBUnitTestContext getTestContext(ExtensionContext context) {
        Class testClass = (Class)context.getTestClass().get();
        ExtensionContext.Store store = context.getStore(namespace);
        DBUnitTestContext testContext = (DBUnitTestContext)store.get((Object)testClass, DBUnitTestContext.class);
        if (testContext == null) {
            testContext = new DBUnitTestContext();
            store.put((Object)testClass, (Object)testContext);
        }
        return testContext;
    }
}

