/*
 * Decompiled with CFR 0.152.
 */
package com.github.danielflower.mavenplugins.release;

import com.github.danielflower.mavenplugins.release.SshAgentSessionFactory;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.eclipse.jgit.transport.JschConfigSessionFactory;
import org.eclipse.jgit.transport.SshSessionFactory;

public abstract class BaseMojo
extends AbstractMojo {
    @Parameter(property="project", required=true, readonly=true, defaultValue="${project}")
    protected MavenProject project;
    @Parameter(property="projects", required=true, readonly=true, defaultValue="${reactorProjects}")
    protected List<MavenProject> projects;
    @Parameter(property="buildNumber")
    protected Long buildNumber;
    @Parameter(alias="modulesToRelease", property="modulesToRelease")
    protected List<String> modulesToRelease;
    @Parameter(alias="forceRelease", property="forceRelease")
    protected List<String> modulesToForceRelease;
    @Parameter(property="disableSshAgent")
    private boolean disableSshAgent;
    @Parameter(defaultValue="${settings}", readonly=true, required=true)
    private Settings settings;
    @Parameter(property="serverId")
    private String serverId;
    @Parameter(property="knownHosts")
    private String knownHosts;
    @Parameter(property="privateKey")
    private String privateKey;
    @Parameter(property="passphrase")
    private String passphrase;

    final void setSettings(Settings settings) {
        this.settings = settings;
    }

    final void setServerId(String serverId) {
        this.serverId = serverId;
    }

    final void setKnownHosts(String knownHosts) {
        this.knownHosts = knownHosts;
    }

    final void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
    }

    final void setPassphrase(String passphrase) {
        this.passphrase = passphrase;
    }

    final void disableSshAgent() {
        this.disableSshAgent = true;
    }

    protected final void configureJsch(Log log) {
        if (!this.disableSshAgent) {
            if (this.serverId != null) {
                Server server = this.settings.getServer(this.serverId);
                if (server != null) {
                    this.privateKey = this.privateKey == null ? server.getPrivateKey() : this.privateKey;
                    this.passphrase = this.passphrase == null ? server.getPassphrase() : this.passphrase;
                } else {
                    log.warn((CharSequence)String.format("No server configuration in Maven settings found with id %s", this.serverId));
                }
            }
            JschConfigSessionFactory.setInstance((SshSessionFactory)new SshAgentSessionFactory(log, this.knownHosts, this.privateKey, this.passphrase));
        }
    }
}

