/*
 * Decompiled with CFR 0.152.
 */
package com.discoveryone.navigation.result;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import androidx.activity.result.ActivityResult;
import androidx.activity.result.ActivityResultCallback;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.activity.result.contract.ActivityResultContracts;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentResultOwner;
import androidx.fragment.app.FragmentResultOwnerKt;
import androidx.lifecycle.LifecycleOwner;
import com.discoveryone.exceptions.NoActionRegisteredForGivenKeyException;
import com.discoveryone.navigation.NavigationContext;
import com.discoveryone.navigation.result.ResultRegistry$WhenMappings;
import com.discoveryone.navigation.result.ResultSpy;
import com.discoveryone.routes.AbstractRoute;
import com.discoveryone.routes.GeneratedActivityRoute;
import com.discoveryone.routes.GeneratedDialogFragmentRoute;
import com.discoveryone.routes.GeneratedFragmentRoute;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.full.KClasses;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001+B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J%\u0010\f\u001a\u00020\u0004\"\b\b\u0000\u0010\r*\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\r0\u0010H\u0000\u00a2\u0006\u0002\b\u0011JB\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\t0\b\"\b\b\u0000\u0010\u0013*\u00020\u00012\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00130\u00102\u0006\u0010\u0015\u001a\u00020\u00162\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u0002H\u0013\u0012\u0004\u0012\u00020\u00190\u0018H\u0002J.\u0010\u001a\u001a\u00020\u0019\"\b\b\u0000\u0010\r*\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\r0\u00102\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\tJ\u000e\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\u000bJ<\u0010 \u001a\u00020\u0019\"\b\b\u0000\u0010\u0013*\u00020\u00012\u0006\u0010!\u001a\u00020\"2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00130\u00102\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u0002H\u0013\u0012\u0004\u0012\u00020\u00190\u0018H\u0002JZ\u0010#\u001a\u00020\u0019\"\b\b\u0000\u0010\u0013*\u00020\u0001\"\b\b\u0001\u0010\r*\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\r0\u00102\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00130\u00102\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u0002H\u0013\u0012\u0004\u0012\u00020\u00190\u0018J\\\u0010$\u001a\u00020\u0019\"\b\b\u0000\u0010\u0013*\u00020\u0001\"\b\b\u0001\u0010\r*\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\r0\u00102\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00130\u00102\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u0002H\u0013\u0012\u0004\u0012\u00020\u00190\u0018H\u0002J\\\u0010%\u001a\u00020\u0019\"\b\b\u0000\u0010\u0013*\u00020\u0001\"\b\b\u0001\u0010\r*\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\r0\u00102\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00130\u00102\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u0002H\u0013\u0012\u0004\u0012\u00020\u00190\u0018H\u0002J\u000e\u0010&\u001a\u00020\u00192\u0006\u0010'\u001a\u00020(J\u001c\u0010)\u001a\u00020*\"\b\b\u0000\u0010\r*\u00020\u000e*\b\u0012\u0004\u0012\u0002H\r0\u0010H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R \u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/discoveryone/navigation/result/ResultRegistry;", "", "()V", "DEFAULT_INTENT_EXTRA_KEY", "", "activityResultLauncherMap", "", "Lcom/discoveryone/navigation/result/ResultRegistry$ActivityResultLauncherMapKey;", "Landroidx/activity/result/ActivityResultLauncher;", "Landroid/content/Intent;", "resultSpy", "Lcom/discoveryone/navigation/result/ResultSpy;", "buildSimpleResultKey", "R", "Lcom/discoveryone/routes/AbstractRoute;", "routeClass", "Lkotlin/reflect/KClass;", "buildSimpleResultKey$discoveryone_runtime_release", "createActivityResultLauncher", "T", "resultClass", "currentActivity", "Landroidx/fragment/app/FragmentActivity;", "action", "Lkotlin/Function1;", "", "executeActivityResultLauncher", "navigationContext", "Lcom/discoveryone/navigation/NavigationContext;", "intent", "injectActivityResultSpy", "spy", "launchActionOnResult", "bundle", "Landroid/os/Bundle;", "registerResultAction", "registerResultActionForActivityRoute", "registerResultActionForFragmentRoute", "unregisterActivityResultLauncher", "activity", "Landroid/app/Activity;", "isFragmentOrDialogFragment", "", "ActivityResultLauncherMapKey", "discoveryone-runtime_release"})
public final class ResultRegistry {
    private static final Map<ActivityResultLauncherMapKey, ActivityResultLauncher<Intent>> activityResultLauncherMap;
    private static ResultSpy resultSpy;
    @NotNull
    public static final String DEFAULT_INTENT_EXTRA_KEY = "default_intent_extra_key";
    public static final ResultRegistry INSTANCE;

    public final <R extends AbstractRoute> void executeActivityResultLauncher(@NotNull KClass<R> routeClass, @NotNull NavigationContext navigationContext, @NotNull Intent intent) {
        Intrinsics.checkParameterIsNotNull(routeClass, (String)"routeClass");
        Intrinsics.checkParameterIsNotNull((Object)navigationContext, (String)"navigationContext");
        Intrinsics.checkParameterIsNotNull((Object)intent, (String)"intent");
        ActivityResultLauncherMapKey key = new ActivityResultLauncherMapKey(navigationContext.getInstanceHashCode$discoveryone_runtime_release(), this.buildSimpleResultKey$discoveryone_runtime_release(routeClass));
        ActivityResultLauncher<Intent> activityResultLauncher = activityResultLauncherMap.get(key);
        if (activityResultLauncher == null) {
            throw (Throwable)new NoActionRegisteredForGivenKeyException();
        }
        ActivityResultLauncher<Intent> activityResultLauncher2 = activityResultLauncher;
        activityResultLauncherMap.remove(key);
        activityResultLauncher2.launch((Object)intent);
    }

    public final <T, R extends AbstractRoute> void registerResultAction(@NotNull FragmentActivity currentActivity, @NotNull NavigationContext navigationContext, @NotNull KClass<R> routeClass, @NotNull KClass<T> resultClass, @NotNull Function1<? super T, Unit> action) {
        Intrinsics.checkParameterIsNotNull((Object)currentActivity, (String)"currentActivity");
        Intrinsics.checkParameterIsNotNull((Object)navigationContext, (String)"navigationContext");
        Intrinsics.checkParameterIsNotNull(routeClass, (String)"routeClass");
        Intrinsics.checkParameterIsNotNull(resultClass, (String)"resultClass");
        Intrinsics.checkParameterIsNotNull(action, (String)"action");
        if (KClasses.isSubclassOf(routeClass, (KClass)Reflection.getOrCreateKotlinClass(GeneratedActivityRoute.class))) {
            FragmentActivity fragmentActivity = currentActivity;
            Function1<? super T, Unit> function1 = action;
            KClass<T> kClass = resultClass;
            KClass<R> kClass2 = routeClass;
            NavigationContext navigationContext2 = navigationContext;
            this.registerResultActionForActivityRoute(fragmentActivity, navigationContext2, kClass2, kClass, function1);
        } else if (this.isFragmentOrDialogFragment(routeClass)) {
            FragmentActivity fragmentActivity = currentActivity;
            Function1<? super T, Unit> function1 = action;
            KClass<T> kClass = resultClass;
            KClass<R> kClass3 = routeClass;
            NavigationContext navigationContext3 = navigationContext;
            this.registerResultActionForFragmentRoute(fragmentActivity, navigationContext3, kClass3, kClass, function1);
        }
    }

    private final <T, R extends AbstractRoute> void registerResultActionForActivityRoute(FragmentActivity currentActivity, NavigationContext navigationContext, KClass<R> routeClass, KClass<T> resultClass, Function1<? super T, Unit> action) {
        ActivityResultLauncherMapKey key = new ActivityResultLauncherMapKey(navigationContext.getInstanceHashCode$discoveryone_runtime_release(), String.valueOf(routeClass.getQualifiedName()));
        activityResultLauncherMap.put(key, this.createActivityResultLauncher(resultClass, currentActivity, action));
    }

    private final <T, R extends AbstractRoute> void registerResultActionForFragmentRoute(FragmentActivity currentActivity, NavigationContext navigationContext, KClass<R> routeClass, KClass<T> resultClass, Function1<? super T, Unit> action) {
        switch (ResultRegistry$WhenMappings.$EnumSwitchMapping$0[navigationContext.getComponentType$discoveryone_runtime_release().ordinal()]) {
            case 1: {
                FragmentManager fragmentManager = currentActivity.getSupportFragmentManager();
                Intrinsics.checkExpressionValueIsNotNull((Object)fragmentManager, (String)"currentActivity.supportFragmentManager");
                FragmentResultOwnerKt.setFragmentResultListener((FragmentResultOwner)((FragmentResultOwner)fragmentManager), (String)this.buildSimpleResultKey$discoveryone_runtime_release(routeClass), (LifecycleOwner)((LifecycleOwner)currentActivity), (Function2)((Function2)new Function2<String, Bundle, Unit>(resultClass, action){
                    final /* synthetic */ KClass $resultClass;
                    final /* synthetic */ Function1 $action;

                    public final void invoke(@NotNull String $noName_0, @NotNull Bundle bundle) {
                        Intrinsics.checkParameterIsNotNull((Object)$noName_0, (String)"<anonymous parameter 0>");
                        Intrinsics.checkParameterIsNotNull((Object)bundle, (String)"bundle");
                        ResultRegistry.access$launchActionOnResult(ResultRegistry.INSTANCE, bundle, this.$resultClass, this.$action);
                    }
                    {
                        this.$resultClass = kClass;
                        this.$action = function1;
                        super(2);
                    }
                }));
                break;
            }
            case 2: 
            case 3: {
                FragmentManager fragmentManager = currentActivity.getSupportFragmentManager();
                Intrinsics.checkExpressionValueIsNotNull((Object)fragmentManager, (String)"currentActivity.supportFragmentManager");
                FragmentResultOwnerKt.setFragmentResultListener((FragmentResultOwner)((FragmentResultOwner)fragmentManager), (String)this.buildSimpleResultKey$discoveryone_runtime_release(routeClass), (LifecycleOwner)((LifecycleOwner)currentActivity), (Function2)((Function2)new Function2<String, Bundle, Unit>(resultClass, action){
                    final /* synthetic */ KClass $resultClass;
                    final /* synthetic */ Function1 $action;

                    public final void invoke(@NotNull String $noName_0, @NotNull Bundle bundle) {
                        Intrinsics.checkParameterIsNotNull((Object)$noName_0, (String)"<anonymous parameter 0>");
                        Intrinsics.checkParameterIsNotNull((Object)bundle, (String)"bundle");
                        ResultRegistry.access$launchActionOnResult(ResultRegistry.INSTANCE, bundle, this.$resultClass, this.$action);
                    }
                    {
                        this.$resultClass = kClass;
                        this.$action = function1;
                        super(2);
                    }
                }));
                break;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void unregisterActivityResultLauncher(@NotNull Activity activity) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
        Map $this$filter$iv = activityResultLauncherMap;
        boolean $i$f$filter = false;
        Map map = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        void var7_9 = $this$filterTo$iv$iv;
        boolean bl = false;
        Iterator iterator = var7_9.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry $dstr$key$_u24__u24 = element$iv$iv = iterator.next();
            boolean bl2 = false;
            Map.Entry entry = $dstr$key$_u24__u24;
            boolean bl3 = false;
            ActivityResultLauncherMapKey key = (ActivityResultLauncherMapKey)entry.getKey();
            if (!(key.getActivityInstanceHashCode() == activity.hashCode())) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map $this$forEach$iv = destination$iv$iv;
        boolean $i$f$forEach = false;
        map = $this$forEach$iv;
        boolean bl4 = false;
        Iterator iterator2 = map.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv;
            Map.Entry $dstr$key$_u24__u24 = element$iv = iterator2.next();
            boolean bl5 = false;
            Map.Entry entry = $dstr$key$_u24__u24;
            boolean bl6 = false;
            ActivityResultLauncherMapKey key = (ActivityResultLauncherMapKey)entry.getKey();
            activityResultLauncherMap.remove(key);
        }
    }

    private final <T> ActivityResultLauncher<Intent> createActivityResultLauncher(KClass<T> resultClass, FragmentActivity currentActivity, Function1<? super T, Unit> action) {
        ActivityResultLauncher activityResultLauncher = currentActivity.registerForActivityResult((ActivityResultContract)new ActivityResultContracts.StartActivityForResult(), (ActivityResultCallback)new ActivityResultCallback<ActivityResult>(resultClass, action){
            final /* synthetic */ KClass $resultClass;
            final /* synthetic */ Function1 $action;

            public final void onActivityResult(ActivityResult activityResult) {
                block0: {
                    ActivityResult activityResult2 = activityResult;
                    Intrinsics.checkExpressionValueIsNotNull((Object)activityResult2, (String)"activityResult");
                    Intent intent = activityResult2.getData();
                    if (intent == null || (intent = intent.getExtras()) == null) break block0;
                    Intent intent2 = intent;
                    boolean bl = false;
                    boolean bl2 = false;
                    Intent bundle = intent2;
                    boolean bl3 = false;
                    Intent intent3 = bundle;
                    Intrinsics.checkExpressionValueIsNotNull((Object)intent3, (String)"bundle");
                    ResultRegistry.access$launchActionOnResult(ResultRegistry.INSTANCE, (Bundle)intent3, this.$resultClass, this.$action);
                }
            }
            {
                this.$resultClass = kClass;
                this.$action = function1;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)activityResultLauncher, (String)"currentActivity.register\u2026)\n            }\n        }");
        return activityResultLauncher;
    }

    private final <T> void launchActionOnResult(Bundle bundle, KClass<T> resultClass, Function1<? super T, Unit> action) {
        Object result = bundle.get(DEFAULT_INTENT_EXTRA_KEY);
        if (result != null && resultClass.isInstance(result)) {
            ResultSpy resultSpy = ResultRegistry.resultSpy;
            if (resultSpy != null) {
                resultSpy.recordResult(result);
            }
            action.invoke(result);
        } else {
            Log.w((String)"DiscoveryOne", (String)"result is not an instance of the expected type");
        }
    }

    public final void injectActivityResultSpy(@NotNull ResultSpy spy) {
        Intrinsics.checkParameterIsNotNull((Object)spy, (String)"spy");
        resultSpy = spy;
    }

    private final <R extends AbstractRoute> boolean isFragmentOrDialogFragment(@NotNull KClass<R> $this$isFragmentOrDialogFragment) {
        return KClasses.isSubclassOf($this$isFragmentOrDialogFragment, (KClass)Reflection.getOrCreateKotlinClass(GeneratedDialogFragmentRoute.class)) || KClasses.isSubclassOf($this$isFragmentOrDialogFragment, (KClass)Reflection.getOrCreateKotlinClass(GeneratedFragmentRoute.class));
    }

    @NotNull
    public final <R extends AbstractRoute> String buildSimpleResultKey$discoveryone_runtime_release(@NotNull KClass<R> routeClass) {
        Intrinsics.checkParameterIsNotNull(routeClass, (String)"routeClass");
        return String.valueOf(routeClass.getQualifiedName());
    }

    private ResultRegistry() {
    }

    static {
        ResultRegistry resultRegistry;
        INSTANCE = resultRegistry = new ResultRegistry();
        boolean bl = false;
        activityResultLauncherMap = new LinkedHashMap();
    }

    public static final /* synthetic */ void access$launchActionOnResult(ResultRegistry $this, Bundle bundle, KClass resultClass, Function1 action) {
        $this.launchActionOnResult(bundle, resultClass, action);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Lcom/discoveryone/navigation/result/ResultRegistry$ActivityResultLauncherMapKey;", "", "activityInstanceHashCode", "", "key", "", "(ILjava/lang/String;)V", "getActivityInstanceHashCode", "()I", "getKey", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "discoveryone-runtime_release"})
    private static final class ActivityResultLauncherMapKey {
        private final int activityInstanceHashCode;
        @NotNull
        private final String key;

        public final int getActivityInstanceHashCode() {
            return this.activityInstanceHashCode;
        }

        @NotNull
        public final String getKey() {
            return this.key;
        }

        public ActivityResultLauncherMapKey(int activityInstanceHashCode, @NotNull String key) {
            Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
            this.activityInstanceHashCode = activityInstanceHashCode;
            this.key = key;
        }

        public final int component1() {
            return this.activityInstanceHashCode;
        }

        @NotNull
        public final String component2() {
            return this.key;
        }

        @NotNull
        public final ActivityResultLauncherMapKey copy(int activityInstanceHashCode, @NotNull String key) {
            Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
            return new ActivityResultLauncherMapKey(activityInstanceHashCode, key);
        }

        public static /* synthetic */ ActivityResultLauncherMapKey copy$default(ActivityResultLauncherMapKey activityResultLauncherMapKey, int n, String string, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = activityResultLauncherMapKey.activityInstanceHashCode;
            }
            if ((n2 & 2) != 0) {
                string = activityResultLauncherMapKey.key;
            }
            return activityResultLauncherMapKey.copy(n, string);
        }

        @NotNull
        public String toString() {
            return "ActivityResultLauncherMapKey(activityInstanceHashCode=" + this.activityInstanceHashCode + ", key=" + this.key + ")";
        }

        public int hashCode() {
            String string = this.key;
            return this.activityInstanceHashCode * 31 + (string != null ? string.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ActivityResultLauncherMapKey)) break block3;
                    ActivityResultLauncherMapKey activityResultLauncherMapKey = (ActivityResultLauncherMapKey)object;
                    if (this.activityInstanceHashCode != activityResultLauncherMapKey.activityInstanceHashCode || !Intrinsics.areEqual((Object)this.key, (Object)activityResultLauncherMapKey.key)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

