/*
 * Decompiled with CFR 0.152.
 */
package com.github.zlprogresshud.view;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.view.animation.RotateAnimation;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.github.zlprogresshud.R;
import com.github.zlprogresshud.view.ZLCircleProgressBar;

public class ZLProgressDefaultView
extends LinearLayout {
    private int resBigLoading = R.drawable.ic_svstatus_loading;
    private int resInfo = R.drawable.ic_svstatus_info;
    private int resSuccess = R.drawable.ic_svstatus_success;
    private int resError = R.drawable.ic_svstatus_error;
    private ImageView ivBigLoading;
    private ImageView ivSmallLoading;
    private ZLCircleProgressBar circleProgressBar;
    private TextView tvMsg;
    private RotateAnimation mRotateAnimation;

    public ZLProgressDefaultView(Context context) {
        super(context);
        this.initViews();
        this.init();
    }

    private void initViews() {
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.view_svprogressdefault, (ViewGroup)this, true);
        this.ivBigLoading = (ImageView)this.findViewById(R.id.ivBigLoading);
        this.ivSmallLoading = (ImageView)this.findViewById(R.id.ivSmallLoading);
        this.circleProgressBar = (ZLCircleProgressBar)this.findViewById(R.id.circleProgressBar);
        this.tvMsg = (TextView)this.findViewById(R.id.tvMsg);
    }

    private void init() {
        this.mRotateAnimation = new RotateAnimation(0.0f, 359.0f, 1, 0.5f, 1, 0.5f);
        this.mRotateAnimation.setDuration(1000L);
        this.mRotateAnimation.setInterpolator((Interpolator)new LinearInterpolator());
        this.mRotateAnimation.setRepeatCount(-1);
        this.mRotateAnimation.setRepeatMode(1);
    }

    public void show() {
        this.clearAnimations();
        this.ivBigLoading.setImageResource(this.resBigLoading);
        this.ivBigLoading.setVisibility(0);
        this.ivSmallLoading.setVisibility(8);
        this.circleProgressBar.setVisibility(8);
        this.tvMsg.setVisibility(8);
        this.ivBigLoading.startAnimation((Animation)this.mRotateAnimation);
    }

    public void showWithStatus(String string) {
        if (string == null) {
            this.show();
            return;
        }
        this.showBaseStatus(this.resBigLoading, string);
        this.ivSmallLoading.startAnimation((Animation)this.mRotateAnimation);
    }

    public void showInfoWithStatus(String string) {
        this.showBaseStatus(this.resInfo, string);
    }

    public void showSuccessWithStatus(String string) {
        this.showBaseStatus(this.resSuccess, string);
    }

    public void showErrorWithStatus(String string) {
        this.showBaseStatus(this.resError, string);
    }

    public void showWithProgress(String string, int progress) {
        this.clearAnimations();
        this.tvMsg.setText((CharSequence)string);
        this.ivBigLoading.setVisibility(8);
        this.ivSmallLoading.setVisibility(8);
        this.circleProgressBar.setVisibility(0);
        this.circleProgressBar.setMax(100);
        if (progress > 100) {
            progress = 100;
        }
        this.circleProgressBar.setProgress(progress);
        this.tvMsg.setVisibility(0);
    }

    public ZLCircleProgressBar getCircleProgressBar() {
        return this.circleProgressBar;
    }

    public void setText(String string) {
        this.tvMsg.setText((CharSequence)string);
    }

    public void showBaseStatus(int res, String string) {
        this.clearAnimations();
        this.ivSmallLoading.setImageResource(res);
        this.tvMsg.setText((CharSequence)string);
        this.ivBigLoading.setVisibility(8);
        this.circleProgressBar.setVisibility(8);
        this.ivSmallLoading.setVisibility(0);
        this.tvMsg.setVisibility(0);
    }

    public void dismiss() {
        this.clearAnimations();
    }

    private void clearAnimations() {
        this.ivBigLoading.clearAnimation();
        this.ivSmallLoading.clearAnimation();
    }
}

