/*
 * Decompiled with CFR 0.152.
 */
package com.github.cthawanapong.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Typeface;
import android.support.v7.widget.AppCompatTextView;
import android.text.TextUtils;
import android.text.style.StrikethroughSpan;
import android.util.AttributeSet;
import android.util.Log;
import android.widget.TextView;
import com.github.cthawanapong.manager.TypeFaceManager;
import com.github.cthawanapong.styleableviews.R;
import java.util.Locale;

public class StyleableStrikeThroughTextView
extends AppCompatTextView {
    private static final StrikethroughSpan a = new StrikethroughSpan();
    private boolean b;

    public StyleableStrikeThroughTextView(Context context) {
        super(context);
        if (this.isInEditMode()) {
            return;
        }
        this.a(context, null);
    }

    public StyleableStrikeThroughTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        if (this.isInEditMode()) {
            return;
        }
        this.a(context, attrs);
    }

    public StyleableStrikeThroughTextView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        if (this.isInEditMode()) {
            return;
        }
        this.a(context, attrs);
    }

    private void a(Context context, AttributeSet attributeSet) {
        TypedArray typedArray;
        if (attributeSet != null && (typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.StyleableStrikeThroughTextView)) != null) {
            String string = typedArray.getString(R.styleable.StyleableStrikeThroughTextView_typeFaceAsset);
            this.b = typedArray.getBoolean(R.styleable.StyleableStrikeThroughTextView_enableStrikeThrough, true);
            if (!TextUtils.isEmpty((CharSequence)string)) {
                string = "fonts/" + string;
                Typeface typeface = TypeFaceManager.getInstance().getFont(string);
                int n = 0;
                float f = this.getTextSize();
                if (this.getTypeface() != null) {
                    n = this.getTypeface().getStyle();
                }
                if (typeface != null) {
                    this.setTypeface(typeface, n);
                } else {
                    Log.d((String)"FontText", (String)String.format("Could not create a font from asset: %s", string));
                }
            } else if (TypeFaceManager.getInstance().isDefaultFontMapAvailable()) {
                String string2 = Locale.getDefault().getLanguage();
                if (TypeFaceManager.getInstance().isFontDefaultFontAvailable(string2)) {
                    string = "fonts/" + TypeFaceManager.getInstance().getDefaultFontName(string2);
                    Typeface typeface = TypeFaceManager.getInstance().getFont(string);
                    int n = 0;
                    if (this.getTypeface() != null) {
                        n = this.getTypeface().getStyle();
                    }
                    if (typeface != null) {
                        this.setTypeface(typeface, n);
                    } else {
                        Log.d((String)"FontText", (String)String.format("Could not create a font from asset: %s", string));
                    }
                }
            }
            typedArray.recycle();
        }
    }

    public void setText(CharSequence text, TextView.BufferType type) {
        super.setText(text, type);
        if (this.b) {
            this.setPaintFlags(this.getPaintFlags() | 0x10);
        } else {
            this.setPaintFlags(this.getPaintFlags() & 0xFFFFFFEF);
        }
    }

    public void setEnableStrikeThrough(boolean enableStrikeThrough) {
        this.b = enableStrikeThrough;
    }
}

