/*
 * Decompiled with CFR 0.152.
 */
package view;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Typeface;
import android.support.design.widget.TextInputEditText;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import com.github.cthawanapong.styleableviews.R;
import manager.TypeFaceManager;

public class StyleableEditText
extends TextInputEditText {
    private static final String TAG = StyleableEditText.class.getSimpleName();

    public StyleableEditText(Context context) {
        super(context);
        if (this.isInEditMode()) {
            return;
        }
        this.initInstance(context, null);
    }

    public StyleableEditText(Context context, AttributeSet attrs) {
        super(context, attrs);
        if (this.isInEditMode()) {
            return;
        }
        this.initInstance(context, attrs);
    }

    public StyleableEditText(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        if (this.isInEditMode()) {
            return;
        }
        this.initInstance(context, attrs);
    }

    private void initInstance(Context context, AttributeSet attrs) {
        TypedArray ta;
        if (attrs != null && (ta = context.obtainStyledAttributes(attrs, R.styleable.StyleableEditText)) != null) {
            String fontAsset = ta.getString(R.styleable.StyleableEditText_typeFaceAsset);
            if (!TextUtils.isEmpty((CharSequence)fontAsset)) {
                fontAsset = "fonts/" + fontAsset;
                Typeface tf = TypeFaceManager.getInstance().getFont(fontAsset);
                int style = 0;
                float size = this.getTextSize();
                if (this.getTypeface() != null) {
                    style = this.getTypeface().getStyle();
                }
                if (tf != null) {
                    this.setTypeface(tf, style);
                } else {
                    Log.d((String)TAG, (String)String.format("Could not create a font from asset: %s", fontAsset));
                }
            }
            ta.recycle();
        }
    }
}

