/*
 * Decompiled with CFR 0.152.
 */
package com.github.cthawanapong.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Typeface;
import android.support.v7.widget.AppCompatTextView;
import android.text.TextUtils;
import android.text.style.StrikethroughSpan;
import android.util.AttributeSet;
import android.util.Log;
import android.widget.TextView;
import com.github.cthawanapong.manager.TypeFaceManager;
import com.github.cthawanapong.styleableviews.R;

public class StyleableStrikeThroughTextView
extends AppCompatTextView {
    private static final StrikethroughSpan STRIKE_THROUGH_SPAN = new StrikethroughSpan();
    private boolean enableStrikeThrough;

    public StyleableStrikeThroughTextView(Context context) {
        super(context);
        if (this.isInEditMode()) {
            return;
        }
        this.initInstance(context, null);
    }

    public StyleableStrikeThroughTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        if (this.isInEditMode()) {
            return;
        }
        this.initInstance(context, attrs);
    }

    public StyleableStrikeThroughTextView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        if (this.isInEditMode()) {
            return;
        }
        this.initInstance(context, attrs);
    }

    private void initInstance(Context context, AttributeSet attrs) {
        TypedArray ta;
        if (attrs != null && (ta = context.obtainStyledAttributes(attrs, R.styleable.StyleableStrikeThroughTextView)) != null) {
            String fontAsset = ta.getString(R.styleable.StyleableStrikeThroughTextView_typeFaceAsset);
            this.enableStrikeThrough = ta.getBoolean(R.styleable.StyleableStrikeThroughTextView_enableStrikeThrough, true);
            if (!TextUtils.isEmpty((CharSequence)fontAsset)) {
                fontAsset = "fonts/" + fontAsset;
                Typeface tf = TypeFaceManager.getInstance().getFont(fontAsset);
                int style = 0;
                float size = this.getTextSize();
                if (this.getTypeface() != null) {
                    style = this.getTypeface().getStyle();
                }
                if (tf != null) {
                    this.setTypeface(tf, style);
                } else {
                    Log.d((String)"FontText", (String)String.format("Could not create a font from asset: %s", fontAsset));
                }
            }
            ta.recycle();
        }
    }

    public void setText(CharSequence text, TextView.BufferType type) {
        super.setText(text, type);
        if (this.enableStrikeThrough) {
            this.setPaintFlags(this.getPaintFlags() | 0x10);
        } else {
            this.setPaintFlags(this.getPaintFlags() & 0xFFFFFFEF);
        }
    }

    public void setEnableStrikeThrough(boolean enableStrikeThrough) {
        this.enableStrikeThrough = enableStrikeThrough;
    }
}

