/*
 * Decompiled with CFR 0.152.
 */
package com.github.cthawanapong.view;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.v4.content.ContextCompat;
import android.support.v4.widget.TextViewCompat;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.widget.TextView;
import com.github.cthawanapong.adapter.StyleableTextWatcherAdapter;
import com.github.cthawanapong.styleableviews.R;
import com.github.cthawanapong.view.StyleableEditText;

public class StyleableClearableEditText
extends StyleableEditText
implements View.OnTouchListener,
View.OnFocusChangeListener,
StyleableTextWatcherAdapter.StyleableTextWatcherListener {
    private static final String TAG = StyleableClearableEditText.class.getSimpleName();
    private Location loc = Location.RIGHT;
    private Drawable xD;
    private Listener listener;
    private View.OnTouchListener l;
    private View.OnFocusChangeListener f;

    public StyleableClearableEditText(Context context) {
        super(context);
        this.init();
    }

    public StyleableClearableEditText(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public StyleableClearableEditText(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    public void setListener(Listener listener) {
        this.listener = listener;
    }

    public void setIconLocation(Location loc) {
        this.loc = loc;
        this.initIcon();
    }

    public void setOnTouchListener(View.OnTouchListener l) {
        this.l = l;
    }

    public void setOnFocusChangeListener(View.OnFocusChangeListener f) {
        this.f = f;
    }

    public boolean onTouch(View v, MotionEvent event) {
        if (this.getDisplayedDrawable() != null) {
            boolean tappedX;
            int x = (int)event.getX();
            int y = (int)event.getY();
            int left = this.loc == Location.LEFT ? 0 : this.getWidth() - this.getPaddingRight() - this.xD.getIntrinsicWidth();
            int right = this.loc == Location.LEFT ? this.getPaddingLeft() + this.xD.getIntrinsicWidth() : this.getWidth();
            boolean bl = tappedX = x >= left && x <= right && y >= 0 && y <= this.getBottom() - this.getTop();
            if (tappedX) {
                if (event.getAction() == 1) {
                    this.setText("");
                    if (this.listener != null) {
                        this.listener.didClearText();
                    }
                }
                return true;
            }
        }
        if (this.l != null) {
            return this.l.onTouch(v, event);
        }
        return false;
    }

    public void onFocusChange(View v, boolean hasFocus) {
        if (hasFocus) {
            this.setClearIconVisible(!TextUtils.isEmpty((CharSequence)this.getText().toString()));
        } else {
            this.setClearIconVisible(false);
        }
        if (this.f != null) {
            this.f.onFocusChange(v, hasFocus);
        }
    }

    @Override
    public void onTextChanged(StyleableEditText view, String text) {
        if (this.isFocused()) {
            this.setClearIconVisible(!TextUtils.isEmpty((CharSequence)text));
        }
    }

    public void setCompoundDrawables(Drawable left, Drawable top, Drawable right, Drawable bottom) {
        super.setCompoundDrawables(left, top, right, bottom);
        this.initIcon();
    }

    private void init() {
        super.setOnTouchListener((View.OnTouchListener)this);
        super.setOnFocusChangeListener((View.OnFocusChangeListener)this);
        this.addTextChangedListener(new StyleableTextWatcherAdapter(this, this));
        this.initIcon();
        this.setClearIconVisible(false);
    }

    private void initIcon() {
        this.xD = null;
        if (this.loc != null) {
            this.xD = this.getCompoundDrawables()[this.loc.idx];
        }
        if (this.xD == null) {
            this.xD = ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.ic_cancel_text_input);
        }
        this.xD.setBounds(0, 0, this.xD.getIntrinsicWidth(), this.xD.getIntrinsicHeight());
        int min = this.getPaddingTop() + this.xD.getIntrinsicHeight() + this.getPaddingBottom();
        if (this.getSuggestedMinimumHeight() < min) {
            this.setMinimumHeight(min);
        }
    }

    private Drawable getDisplayedDrawable() {
        return this.loc != null ? this.getCompoundDrawables()[this.loc.idx] : null;
    }

    protected void setClearIconVisible(boolean visible) {
        boolean wasVisible;
        Drawable[] cd = this.getCompoundDrawables();
        Drawable displayed = this.getDisplayedDrawable();
        boolean bl = wasVisible = displayed != null;
        if (visible != wasVisible) {
            Drawable x = visible ? this.xD : null;
            TextViewCompat.setCompoundDrawablesRelativeWithIntrinsicBounds((TextView)this, (Drawable)(this.loc == Location.LEFT ? x : cd[0]), (Drawable)cd[1], (Drawable)(this.loc == Location.RIGHT ? x : cd[2]), (Drawable)cd[3]);
        }
    }

    public static interface Listener {
        public void didClearText();
    }

    public static enum Location {
        LEFT(0),
        RIGHT(2);

        final int idx;

        private Location(int idx) {
            this.idx = idx;
        }
    }
}

