/*
 * Decompiled with CFR 0.152.
 */
package amigro.tk.amigro;

import amigro.tk.amigro.Migration;
import android.app.Activity;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.preference.PreferenceManager;
import android.util.Log;
import java.util.TreeSet;

public class Amigro {
    private static final String TAG = "Amigro";
    private static final Amigro INSTANCE = new Amigro();
    public static final String MIGRATION_KEY = "Amigro_version";
    private final TreeSet<Migration> tasks = new TreeSet();

    private Amigro() {
    }

    public static Amigro getInstance() {
        return INSTANCE;
    }

    public void apply(Activity activity) {
        SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences((Context)activity);
        int latestVersion = prefs.getInt(MIGRATION_KEY, 0);
        SharedPreferences.Editor editor = prefs.edit();
        if (this.isFirstInstall(activity, latestVersion)) {
            if (this.tasks.size() > 0) {
                editor.putInt(MIGRATION_KEY, this.tasks.last().getVersion());
                editor.apply();
            }
            return;
        }
        for (Migration task : this.tasks) {
            if (task.getVersion() <= latestVersion) continue;
            task.execute();
            Log.d((String)TAG, (String)("Done migration at version: " + task.getVersion()));
            editor.putInt(MIGRATION_KEY, task.getVersion());
            latestVersion = task.getVersion();
        }
        editor.apply();
        this.tasks.clear();
    }

    public boolean isFirstInstall(Activity activity, int latestVersion) {
        try {
            long firstInstallTime = activity.getPackageManager().getPackageInfo((String)activity.getPackageName(), (int)0).firstInstallTime;
            long lastUpdateTime = activity.getPackageManager().getPackageInfo((String)activity.getPackageName(), (int)0).lastUpdateTime;
            Log.d((String)TAG, (String)("First Install Time: " + firstInstallTime + " Last update time: " + lastUpdateTime));
            return latestVersion <= 0;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return false;
        }
    }

    public Amigro addMigration(Migration migrateToVersionTask) {
        this.tasks.add(migrateToVersionTask);
        return this;
    }

    public Amigro addMigration(int version, Runnable migration) {
        this.tasks.add(new Migration(version, migration));
        return this;
    }
}

