/*
 * Decompiled with CFR 0.152.
 */
package redis.embedded.core;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import redis.embedded.RedisServer;
import redis.embedded.core.ExecutableProvider;

public final class RedisServerBuilder {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private ExecutableProvider provider = ExecutableProvider.newJarResourceProvider();
    private String bindAddress = "127.0.0.1";
    private int bindPort = 6379;
    private InetSocketAddress slaveOf;
    private boolean forceStop = false;
    private Consumer<String> soutListener;
    private Consumer<String> serrListener;
    private StringBuilder redisConfigBuilder = new StringBuilder();

    public RedisServerBuilder executableProvider(ExecutableProvider provider) {
        this.provider = provider;
        return this;
    }

    public RedisServerBuilder bind(String bind) {
        this.bindAddress = bind;
        return this;
    }

    public RedisServerBuilder port(int port) {
        this.bindPort = port;
        return this;
    }

    public RedisServerBuilder slaveOf(String hostname, int port) {
        this.slaveOf = new InetSocketAddress(hostname, port);
        return this;
    }

    public RedisServerBuilder slaveOf(InetSocketAddress slaveOf) {
        this.slaveOf = slaveOf;
        return this;
    }

    public RedisServerBuilder configFile(String redisConf) throws IOException {
        return this.configFile(Paths.get(redisConf, new String[0]));
    }

    public RedisServerBuilder configFile(Path redisConf) throws IOException {
        Files.lines(redisConf).forEach(line -> this.redisConfigBuilder.append((String)line).append(LINE_SEPARATOR));
        return this;
    }

    public RedisServerBuilder settingIf(boolean shouldSet, String configLine) {
        if (shouldSet) {
            this.setting(configLine);
        }
        return this;
    }

    public RedisServerBuilder setting(String configLine) {
        this.redisConfigBuilder.append(configLine).append(LINE_SEPARATOR);
        return this;
    }

    public RedisServerBuilder onShutdownForceStop(boolean forceStop) {
        this.forceStop = forceStop;
        return this;
    }

    public RedisServerBuilder soutListener(Consumer<String> soutListener) {
        this.soutListener = soutListener;
        return this;
    }

    public RedisServerBuilder serrListener(Consumer<String> serrListener) {
        this.serrListener = serrListener;
        return this;
    }

    public RedisServer build() throws IOException {
        return new RedisServer(this.bindPort, this.buildCommandArgs(), this.forceStop, this.soutListener, this.serrListener);
    }

    public void reset() {
        this.slaveOf = null;
    }

    public List<String> buildCommandArgs() throws IOException {
        this.setting("bind " + this.bindAddress);
        Path redisConfigFile = RedisServerBuilder.writeNewRedisConfigFile("embedded-redis-server_" + this.bindPort, this.redisConfigBuilder.toString());
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.provider.get().getAbsolutePath());
        args.add(redisConfigFile.toAbsolutePath().toString());
        args.add("--port");
        args.add(Integer.toString(this.bindPort));
        if (this.slaveOf != null) {
            args.add("--slaveof");
            args.add(this.slaveOf.getHostName());
            args.add(Integer.toString(this.slaveOf.getPort()));
        }
        return args;
    }

    private static Path writeNewRedisConfigFile(String prefix, String contents) throws IOException {
        Path redisConfigFile = Files.createTempFile(prefix, ".conf", new FileAttribute[0]);
        redisConfigFile.toFile().deleteOnExit();
        Files.write(redisConfigFile, contents.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        return redisConfigFile;
    }
}

