/*
 * Decompiled with CFR 0.152.
 */
package redis.embedded;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import redis.embedded.RedisInstance;
import redis.embedded.core.ExecutableProvider;
import redis.embedded.core.RedisServerBuilder;

public final class RedisServer
extends RedisInstance {
    public RedisServer() throws IOException {
        this(6379);
    }

    public RedisServer(int port) throws IOException {
        this(port, RedisServer.newRedisServer().port(port).buildCommandArgs(), false);
    }

    public RedisServer(int port, File executable) {
        this(port, Arrays.asList(executable.getAbsolutePath(), "--port", Integer.toString(port)), false);
    }

    public RedisServer(int port, ExecutableProvider executableProvider) throws IOException {
        this(port, Arrays.asList(executableProvider.get().getAbsolutePath(), "--port", Integer.toString(port)), false);
    }

    public RedisServer(int port, List<String> args, boolean forceStop) {
        super(port, args, SERVER_READY_PATTERN, forceStop, null, null);
    }

    public RedisServer(int port, List<String> args, boolean forceStop, Consumer<String> soutListener, Consumer<String> serrListener) {
        super(port, args, SERVER_READY_PATTERN, forceStop, soutListener, serrListener);
    }

    public static RedisServerBuilder newRedisServer() {
        return new RedisServerBuilder();
    }
}

