/*
 * Decompiled with CFR 0.152.
 */
package com.example.dynamikseekbar;

import android.graphics.Canvas;
import android.graphics.RectF;
import android.util.Log;

public class CreateFields {
    private RectF mark = new RectF();
    private RectF button1 = new RectF();
    private RectF button2 = new RectF();
    private RectF background = new RectF();
    private RectF way = new RectF();
    private RectF progress = new RectF();
    private String direct = "straight";
    private String orientation = "horizontal";
    private boolean visibleButtons = false;
    private float radiusWay = 5.0f;
    private float width;
    private float height;

    public static CreateFields get() {
        return new CreateFields();
    }

    public CreateFields setParams(Canvas c) {
        this.width = c.getWidth();
        this.height = c.getHeight();
        return this;
    }

    public CreateFields direct(String direct) {
        this.direct = direct;
        return this;
    }

    public CreateFields orientation(String orientation) {
        this.orientation = orientation;
        return this;
    }

    public CreateFields buttons(boolean visible) {
        this.visibleButtons = visible;
        return this;
    }

    public CreateFields radiusWay(float radius) {
        this.radiusWay = radius;
        return this;
    }

    public RectF mark(float loc) {
        this.createMark(loc);
        return this.mark;
    }

    public RectF progress(float loc) {
        this.createProgress(loc);
        return this.progress;
    }

    public RectF getProgress() {
        return this.progress;
    }

    protected void createProgress(float position) {
        if (this.direct.equals("back")) {
            if (this.orientation.equals("vertical")) {
                this.progress.set(this.way.left, position, this.way.right, this.way.bottom);
            } else {
                this.progress.set(position, this.way.top, this.way.right, this.way.bottom);
            }
        } else if (this.orientation.equals("vertical")) {
            this.progress.set(this.way.left, this.way.top, this.way.right, position);
        } else {
            this.progress.set(this.way.left, this.way.top, position, this.way.bottom);
        }
    }

    protected void createMark(float position) {
        if (this.direct.equals("back")) {
            float loc = (float)this.getLength() - this.indent() - ((float)this.getLength() - this.indent() - position);
            if (this.orientation.equals("vertical")) {
                this.mark.set(0.0f, loc - this.getRound() / 2.0f, this.getRound(), loc + this.getRound() / 2.0f);
            } else {
                this.mark.set(loc - this.getRound() / 2.0f, 0.0f, loc + this.getRound() / 2.0f, this.getRound());
            }
        } else if (this.orientation.equals("vertical")) {
            this.mark.set(0.0f, position - this.getRound() / 2.0f, this.getRound(), position + this.getRound() / 2.0f);
        } else {
            this.mark.set(position - this.getRound() / 2.0f, 0.0f, position + this.getRound() / 2.0f, this.getRound());
        }
    }

    protected void createButton1() {
        if (this.visibleButtons) {
            if (this.orientation.equals("vertical")) {
                this.button1.set(0.0f, 0.0f, this.getRound(), this.getRound());
            } else {
                this.button1.set(0.0f, 0.0f, this.getRound(), this.getRound());
            }
        } else {
            this.button1 = new RectF();
        }
    }

    protected void createButton2() {
        if (this.visibleButtons) {
            if (this.orientation.equals("vertical")) {
                this.button2.set(0.0f, (float)this.getLength() - this.getRound(), this.getRound(), (float)this.getLength());
            } else {
                this.button2.set((float)this.getLength() - this.getRound(), 0.0f, (float)this.getLength(), this.getRound());
            }
        } else {
            this.button2 = new RectF();
        }
    }

    protected void createWay() {
        if (this.orientation.equals("vertical")) {
            this.way.set(this.getCenterRound() - this.radiusWay / 2.0f, this.indent(), this.getCenterRound() + this.radiusWay / 2.0f, (float)this.getLength() - this.indent());
        } else {
            this.way.set(this.indent(), this.getCenterRound() - this.radiusWay / 2.0f, (float)this.getLength() - this.indent(), this.getCenterRound() + this.radiusWay / 2.0f);
        }
    }

    private void createBackground() {
        this.background.set(0.0f, 0.0f, this.width, this.height);
    }

    private float getCenterRound() {
        return this.getRound() / 2.0f;
    }

    private float getCenterLength() {
        return this.getLength() / 2L;
    }

    public float getLengthWay() {
        if (this.orientation.equals("vertical")) {
            return this.way.height();
        }
        return this.way.width();
    }

    public float getRound() {
        if (this.orientation.equals("vertical")) {
            return this.background.width();
        }
        return this.background.height();
    }

    public long getLength() {
        if (this.orientation.equals("vertical")) {
            return (long)this.background.height();
        }
        return (long)this.background.width();
    }

    public float indent() {
        if (this.visibleButtons) {
            return this.getRound() * 1.5f;
        }
        return this.getRound() * 0.5f;
    }

    public RectF getButton1() {
        this.createButton1();
        return this.button1;
    }

    public RectF getButton2() {
        this.createButton2();
        return this.button2;
    }

    public RectF getBackground() {
        this.createBackground();
        return this.background;
    }

    public RectF getWay() {
        this.createWay();
        return this.way;
    }

    public RectF getMark() {
        return this.mark;
    }

    public boolean isVisibleButtons() {
        return this.visibleButtons;
    }

    public String getOrientation() {
        return this.orientation;
    }

    public String getDirect() {
        return this.direct;
    }

    public float getRadiusWay() {
        return this.radiusWay;
    }

    private void MASSAGE(String t) {
        Log.d((String)"TAG", (String)t);
    }
}

