/*
 * Decompiled with CFR 0.152.
 */
package com.github.chenglei1986.statusbar;

import android.graphics.Color;
import android.graphics.LinearGradient;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.PaintDrawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.RectShape;
import android.graphics.drawable.shapes.Shape;
import android.util.LruCache;
import com.github.chenglei1986.statusbar.MathUtil;

final class ScrimUtil {
    private static final LruCache<Integer, Drawable> cubicGradientScrimCache = new LruCache(10);

    private ScrimUtil() {
    }

    public static Drawable makeCubicGradientScrimDrawable(int baseColor, int numStops, int gravity) {
        float y1;
        float y0;
        float x1;
        float x0;
        int cacheKeyHash = baseColor;
        cacheKeyHash = 31 * cacheKeyHash + numStops;
        Drawable cachedGradient = (Drawable)cubicGradientScrimCache.get((Object)(cacheKeyHash = 31 * cacheKeyHash + gravity));
        if (cachedGradient != null) {
            return cachedGradient;
        }
        numStops = Math.max(numStops, 2);
        PaintDrawable paintDrawable = new PaintDrawable();
        paintDrawable.setShape((Shape)new RectShape());
        final int[] stopColors = new int[numStops];
        int red = Color.red((int)baseColor);
        int green = Color.green((int)baseColor);
        int blue = Color.blue((int)baseColor);
        int alpha = Color.alpha((int)baseColor);
        for (int i = 0; i < numStops; ++i) {
            float x = (float)i * 1.0f / (float)(numStops - 1);
            float opacity = MathUtil.constrain(0.0f, 1.0f, (float)Math.pow(x, 3.0));
            stopColors[i] = Color.argb((int)((int)((float)alpha * opacity)), (int)red, (int)green, (int)blue);
        }
        switch (gravity & 7) {
            case 3: {
                x0 = 1.0f;
                x1 = 0.0f;
                break;
            }
            case 5: {
                x0 = 0.0f;
                x1 = 1.0f;
                break;
            }
            default: {
                x0 = 0.0f;
                x1 = 0.0f;
            }
        }
        switch (gravity & 0x70) {
            case 48: {
                y0 = 1.0f;
                y1 = 0.0f;
                break;
            }
            case 80: {
                y0 = 0.0f;
                y1 = 1.0f;
                break;
            }
            default: {
                y0 = 0.0f;
                y1 = 0.0f;
            }
        }
        paintDrawable.setShaderFactory(new ShapeDrawable.ShaderFactory(){

            public Shader resize(int width, int height) {
                return new LinearGradient((float)width * x0, (float)height * y0, (float)width * x1, (float)height * y1, stopColors, null, Shader.TileMode.CLAMP);
            }
        });
        cubicGradientScrimCache.put((Object)cacheKeyHash, (Object)paintDrawable);
        return paintDrawable;
    }
}

