/*
 * Decompiled with CFR 0.152.
 */
package com.github.chenglei1986.statusbar;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.github.chenglei1986.statusbar.BrandUtil;
import com.github.chenglei1986.statusbar.ColorUtil;
import com.github.chenglei1986.statusbar.ScrimUtil;
import com.github.chenglei1986.statusbar.StatusBarUtil;

public class StatusBarColorManager {
    private Activity mActivity;
    private ViewGroup mDecorView;
    private FrameLayout mStatusBarBackground;
    private int mStatusBarHeight;
    private int mActionBarHeight;
    private ViewGroup mContentView;

    public StatusBarColorManager(@NonNull Activity activity) {
        this.mActivity = activity;
        if (Build.VERSION.SDK_INT >= 19) {
            StatusBarUtil.setTranslucentStatus(this.mActivity);
            this.mDecorView = (ViewGroup)activity.getWindow().getDecorView();
            this.mContentView = (ViewGroup)((ViewGroup)this.mDecorView.findViewById(0x1020002)).getChildAt(0);
            if (null == this.mStatusBarBackground) {
                this.mStatusBarBackground = new FrameLayout((Context)activity);
            }
            this.mStatusBarHeight = StatusBarUtil.getStatusHeight(activity);
            this.mActionBarHeight = StatusBarUtil.getActionBarHeight((Context)activity);
        }
    }

    public void setStatusBarColor(@ColorInt int color, boolean layoutFullscreen, boolean withActionBar) {
        if (Build.VERSION.SDK_INT < 19) {
            return;
        }
        this.mDecorView.removeView((View)this.mStatusBarBackground);
        this.mStatusBarBackground.removeAllViews();
        if (ColorUtil.isLightColor(color)) {
            boolean darkMode = false;
            if (BrandUtil.checkBrand(BrandUtil.BRAND.XIAOMI)) {
                darkMode = StatusBarUtil.setMiuiStatusBarIconDarkMode(this.mActivity, true);
            } else if (BrandUtil.checkBrand(BrandUtil.BRAND.MEIZU)) {
                darkMode = StatusBarUtil.setFlymeStatusBarIconDarkMode(this.mActivity, true);
            }
            if (Build.VERSION.SDK_INT >= 21 && Build.VERSION.SDK_INT < 23) {
                if (!darkMode) {
                    View scrimView = new View((Context)this.mActivity);
                    scrimView.setBackground(ScrimUtil.makeCubicGradientScrimDrawable(-16777216, 8, 48));
                    this.mStatusBarBackground.addView(scrimView);
                }
            } else if (Build.VERSION.SDK_INT >= 23) {
                this.mDecorView.setSystemUiVisibility(this.mDecorView.getSystemUiVisibility() | 0x2000);
            }
        } else if (BrandUtil.checkBrand(BrandUtil.BRAND.XIAOMI)) {
            StatusBarUtil.setMiuiStatusBarIconDarkMode(this.mActivity, false);
        } else if (BrandUtil.checkBrand(BrandUtil.BRAND.MEIZU)) {
            StatusBarUtil.setFlymeStatusBarIconDarkMode(this.mActivity, false);
        }
        int contentViewPaddingTop = (layoutFullscreen ? 0 : this.mStatusBarHeight) + (withActionBar ? this.mActionBarHeight : 0);
        this.mContentView.setPadding(this.mContentView.getPaddingLeft(), contentViewPaddingTop, this.mContentView.getPaddingRight(), this.mContentView.getPaddingBottom());
        this.mStatusBarBackground.setBackgroundColor(layoutFullscreen ? 0 : color);
        this.mDecorView.addView((View)this.mStatusBarBackground, -1, this.mStatusBarHeight);
    }
}

