/*
 * Decompiled with CFR 0.152.
 */
package com.github.moduth.blockcanary.internal;

import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.os.Build;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Log;
import com.github.moduth.blockcanary.BlockCanaryInternals;
import com.github.moduth.blockcanary.internal.PerformanceUtils;
import com.github.moduth.blockcanary.internal.ProcessUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Locale;

public class BlockInfo {
    private static final String TAG = "BlockInfo";
    public static final SimpleDateFormat TIME_FORMATTER = new SimpleDateFormat("MM-dd HH:mm:ss.SSS", Locale.US);
    public static final String SEPARATOR = "\r\n";
    public static final String KV = " = ";
    public static final String NEW_INSTANCE_METHOD = "newInstance: ";
    public static final String KEY_QUA = "qua";
    public static final String KEY_MODEL = "model";
    public static final String KEY_API = "api-level";
    public static final String KEY_IMEI = "imei";
    public static final String KEY_UID = "uid";
    public static final String KEY_CPU_CORE = "cpu-core";
    public static final String KEY_CPU_BUSY = "cpu-busy";
    public static final String KEY_CPU_RATE = "cpu-rate";
    public static final String KEY_TIME_COST = "time";
    public static final String KEY_THREAD_TIME_COST = "thread-time";
    public static final String KEY_TIME_COST_START = "time-start";
    public static final String KEY_TIME_COST_END = "time-end";
    public static final String KEY_STACK = "stack";
    public static final String KEY_PROCESS = "process";
    public static final String KEY_VERSION_NAME = "versionName";
    public static final String KEY_VERSION_CODE = "versionCode";
    public static final String KEY_NETWORK = "network";
    public static final String KEY_TOTAL_MEMORY = "totalMemory";
    public static final String KEY_FREE_MEMORY = "freeMemory";
    public static final String KEY_IS_BACKGROUND = "background";
    public static String sQualifier;
    public static String sModel;
    public static String sApiLevel;
    public static String sImei;
    public static int sCpuCoreNum;
    public String qualifier;
    public String model;
    public String apiLevel = "";
    public String imei = "";
    public int cpuCoreNum = -1;
    public String uid;
    public String processName;
    public String versionName = "";
    public int versionCode;
    public String network;
    public String freeMemory;
    public String totalMemory;
    public long timeCost;
    public long threadTimeCost;
    public String timeStart;
    public String timeEnd;
    public boolean cpuBusy;
    public String cpuRateInfo;
    public ArrayList<String> threadStackEntries = new ArrayList();
    public boolean isBackground;
    private StringBuilder basicSb = new StringBuilder();
    private StringBuilder cpuSb = new StringBuilder();
    private StringBuilder timeSb = new StringBuilder();
    private StringBuilder stackSb = new StringBuilder();
    private static final String EMPTY_IMEI = "empty_imei";

    public static String getIMEI(Context context) {
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        String deviceId = telephonyManager.getDeviceId();
        if (TextUtils.isEmpty((CharSequence)deviceId)) {
            deviceId = Settings.System.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
        }
        return deviceId;
    }

    public static BlockInfo newInstance() {
        BlockInfo blockInfo = new BlockInfo();
        Context context = BlockCanaryInternals.getContext().provideContext();
        if (blockInfo.versionName == null || blockInfo.versionName.length() == 0) {
            try {
                PackageInfo info = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
                blockInfo.versionCode = info.versionCode;
                blockInfo.versionName = info.versionName;
            }
            catch (Throwable e) {
                Log.e((String)TAG, (String)NEW_INSTANCE_METHOD, (Throwable)e);
            }
        }
        blockInfo.cpuCoreNum = sCpuCoreNum;
        blockInfo.model = sModel;
        blockInfo.apiLevel = sApiLevel;
        blockInfo.qualifier = sQualifier;
        blockInfo.imei = sImei;
        blockInfo.uid = BlockCanaryInternals.getContext().provideUid();
        blockInfo.processName = ProcessUtils.myProcessName();
        blockInfo.network = BlockCanaryInternals.getContext().provideNetworkType();
        blockInfo.freeMemory = String.valueOf(PerformanceUtils.getFreeMemory());
        blockInfo.totalMemory = String.valueOf(PerformanceUtils.getTotalMemory());
        return blockInfo;
    }

    public BlockInfo setCpuBusyFlag(boolean busy) {
        this.cpuBusy = busy;
        return this;
    }

    public BlockInfo setRecentCpuRate(String info) {
        this.cpuRateInfo = info;
        return this;
    }

    public BlockInfo setThreadStackEntries(ArrayList<String> threadStackEntries) {
        this.threadStackEntries = threadStackEntries;
        return this;
    }

    public BlockInfo setMainThreadTimeCost(long realTimeStart, long realTimeEnd, long threadTimeStart, long threadTimeEnd) {
        this.timeCost = realTimeEnd - realTimeStart;
        this.threadTimeCost = threadTimeEnd - threadTimeStart;
        this.timeStart = TIME_FORMATTER.format(realTimeStart);
        this.timeEnd = TIME_FORMATTER.format(realTimeEnd);
        return this;
    }

    public BlockInfo setAppBackground(boolean background) {
        this.isBackground = background;
        return this;
    }

    public BlockInfo flushString() {
        String separator = SEPARATOR;
        this.basicSb.append(KEY_QUA).append(KV).append(this.qualifier).append(separator);
        this.basicSb.append(KEY_VERSION_NAME).append(KV).append(this.versionName).append(separator);
        this.basicSb.append(KEY_VERSION_CODE).append(KV).append(this.versionCode).append(separator);
        this.basicSb.append(KEY_IMEI).append(KV).append(this.imei).append(separator);
        this.basicSb.append(KEY_UID).append(KV).append(this.uid).append(separator);
        this.basicSb.append(KEY_NETWORK).append(KV).append(this.network).append(separator);
        this.basicSb.append(KEY_MODEL).append(KV).append(this.model).append(separator);
        this.basicSb.append(KEY_API).append(KV).append(this.apiLevel).append(separator);
        this.basicSb.append(KEY_CPU_CORE).append(KV).append(this.cpuCoreNum).append(separator);
        this.basicSb.append(KEY_PROCESS).append(KV).append(this.processName).append(separator);
        this.basicSb.append(KEY_FREE_MEMORY).append(KV).append(this.freeMemory).append(separator);
        this.basicSb.append(KEY_TOTAL_MEMORY).append(KV).append(this.totalMemory).append(separator);
        this.basicSb.append(KEY_IS_BACKGROUND).append(KV).append(this.isBackground).append(separator);
        this.timeSb.append(KEY_TIME_COST).append(KV).append(this.timeCost).append(separator);
        this.timeSb.append(KEY_THREAD_TIME_COST).append(KV).append(this.threadTimeCost).append(separator);
        this.timeSb.append(KEY_TIME_COST_START).append(KV).append(this.timeStart).append(separator);
        this.timeSb.append(KEY_TIME_COST_END).append(KV).append(this.timeEnd).append(separator);
        this.cpuSb.append(KEY_CPU_BUSY).append(KV).append(this.cpuBusy).append(separator);
        this.cpuSb.append(KEY_CPU_RATE).append(KV).append(this.cpuRateInfo).append(separator);
        if (this.threadStackEntries != null && !this.threadStackEntries.isEmpty()) {
            StringBuilder temp = new StringBuilder();
            for (String s : this.threadStackEntries) {
                temp.append(s);
                temp.append(separator);
            }
            this.stackSb.append(KEY_STACK).append(KV).append(temp.toString()).append(separator);
        }
        return this;
    }

    public String getBasicString() {
        return this.basicSb.toString();
    }

    public String getCpuString() {
        return this.cpuSb.toString();
    }

    public String getTimeString() {
        return this.timeSb.toString();
    }

    public String toString() {
        return String.valueOf(this.basicSb) + this.timeSb + this.cpuSb + this.stackSb;
    }

    static {
        sApiLevel = "";
        sImei = "";
        sCpuCoreNum = -1;
        sCpuCoreNum = PerformanceUtils.getNumCores();
        sModel = Build.MODEL;
        sApiLevel = Build.VERSION.SDK_INT + " " + Build.VERSION.RELEASE;
        sQualifier = BlockCanaryInternals.getContext().provideQualifier();
        try {
            sImei = BlockInfo.getIMEI(BlockCanaryInternals.getContext().provideContext());
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)NEW_INSTANCE_METHOD, (Throwable)exception);
            sImei = EMPTY_IMEI;
        }
    }
}

