/*
 * Decompiled with CFR 0.152.
 */
package com.github.moduth.blockcanary;

import android.os.Environment;
import android.os.Looper;
import com.github.moduth.blockcanary.BlockCanaryContext;
import com.github.moduth.blockcanary.BlockInterceptor;
import com.github.moduth.blockcanary.CpuSampler;
import com.github.moduth.blockcanary.LogWriter;
import com.github.moduth.blockcanary.LooperMonitor;
import com.github.moduth.blockcanary.StackSampler;
import com.github.moduth.blockcanary.internal.BackgroundUtil;
import com.github.moduth.blockcanary.internal.BlockInfo;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public final class BlockCanaryInternals {
    LooperMonitor monitor;
    StackSampler stackSampler;
    CpuSampler cpuSampler;
    private static BlockCanaryInternals sInstance;
    private static BlockCanaryContext sContext;
    private List<BlockInterceptor> mInterceptorChain = new LinkedList<BlockInterceptor>();

    public BlockCanaryInternals() {
        this.stackSampler = new StackSampler(Looper.getMainLooper().getThread(), sContext.provideDumpInterval());
        this.cpuSampler = new CpuSampler(sContext.provideDumpInterval());
        this.setMonitor(new LooperMonitor(new LooperMonitor.BlockListener(){

            @Override
            public void onBlockEvent(long realTimeStart, long realTimeEnd, long threadTimeStart, long threadTimeEnd) {
                ArrayList<String> threadStackEntries = BlockCanaryInternals.this.stackSampler.getThreadStackEntries(realTimeStart, realTimeEnd);
                if (!threadStackEntries.isEmpty()) {
                    BlockInfo blockInfo = BlockInfo.newInstance().setMainThreadTimeCost(realTimeStart, realTimeEnd, threadTimeStart, threadTimeEnd).setCpuBusyFlag(BlockCanaryInternals.this.cpuSampler.isCpuBusy(realTimeStart, realTimeEnd)).setRecentCpuRate(BlockCanaryInternals.this.cpuSampler.getCpuRateInfo()).setThreadStackEntries(threadStackEntries).setAppBackground(BackgroundUtil.isBackground(sContext.provideContext())).flushString();
                    LogWriter.save(blockInfo.toString());
                    if (BlockCanaryInternals.this.mInterceptorChain.size() != 0) {
                        for (BlockInterceptor interceptor : BlockCanaryInternals.this.mInterceptorChain) {
                            interceptor.onBlock(BlockCanaryInternals.getContext().provideContext(), blockInfo);
                        }
                    }
                }
            }
        }, BlockCanaryInternals.getContext().provideBlockThreshold(), BlockCanaryInternals.getContext().stopWhenDebugging()));
        LogWriter.cleanObsolete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static BlockCanaryInternals getInstance() {
        if (sInstance != null) return sInstance;
        Class<BlockCanaryInternals> clazz = BlockCanaryInternals.class;
        synchronized (BlockCanaryInternals.class) {
            if (sInstance != null) return sInstance;
            sInstance = new BlockCanaryInternals();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    public static void setContext(BlockCanaryContext context) {
        sContext = context;
    }

    public static BlockCanaryContext getContext() {
        return sContext;
    }

    void addBlockInterceptor(BlockInterceptor blockInterceptor) {
        this.mInterceptorChain.add(blockInterceptor);
    }

    private void setMonitor(LooperMonitor looperPrinter) {
        this.monitor = looperPrinter;
    }

    long getSampleDelay() {
        return (long)((float)BlockCanaryInternals.getContext().provideBlockThreshold() * 0.8f);
    }

    static String getPath() {
        String logPath;
        String state = Environment.getExternalStorageState();
        String string = logPath = BlockCanaryInternals.getContext() == null ? "" : BlockCanaryInternals.getContext().providePath();
        if ("mounted".equals(state) && Environment.getExternalStorageDirectory().canWrite()) {
            return Environment.getExternalStorageDirectory().getPath() + logPath;
        }
        return BlockCanaryInternals.getContext().provideContext().getFilesDir() + BlockCanaryInternals.getContext().providePath();
    }

    static File detectedBlockDirectory() {
        File directory = new File(BlockCanaryInternals.getPath());
        if (!directory.exists()) {
            directory.mkdirs();
        }
        return directory;
    }

    public static File[] getLogFiles() {
        File f = BlockCanaryInternals.detectedBlockDirectory();
        if (f.exists() && f.isDirectory()) {
            return f.listFiles(new BlockLogFileFilter());
        }
        return null;
    }

    private static class BlockLogFileFilter
    implements FilenameFilter {
        private String TYPE = ".log";

        BlockLogFileFilter() {
        }

        @Override
        public boolean accept(File dir, String filename) {
            return filename.endsWith(this.TYPE);
        }
    }
}

