/*
 * Decompiled with CFR 0.152.
 */
package com.github.moduth.blockcanary;

import com.github.moduth.blockcanary.BlockCanaryInternals;
import com.github.moduth.blockcanary.HandlerThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;

abstract class AbstractSampler {
    private static final int DEFAULT_SAMPLE_INTERVAL = 300;
    protected AtomicBoolean mShouldSample = new AtomicBoolean(false);
    protected long mSampleInterval;
    private Runnable mRunnable = new Runnable(){

        @Override
        public void run() {
            AbstractSampler.this.doSample();
            if (AbstractSampler.this.mShouldSample.get()) {
                HandlerThreadFactory.getTimerThreadHandler().postDelayed(AbstractSampler.this.mRunnable, AbstractSampler.this.mSampleInterval);
            }
        }
    };

    public AbstractSampler(long sampleInterval) {
        if (0L == sampleInterval) {
            sampleInterval = 300L;
        }
        this.mSampleInterval = sampleInterval;
    }

    public void start() {
        if (this.mShouldSample.get()) {
            return;
        }
        this.mShouldSample.set(true);
        HandlerThreadFactory.getTimerThreadHandler().removeCallbacks(this.mRunnable);
        HandlerThreadFactory.getTimerThreadHandler().postDelayed(this.mRunnable, BlockCanaryInternals.getInstance().getSampleDelay());
    }

    public void stop() {
        if (!this.mShouldSample.get()) {
            return;
        }
        this.mShouldSample.set(false);
        HandlerThreadFactory.getTimerThreadHandler().removeCallbacks(this.mRunnable);
    }

    abstract void doSample();
}

