/*
 * Decompiled with CFR 0.152.
 */
package com.github.moduth.blockcanary.internal;

import android.app.ActivityManager;
import android.content.Context;
import android.os.Process;
import com.github.moduth.blockcanary.BlockCanaryInternals;
import java.util.List;

public class ProcessUtils {
    private static volatile String sProcessName;
    private static final Object sNameLock;

    private ProcessUtils() {
        throw new InstantiationError("Must not instantiate this class");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String myProcessName() {
        if (sProcessName != null) {
            return sProcessName;
        }
        Object object = sNameLock;
        synchronized (object) {
            if (sProcessName != null) {
                return sProcessName;
            }
            sProcessName = ProcessUtils.obtainProcessName(BlockCanaryInternals.getContext().provideContext());
            return sProcessName;
        }
    }

    private static String obtainProcessName(Context context) {
        int pid = Process.myPid();
        ActivityManager am = (ActivityManager)context.getSystemService("activity");
        List listTaskInfo = am.getRunningAppProcesses();
        if (listTaskInfo != null && !listTaskInfo.isEmpty()) {
            for (ActivityManager.RunningAppProcessInfo info : listTaskInfo) {
                if (info == null || info.pid != pid) continue;
                return info.processName;
            }
        }
        return null;
    }

    static {
        sNameLock = new Object();
    }
}

