/*
 * Decompiled with CFR 0.152.
 */
package com.github.moduth.blockcanary.internal;

import android.app.ActivityManager;
import android.util.Log;
import com.github.moduth.blockcanary.BlockCanaryInternals;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.IOException;
import java.util.regex.Pattern;

class PerformanceUtils {
    private static final String TAG = "PerformanceUtils";
    private static int sCoreNum = 0;
    private static long sTotalMemo = 0L;

    private PerformanceUtils() {
        throw new InstantiationError("Must not instantiate this class");
    }

    public static int getNumCores() {
        if (sCoreNum == 0) {
            try {
                File dir = new File("/sys/devices/system/cpu/");
                class CpuFilter
                implements FileFilter {
                    CpuFilter() {
                    }

                    @Override
                    public boolean accept(File pathname) {
                        return Pattern.matches("cpu[0-9]", pathname.getName());
                    }
                }
                File[] files = dir.listFiles(new CpuFilter());
                sCoreNum = files.length;
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"getNumCores exception", (Throwable)e);
                sCoreNum = 1;
            }
        }
        return sCoreNum;
    }

    public static long getFreeMemory() {
        ActivityManager am = (ActivityManager)BlockCanaryInternals.getContext().provideContext().getSystemService("activity");
        ActivityManager.MemoryInfo mi = new ActivityManager.MemoryInfo();
        am.getMemoryInfo(mi);
        return mi.availMem / 1024L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getTotalMemory() {
        if (sTotalMemo == 0L) {
            String str1 = "/proc/meminfo";
            long initial_memory = -1L;
            FileReader localFileReader = null;
            try {
                localFileReader = new FileReader(str1);
                BufferedReader localBufferedReader = new BufferedReader(localFileReader, 8192);
                String str2 = localBufferedReader.readLine();
                if (str2 != null) {
                    String[] arrayOfString = str2.split("\\s+");
                    initial_memory = Integer.valueOf(arrayOfString[1]).intValue();
                }
                localBufferedReader.close();
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)"getTotalMemory exception = ", (Throwable)e);
            }
            finally {
                if (localFileReader != null) {
                    try {
                        localFileReader.close();
                    }
                    catch (IOException e) {
                        Log.e((String)TAG, (String)"close localFileReader exception = ", (Throwable)e);
                    }
                }
            }
            sTotalMemo = initial_memory;
        }
        return sTotalMemo;
    }
}

