/*
 * Decompiled with CFR 0.152.
 */
package com.github.moduth.blockcanary;

import android.os.Debug;
import android.os.SystemClock;
import android.util.Printer;
import com.github.moduth.blockcanary.BlockCanaryInternals;
import com.github.moduth.blockcanary.HandlerThreadFactory;

class LooperMonitor
implements Printer {
    private static final int DEFAULT_BLOCK_THRESHOLD_MILLIS = 3000;
    private long mBlockThresholdMillis = 3000L;
    private long mStartTimestamp = 0L;
    private long mStartThreadTimestamp = 0L;
    private BlockListener mBlockListener = null;
    private boolean mPrintingStarted = false;
    private final boolean mStopWhenDebugging;

    public LooperMonitor(BlockListener blockListener, long blockThresholdMillis, boolean stopWhenDebugging) {
        if (blockListener == null) {
            throw new IllegalArgumentException("blockListener should not be null.");
        }
        this.mBlockListener = blockListener;
        this.mBlockThresholdMillis = blockThresholdMillis;
        this.mStopWhenDebugging = stopWhenDebugging;
    }

    public void println(String x) {
        if (this.mStopWhenDebugging && Debug.isDebuggerConnected()) {
            return;
        }
        if (!this.mPrintingStarted) {
            this.mStartTimestamp = System.currentTimeMillis();
            this.mStartThreadTimestamp = SystemClock.currentThreadTimeMillis();
            this.mPrintingStarted = true;
            this.startDump();
        } else {
            long endTime = System.currentTimeMillis();
            this.mPrintingStarted = false;
            if (this.isBlock(endTime)) {
                this.notifyBlockEvent(endTime);
            }
            this.stopDump();
        }
    }

    private boolean isBlock(long endTime) {
        return endTime - this.mStartTimestamp > this.mBlockThresholdMillis;
    }

    private void notifyBlockEvent(final long endTime) {
        final long startTime = this.mStartTimestamp;
        final long startThreadTime = this.mStartThreadTimestamp;
        final long endThreadTime = SystemClock.currentThreadTimeMillis();
        HandlerThreadFactory.getWriteLogThreadHandler().post(new Runnable(){

            @Override
            public void run() {
                LooperMonitor.this.mBlockListener.onBlockEvent(startTime, endTime, startThreadTime, endThreadTime);
            }
        });
    }

    private void startDump() {
        if (null != BlockCanaryInternals.getInstance().stackSampler) {
            BlockCanaryInternals.getInstance().stackSampler.start();
        }
        if (null != BlockCanaryInternals.getInstance().cpuSampler) {
            BlockCanaryInternals.getInstance().cpuSampler.start();
        }
    }

    private void stopDump() {
        if (null != BlockCanaryInternals.getInstance().stackSampler) {
            BlockCanaryInternals.getInstance().stackSampler.stop();
        }
        if (null != BlockCanaryInternals.getInstance().cpuSampler) {
            BlockCanaryInternals.getInstance().cpuSampler.stop();
        }
    }

    public static interface BlockListener {
        public void onBlockEvent(long var1, long var3, long var5, long var7);
    }
}

