/*
 * Decompiled with CFR 0.152.
 */
package com.github.bucket4j.local;

import com.github.bucket4j.AbstractBucket;
import com.github.bucket4j.Bandwidth;
import com.github.bucket4j.BucketConfiguration;
import com.github.bucket4j.BucketState;

public class UnsafeBucket
extends AbstractBucket {
    private final BucketState state;
    private final BucketConfiguration configuration;

    public UnsafeBucket(BucketConfiguration configuration) {
        super(configuration);
        this.configuration = configuration;
        this.state = BucketState.createInitialState(configuration);
    }

    @Override
    protected long consumeAsMuchAsPossibleImpl(long limit) {
        Bandwidth[] bandwidths = this.configuration.getBandwidths();
        long currentTimeNanos = this.configuration.getTimeMeter().currentTimeNanos();
        this.state.refillAllBandwidth(bandwidths, currentTimeNanos);
        long availableToConsume = this.state.getAvailableTokens(bandwidths);
        long toConsume = Math.min(limit, availableToConsume);
        if (toConsume == 0L) {
            return 0L;
        }
        this.state.consume(bandwidths, toConsume);
        return toConsume;
    }

    @Override
    protected boolean tryConsumeImpl(long tokensToConsume) {
        Bandwidth[] bandwidths = this.configuration.getBandwidths();
        long currentTimeNanos = this.configuration.getTimeMeter().currentTimeNanos();
        this.state.refillAllBandwidth(bandwidths, currentTimeNanos);
        long availableToConsume = this.state.getAvailableTokens(bandwidths);
        if (tokensToConsume > availableToConsume) {
            return false;
        }
        this.state.consume(bandwidths, tokensToConsume);
        return true;
    }

    @Override
    protected boolean consumeOrAwaitImpl(long tokensToConsume, long waitIfBusyTimeLimit) throws InterruptedException {
        long methodStartTimeNanos;
        Bandwidth[] bandwidths = this.configuration.getBandwidths();
        boolean isWaitingLimited = waitIfBusyTimeLimit > 0L;
        long currentTimeNanos = methodStartTimeNanos = this.configuration.getTimeMeter().currentTimeNanos();
        long methodDuration = 0L;
        boolean isFirstCycle = true;
        while (true) {
            long sleepingTimeLimit;
            if (isFirstCycle) {
                isFirstCycle = false;
            } else {
                currentTimeNanos = this.configuration.getTimeMeter().currentTimeNanos();
                methodDuration = currentTimeNanos - methodStartTimeNanos;
                if (isWaitingLimited && methodDuration >= waitIfBusyTimeLimit) {
                    return false;
                }
            }
            this.state.refillAllBandwidth(bandwidths, currentTimeNanos);
            long nanosToCloseDeficit = this.state.delayNanosAfterWillBePossibleToConsume(bandwidths, currentTimeNanos, tokensToConsume);
            if (nanosToCloseDeficit == Long.MAX_VALUE) {
                return false;
            }
            if (nanosToCloseDeficit == 0L) {
                this.state.consume(bandwidths, tokensToConsume);
                return true;
            }
            if (isWaitingLimited && nanosToCloseDeficit >= (sleepingTimeLimit = waitIfBusyTimeLimit - methodDuration)) {
                return false;
            }
            this.configuration.getTimeMeter().parkNanos(nanosToCloseDeficit);
        }
    }

    @Override
    public BucketState createSnapshot() {
        return this.state.clone();
    }

    public String toString() {
        return "LockFreeBucket{state=" + this.state + ", configuration=" + this.configuration + '}';
    }
}

