/*
 * Decompiled with CFR 0.152.
 */
package com.github.bucket4j.local;

import com.github.bucket4j.AbstractBucket;
import com.github.bucket4j.Bandwidth;
import com.github.bucket4j.BucketConfiguration;
import com.github.bucket4j.BucketState;

public class SynchronizedBucket
extends AbstractBucket {
    private final BucketState state;
    private final BucketConfiguration configuration;

    public SynchronizedBucket(BucketConfiguration configuration) {
        super(configuration);
        this.configuration = configuration;
        this.state = BucketState.createInitialState(configuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected long consumeAsMuchAsPossibleImpl(long limit) {
        SynchronizedBucket synchronizedBucket = this;
        synchronized (synchronizedBucket) {
            Bandwidth[] bandwidths = this.configuration.getBandwidths();
            long currentTimeNanos = this.configuration.getTimeMeter().currentTimeNanos();
            this.state.refillAllBandwidth(bandwidths, currentTimeNanos);
            long availableToConsume = this.state.getAvailableTokens(bandwidths);
            long toConsume = Math.min(limit, availableToConsume);
            if (toConsume == 0L) {
                return 0L;
            }
            this.state.consume(bandwidths, toConsume);
            return toConsume;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean tryConsumeImpl(long tokensToConsume) {
        SynchronizedBucket synchronizedBucket = this;
        synchronized (synchronizedBucket) {
            Bandwidth[] bandwidths = this.configuration.getBandwidths();
            long currentTimeNanos = this.configuration.getTimeMeter().currentTimeNanos();
            this.state.refillAllBandwidth(bandwidths, currentTimeNanos);
            long availableToConsume = this.state.getAvailableTokens(bandwidths);
            if (tokensToConsume > availableToConsume) {
                return false;
            }
            this.state.consume(bandwidths, tokensToConsume);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean consumeOrAwaitImpl(long tokensToConsume, long waitIfBusyTimeLimit) throws InterruptedException {
        long methodStartTimeNanos;
        Bandwidth[] bandwidths = this.configuration.getBandwidths();
        boolean isWaitingLimited = waitIfBusyTimeLimit > 0L;
        long currentTimeNanos = methodStartTimeNanos = this.configuration.getTimeMeter().currentTimeNanos();
        long methodDuration = 0L;
        boolean isFirstCycle = true;
        while (true) {
            long nanosToCloseDeficit;
            SynchronizedBucket synchronizedBucket = this;
            synchronized (synchronizedBucket) {
                long sleepingTimeLimit;
                if (isFirstCycle) {
                    isFirstCycle = false;
                } else {
                    currentTimeNanos = this.configuration.getTimeMeter().currentTimeNanos();
                    methodDuration = currentTimeNanos - methodStartTimeNanos;
                    if (isWaitingLimited && methodDuration >= waitIfBusyTimeLimit) {
                        return false;
                    }
                }
                this.state.refillAllBandwidth(bandwidths, currentTimeNanos);
                nanosToCloseDeficit = this.state.delayNanosAfterWillBePossibleToConsume(bandwidths, currentTimeNanos, tokensToConsume);
                if (nanosToCloseDeficit == Long.MAX_VALUE) {
                    return false;
                }
                if (nanosToCloseDeficit == 0L) {
                    this.state.consume(bandwidths, tokensToConsume);
                    return true;
                }
                if (isWaitingLimited && nanosToCloseDeficit >= (sleepingTimeLimit = waitIfBusyTimeLimit - methodDuration)) {
                    return false;
                }
            }
            this.configuration.getTimeMeter().parkNanos(nanosToCloseDeficit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BucketState createSnapshot() {
        SynchronizedBucket synchronizedBucket = this;
        synchronized (synchronizedBucket) {
            return this.state.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        SynchronizedBucket synchronizedBucket = this;
        synchronized (synchronizedBucket) {
            return "SynchronizedBucket{state=" + this.state + ", configuration=" + this.configuration + '}';
        }
    }
}

