/*
 * Decompiled with CFR 0.152.
 */
package com.github.bucket4j.local;

import com.github.bucket4j.AbstractBucket;
import com.github.bucket4j.Bandwidth;
import com.github.bucket4j.BucketConfiguration;
import com.github.bucket4j.BucketState;
import java.util.concurrent.atomic.AtomicReference;

public class LockFreeBucket
extends AbstractBucket {
    private final AtomicReference<BucketState> stateReference;
    private final BucketConfiguration configuration;

    public LockFreeBucket(BucketConfiguration configuration) {
        super(configuration);
        this.configuration = configuration;
        BucketState initialState = BucketState.createInitialState(configuration);
        this.stateReference = new AtomicReference<BucketState>(initialState);
    }

    @Override
    protected long consumeAsMuchAsPossibleImpl(long limit) {
        BucketState previousState = this.stateReference.get();
        BucketState newState = previousState.clone();
        Bandwidth[] limits = this.configuration.getBandwidths();
        long currentTimeNanos = this.configuration.getTimeMeter().currentTimeNanos();
        while (true) {
            newState.refillAllBandwidth(limits, currentTimeNanos);
            long availableToConsume = newState.getAvailableTokens(limits);
            long toConsume = Math.min(limit, availableToConsume);
            if (toConsume == 0L) {
                return 0L;
            }
            newState.consume(limits, toConsume);
            if (this.stateReference.compareAndSet(previousState, newState)) {
                return toConsume;
            }
            previousState = this.stateReference.get();
            newState.copyStateFrom(previousState);
        }
    }

    @Override
    protected boolean tryConsumeImpl(long tokensToConsume) {
        BucketState previousState = this.stateReference.get();
        BucketState newState = previousState.clone();
        Bandwidth[] limits = this.configuration.getBandwidths();
        long currentTimeNanos = this.configuration.getTimeMeter().currentTimeNanos();
        while (true) {
            newState.refillAllBandwidth(limits, currentTimeNanos);
            long availableToConsume = newState.getAvailableTokens(limits);
            if (tokensToConsume > availableToConsume) {
                return false;
            }
            newState.consume(limits, tokensToConsume);
            if (this.stateReference.compareAndSet(previousState, newState)) {
                return true;
            }
            previousState = this.stateReference.get();
            newState.copyStateFrom(previousState);
        }
    }

    @Override
    protected boolean consumeOrAwaitImpl(long tokensToConsume, long waitIfBusyTimeLimit) throws InterruptedException {
        long methodStartTimeNanos;
        Bandwidth[] limits = this.configuration.getBandwidths();
        boolean isWaitingLimited = waitIfBusyTimeLimit > 0L;
        long currentTimeNanos = methodStartTimeNanos = this.configuration.getTimeMeter().currentTimeNanos();
        long methodDuration = 0L;
        boolean isFirstCycle = true;
        BucketState previousState = this.stateReference.get();
        BucketState newState = previousState.clone();
        while (true) {
            long sleepingTimeLimit;
            if (isFirstCycle) {
                isFirstCycle = false;
            } else {
                currentTimeNanos = this.configuration.getTimeMeter().currentTimeNanos();
                methodDuration = currentTimeNanos - methodStartTimeNanos;
                if (isWaitingLimited && methodDuration >= waitIfBusyTimeLimit) {
                    return false;
                }
                previousState = this.stateReference.get();
                newState.copyStateFrom(previousState);
            }
            newState.refillAllBandwidth(limits, currentTimeNanos);
            long nanosToCloseDeficit = newState.delayNanosAfterWillBePossibleToConsume(limits, currentTimeNanos, tokensToConsume);
            if (nanosToCloseDeficit == Long.MAX_VALUE) {
                return false;
            }
            if (nanosToCloseDeficit == 0L) {
                newState.consume(limits, tokensToConsume);
                if (!this.stateReference.compareAndSet(previousState, newState)) continue;
                return true;
            }
            if (isWaitingLimited && nanosToCloseDeficit >= (sleepingTimeLimit = waitIfBusyTimeLimit - methodDuration)) {
                return false;
            }
            this.configuration.getTimeMeter().parkNanos(nanosToCloseDeficit);
        }
    }

    @Override
    public BucketState createSnapshot() {
        return this.stateReference.get().clone();
    }

    public String toString() {
        return "LockFreeBucket{state=" + this.stateReference.get() + ", configuration=" + this.configuration + '}';
    }
}

