/*
 * Decompiled with CFR 0.152.
 */
package com.github.bucket4j.local;

import com.github.bucket4j.AbstractBucketBuilder;
import com.github.bucket4j.Bucket;
import com.github.bucket4j.BucketConfiguration;
import com.github.bucket4j.local.LockFreeBucket;
import com.github.bucket4j.local.SynchronizationStrategy;
import com.github.bucket4j.local.SynchronizedBucket;
import com.github.bucket4j.local.UnsafeBucket;

public class LocalBucketBuilder
extends AbstractBucketBuilder<LocalBucketBuilder> {
    public Bucket build() {
        return this.build(SynchronizationStrategy.LOCK_FREE);
    }

    public Bucket build(SynchronizationStrategy synchronizationStrategy) {
        BucketConfiguration configuration = this.createConfiguration();
        switch (synchronizationStrategy) {
            case LOCK_FREE: {
                return new LockFreeBucket(configuration);
            }
            case SYNCHRONIZED: {
                return new SynchronizedBucket(configuration);
            }
            case NONE: {
                return new UnsafeBucket(configuration);
            }
        }
        throw new IllegalStateException();
    }
}

